/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionGroup;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;

public final class OutboundConnectionCache {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(OutboundConnectionCache.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc2 = Tr.register(CleanupTask.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static int REFRESHTIME = 0;
    private static final int DELAYTIME = 1000;
    private static int CONN_TIMEOUT = 0;
    private static int MAX_CONN = 0;
    private static int EIGHTY_PERCENT = 0;
    private HashMap chainlist = null;
    private LinkedList tempPool = null;
    private static int reqCounter = 0;
    private static OutboundConnectionCache cache = null;
    private static Timer _timer = null;

    private OutboundConnectionCache() {
        _timer = new Timer(true);
        _timer.schedule((TimerTask)new CleanupTask(), 1000L, (long)REFRESHTIME);
        this.chainlist = new HashMap();
        this.tempPool = new LinkedList();
        EIGHTY_PERCENT = Math.round(MAX_CONN * 4 / 5);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionTimeout: " + CONN_TIMEOUT + " ms, " + "com.ibm.websphere.webservices.http.connectionPoolCleanUpTime" + ": " + REFRESHTIME + " ms, " + "com.ibm.websphere.webservices.http.maxConnection" + ": " + MAX_CONN);
        }
    }

    public static int maxConnection() {
        return MAX_CONN;
    }

    public static int connTimeout() {
        return CONN_TIMEOUT;
    }

    public static synchronized OutboundConnectionCache getInstance() {
        if (cache == null) {
            cache = new OutboundConnectionCache();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSOutboundConnection findConnectionAndInvalidate(WSAddress addrtoConnect) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        WSOutboundConnection wsOC = null;
        OutboundConnectionGroup oCGroup = null;
        String keyname = addrtoConnect.keyValueforPool();
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            oCGroup = (OutboundConnectionGroup)this.chainlist.get(keyname);
            if (oCGroup != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("connTableKeyFound", keyname, "true"));
                }
                wsOC = oCGroup.invalidateConnection(addrtoConnect);
            }
            WSOutboundConnection tmpConnObj = null;
            ListIterator lIt = this.tempPool.listIterator(0);
            if (lIt != null) {
                while (lIt.hasNext()) {
                    tmpConnObj = (WSOutboundConnection)lIt.next();
                    if (!tmpConnObj.groupID().equals(keyname)) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, Messages.getMessage("invalidatedConnObject01", addrtoConnect.toString(), tmpConnObj.toString()));
                    }
                    tmpConnObj.release(null);
                    lIt.remove();
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        return wsOC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSOutboundConnection findGroupAndGetConnection(WSAddress addrtoConnect) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
        }
        WSOutboundConnection wsOC = null;
        OutboundConnectionGroup oCGroup = null;
        String keyname = addrtoConnect.keyValueforPool();
        int totalSize = 0;
        int totalUsed = 0;
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            if (!this.chainlist.containsKey(keyname)) {
                oCGroup = new OutboundConnectionGroup();
                this.chainlist.put(keyname, oCGroup);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("outConnGroupCreated", keyname));
                }
            } else {
                oCGroup = (OutboundConnectionGroup)this.chainlist.get(keyname);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("connTableKeyFound", keyname, "true"));
                }
            }
        }
        hashMap = this.chainlist;
        synchronized (hashMap) {
            while (wsOC == null) {
                totalSize = this.poolSize() + this.tempPool.size();
                totalUsed = this.connectionsInUse();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("enter00", Messages.getMessage("connPoolStatus00", String.valueOf(totalSize), String.valueOf(totalUsed), String.valueOf(MAX_CONN))));
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
                }
                if (totalSize < MAX_CONN) {
                    if (oCGroup.currPoolSize() > oCGroup.totalInUse()) {
                        wsOC = oCGroup.getConnection(addrtoConnect);
                    }
                    if (wsOC != null) break;
                    wsOC = oCGroup.createConnection(addrtoConnect);
                    break;
                }
                if (totalSize == MAX_CONN) {
                    long targetWaitTime = CONN_TIMEOUT;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
                    }
                    if (this.tempPool.size() > 0) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Local pool is available for faster access.");
                        }
                        try {
                            wsOC = (WSOutboundConnection)this.tempPool.removeFirst();
                        }
                        catch (NoSuchElementException nSE) {
                            wsOC = null;
                        }
                        if (wsOC != null) {
                            wsOC = oCGroup.addConnection(addrtoConnect, wsOC, keyname);
                            break;
                        }
                    } else {
                        int inUseSize;
                        int cpoolSize = oCGroup.currPoolSize();
                        if (cpoolSize > (inUseSize = oCGroup.totalInUse())) {
                            wsOC = oCGroup.getConnection(addrtoConnect);
                        } else if (cpoolSize == inUseSize) {
                            if (this.purgeUnused()) {
                                wsOC = oCGroup.createConnection(addrtoConnect);
                            }
                        } else {
                            throw new WebServicesFault(Messages.getMessage("connectionPoolIntegrity00"));
                        }
                        if (wsOC != null) break;
                    }
                    if (CONN_TIMEOUT == 0) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("connectionWait00", Thread.currentThread().toString()));
                        }
                        this.chainlist.wait();
                        if (!_tc.isEventEnabled()) continue;
                        Tr.event(_tc, Messages.getMessage("connectionNotify01", Thread.currentThread().toString()));
                        continue;
                    }
                    long actualWaitTime = 0L;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("connectionWait01", Thread.currentThread().toString(), String.valueOf(targetWaitTime)));
                    }
                    long start = System.currentTimeMillis();
                    this.chainlist.wait(targetWaitTime);
                    actualWaitTime = System.currentTimeMillis() - start;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("connectionNotify01", Thread.currentThread().toString()));
                    }
                    if (targetWaitTime - actualWaitTime > 0L) continue;
                    throw new WebServicesFault(Messages.getMessage("connectionTimedOut"));
                }
                throw new WebServicesFault(Messages.getMessage("connectionPoolIntegrity00"));
            }
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
        }
        return wsOC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findGroupAndReturnConnection(WSOutboundConnection wOC) throws ChainException, ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
        }
        String activeChainName = wOC.getTargetAddress().keyValueforPool();
        OutboundConnectionGroup ocgroup = null;
        ocgroup = (OutboundConnectionGroup)this.chainlist.get(activeChainName);
        if (ocgroup == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("connTableKeyFound", activeChainName, "false"));
            }
            return;
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("connTableKeyFound", activeChainName, "true"));
        }
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Unused objects in findGroupAndReturnConnection::tempPool size: " + this.tempPool.size());
            }
            int totalSize = this.poolSize() + this.tempPool.size();
            int totalUsed = this.connectionsInUse();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("enter00", "findGroupAndReturnConnection() - " + Messages.getMessage("connPoolStatus00", String.valueOf(totalSize), String.valueOf(totalUsed), String.valueOf(MAX_CONN))));
            }
            if (totalSize == MAX_CONN && totalUsed > EIGHTY_PERCENT) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "The default object pool is close to be full. Place the object in a local pool for faster access.");
                }
                ocgroup.returnConnection(wOC, true);
                this.tempPool.add(wOC);
            } else {
                ocgroup.returnConnection(wOC, false);
            }
            this.chainlist.notify();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("connectionNotify00"));
            }
            if (_tc.isEventEnabled()) {
                totalSize = this.poolSize() + this.tempPool.size();
                totalUsed = this.connectionsInUse();
                Tr.event(_tc, Messages.getMessage("exit00", "findGroupAndReturnConnection() - " + Messages.getMessage("connPoolStatus00", String.valueOf(totalSize), String.valueOf(totalUsed), String.valueOf(MAX_CONN))));
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Unused objects in findGroupAndReturnConnection::tempPool: " + this.tempPool.size());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
        }
    }

    private boolean purgeUnused() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "purgeUnused()");
        }
        boolean foundUnused = false;
        Iterator it = this.chainlist.keySet().iterator();
        OutboundConnectionGroup oCG = null;
        while (it.hasNext()) {
            oCG = (OutboundConnectionGroup)this.chainlist.get(it.next());
            if (oCG.currPoolSize() > oCG.totalInUse()) {
                foundUnused = oCG.findUnused();
            }
            if (!foundUnused) continue;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "purgeUnused()");
        }
        return foundUnused;
    }

    protected int poolSize() {
        int result = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "poolSize()");
        }
        Iterator it = this.chainlist.keySet().iterator();
        OutboundConnectionGroup oCG = null;
        while (it.hasNext()) {
            oCG = (OutboundConnectionGroup)this.chainlist.get(it.next());
            result += oCG.currPoolSize();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "poolSize()");
        }
        return result;
    }

    protected int connectionsInUse() {
        int result = 0;
        OutboundConnectionGroup oCG = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "connectionsInUse()");
        }
        Iterator it = this.chainlist.keySet().iterator();
        while (it.hasNext()) {
            oCG = (OutboundConnectionGroup)this.chainlist.get(it.next());
            result += oCG.totalInUse();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "connectionsInUse()");
        }
        return result;
    }

    static {
        CONN_TIMEOUT = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionTimeout", "300")) * 1000;
        REFRESHTIME = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionPoolCleanUpTime", "180")) * 1000;
        MAX_CONN = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.maxConnection", "25"));
        if (MAX_CONN < 5) {
            MAX_CONN = 5;
        }
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                OutboundConnectionGroup ocgroup = null;
                try {
                    if (_tc2.isEntryEnabled()) {
                        Tr.entry(_tc2, "CleanupTask.run()");
                    }
                    HashMap hashMap = OutboundConnectionCache.this.chainlist;
                    synchronized (hashMap) {
                        if (OutboundConnectionCache.this.chainlist.size() > 0) {
                            Iterator it = OutboundConnectionCache.this.chainlist.keySet().iterator();
                            Object key = null;
                            while (it.hasNext()) {
                                key = it.next();
                                ocgroup = (OutboundConnectionGroup)OutboundConnectionCache.this.chainlist.get(key);
                                ocgroup.cleanup();
                                if (!ocgroup.isEmpty()) continue;
                                if (_tc2.isDebugEnabled()) {
                                    Tr.debug(_tc2, "OutboundConnectionGroup.isEmpty(): true");
                                }
                                ocgroup.release();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache", "163", this);
                    if (!_tc2.isEventEnabled()) break block9;
                    Tr.event(_tc2, Messages.getMessage("exception01", JavaUtils.stackToString(ex)));
                }
            }
        }
    }
}

