/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxws;

import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.handler.HandlerPostInvoker;
import org.apache.axis2.jaxws.handler.SoapMessageContext;

public class HandlerPostInvokerImpl
implements HandlerPostInvoker {
    public void postInvoke(MessageContext mc) {
        this.checkProtectedStateViolation(mc);
    }

    private void checkProtectedStateViolation(MessageContext mc) {
        if (mc instanceof SoapMessageContext) {
            SoapMessageContext smc = (SoapMessageContext)mc;
            SOAPMessage msg = smc.getMessage();
            if (msg == null) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("jaxRpcHandlerProtectedStateViolation02"));
            }
            try {
                SOAPPart part = msg.getSOAPPart();
                if (part == null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("jaxRpcHandlerProtectedStateViolation01"));
                }
                SOAPEnvelope env = (SOAPEnvelope)part.getEnvelope();
                if (env.getSOAPFactory().getProtectionViolation()) {
                    env.getSOAPFactory().setProtectState(false);
                    env.getBody().detachNode();
                    SOAPFault soapFault = env.getSOAPFactory().createSOAPFault();
                    soapFault.setFault(WebServicesFault.makeFault(new RuntimeException("handler has violated message protection")));
                    throw new SOAPFaultException((javax.xml.soap.SOAPFault)soapFault);
                }
            }
            catch (SOAPException se) {
                throw new RuntimeException(se);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException(cce);
            }
        }
    }
}

