/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ClosureHandler;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PreHandler;
import com.ibm.ws.webservices.engine.SimpleChain;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.dispatchers.GreenDispatcher;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class JAXRPCHandler
extends SimpleTargetedChain {
    protected static Log log = LogFactory.getLog(JAXRPCHandler.class.getName());
    public static final int MODE_CS_CLIENT = 1;
    public static final int MODE_CS_SERVER = 2;
    private static Collection _defaultActors = new TreeSet();
    private int _modeClientServer = 0;
    private ActorHeaderBindings _actorHeaderBindings = new ActorHeaderBindings();
    private ActorHeaderBindings _handlerChainActorHeaderBindings = null;
    private ActorHeaderBindings _allActorHeaderBindings = null;
    private Collection _globalHandlerHeaders = null;
    private HandlerChain _handlerChain;
    private static final Set booleanOptions;

    public JAXRPCHandler() throws ConfigurationException {
        this(null, null, null);
    }

    public JAXRPCHandler(Handler serviceHandler) {
        this(null, serviceHandler, null);
    }

    public JAXRPCHandler(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        super(reqHandler, pivHandler, respHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws WebServicesFault {
        block3: {
            if (this.getPivotHandler() instanceof GreenDispatcher) {
                GreenDispatcher dispatcher = (GreenDispatcher)((Object)this.getPivotHandler());
                dispatcher.setupEnvironment(msgContext);
                try {
                    super.invoke(msgContext);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    dispatcher.cleanupEnvironment(msgContext);
                    throw throwable;
                }
                dispatcher.cleanupEnvironment(msgContext);
                {
                    break block3;
                }
            }
            super.invoke(msgContext);
        }
    }

    public static Handler factory(Handler reqHandler, Handler pivHandler, Handler respHandler, HandlerChain handlerChain, ActorHeaderBindings bindings, int modeClientServer) {
        if (reqHandler == null && respHandler == null && handlerChain == null && bindings == null) {
            return pivHandler;
        }
        JAXRPCHandler jaxrpcHandler = new JAXRPCHandler(reqHandler, pivHandler, respHandler);
        jaxrpcHandler.setModeClientServer(modeClientServer);
        if (handlerChain != null) {
            jaxrpcHandler.setHandlerChain(handlerChain);
        }
        if (bindings != null) {
            jaxrpcHandler.setActorHeaderBinding(bindings);
        }
        return jaxrpcHandler;
    }

    protected final Handler adjustRequestHandler(Handler reqHandler) {
        Handler requestHandler = super.adjustRequestHandler(reqHandler);
        if (this.getModeClientServer() == 2) {
            return SimpleChain.mergeHandlers(requestHandler, this.jaxrpcServerRequestHandler());
        }
        if (this.getModeClientServer() == 1) {
            return SimpleChain.mergeHandlers(this.jaxrpcClientRequestHandler(), requestHandler);
        }
        throw new InternalException(Messages.getMessage("soapport.csmode.undefined"));
    }

    protected final Handler adjustResponseHandler(Handler respHandler) {
        Handler responseHandler = super.adjustResponseHandler(respHandler);
        if (this.getModeClientServer() == 2) {
            return SimpleChain.mergeHandlers(this.jaxrpcServerResponseHandler(), responseHandler);
        }
        if (this.getModeClientServer() == 1) {
            return SimpleChain.mergeHandlers(responseHandler, this.jaxrpcClientResponseHandler());
        }
        throw new InternalException(Messages.getMessage("soapport.csmode.undefined"));
    }

    public HandlerChain getHandlerChain() {
        return this._handlerChain;
    }

    public void setHandlerChain(HandlerChain handlerChain) {
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
            if (this._handlerChainActorHeaderBindings != null) {
                this._handlerChainActorHeaderBindings.clear();
                this._handlerChainActorHeaderBindings = null;
            }
            if (this._allActorHeaderBindings != null) {
                this._allActorHeaderBindings.clear();
                this._allActorHeaderBindings = null;
            }
        }
        this._handlerChain = handlerChain;
        this.resetAdjustedRequestHandler();
        this.resetAdjustedResponseHandler();
    }

    protected Iterator getNodeActors() {
        return _defaultActors.iterator();
    }

    public void setGlobalHeaders(Collection headers) {
        this._globalHandlerHeaders = headers;
    }

    public QName[] getGlobalHeaders() {
        return (QName[])this._globalHandlerHeaders.toArray();
    }

    public void setActorHeaderBinding(ActorHeaderBindings binding) {
        this._actorHeaderBindings.clear();
        if (binding != null) {
            this._actorHeaderBindings = binding;
        }
    }

    public void addActorHeaderBinding(String actor, Collection headers) {
        this._actorHeaderBindings.addBinding(actor, headers);
    }

    public void addActorHeaderBinding(String actor, QName header) {
        this._actorHeaderBindings.addBinding(actor, header);
    }

    private ActorHeaderBindings getActorHeaderBinding() {
        return this._actorHeaderBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActorHeaderBindings getHandlerChainActorHeaderBindings() {
        if (this._handlerChainActorHeaderBindings == null) {
            this._handlerChainActorHeaderBindings = new ActorHeaderBindings(this.getActorHeaderBinding());
            if (this.getHandlerChain() != null) {
                Collection headers;
                Collection collection = headers = this.getHandlerChain().getHeaderQNames();
                synchronized (collection) {
                    if (this._globalHandlerHeaders != null) {
                        headers.addAll(this._globalHandlerHeaders);
                    }
                    if (headers != null) {
                        Iterator iter = this.getHandlerChain().getRoles().iterator();
                        while (iter.hasNext()) {
                            String actor = (String)iter.next();
                            this._handlerChainActorHeaderBindings.addBinding(actor, headers);
                        }
                    }
                }
            }
        }
        return this._handlerChainActorHeaderBindings;
    }

    ActorHeaderBindings getAllActorHeaderBindings() {
        if (this._allActorHeaderBindings == null) {
            this._allActorHeaderBindings = new ActorHeaderBindings(this.getHandlerChainActorHeaderBindings());
            Iterator iter = this.getNodeActors();
            while (iter.hasNext()) {
                String actor = (String)iter.next();
                this._allActorHeaderBindings.addActor(actor);
            }
        }
        return this._allActorHeaderBindings;
    }

    public Set getOptionsBooleanNames() {
        return booleanOptions;
    }

    protected Handler jaxrpcServerRequestHandler() {
        return this.getHandlerChain() == null ? null : new BasicFullHandler(){

            public void invoke(MessageContext msgContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeServerRequestHandler(msgContext)) {
                    msgContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext msgContext) {
                try {
                    if (!JAXRPCHandler.this.invokeServerFaultHandler(msgContext)) {
                        msgContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault wsf) {
                    FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcServerRequestHandler", "249", this);
                    msgContext.setMessagePath(5);
                    log.error(Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext msgContext) {
                JAXRPCHandler.this.invokeServerClosureHandler(msgContext);
            }

            public void preHandleIncoming(MessageContext msgContext) {
                JAXRPCHandler.this.invokeServerIncomingPreHandler(msgContext);
            }
        };
    }

    protected Handler jaxrpcServerResponseHandler() {
        return this.getHandlerChain() == null ? null : new BasicClosureHandler(){

            public void invoke(MessageContext msgContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeServerResponseHandler(msgContext)) {
                    msgContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext msgContext) {
                try {
                    if (!JAXRPCHandler.this.invokeServerFaultHandler(msgContext)) {
                        msgContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault wsf) {
                    FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcServerResponseHandler", "249", this);
                    msgContext.setMessagePath(5);
                    log.error(Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext msgContext) {
                JAXRPCHandler.this.invokeServerClosureHandler(msgContext);
            }
        };
    }

    protected Handler jaxrpcClientRequestHandler() {
        return this.getHandlerChain() == null ? null : new BasicClosureHandler(){

            public void invoke(MessageContext msgContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeClientRequestHandler(msgContext)) {
                    msgContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext msgContext) {
                try {
                    if (!JAXRPCHandler.this.invokeClientFaultHandler(msgContext)) {
                        msgContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault wsf) {
                    FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcClientRequestHandler", "249", this);
                    msgContext.setMessagePath(5);
                    log.error(Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext msgContext) {
                JAXRPCHandler.this.invokeClientClosureHandler(msgContext);
            }
        };
    }

    protected Handler jaxrpcClientResponseHandler() {
        return this.getHandlerChain() == null ? null : new BasicFullHandler(){

            public void invoke(MessageContext msgContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeClientResponseHandler(msgContext)) {
                    msgContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext msgContext) {
                try {
                    if (!JAXRPCHandler.this.invokeClientFaultHandler(msgContext)) {
                        msgContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault wsf) {
                    FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcClientResponseHandler", "249", this);
                    msgContext.setMessagePath(5);
                    log.error(Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext msgContext) {
                JAXRPCHandler.this.invokeClientClosureHandler(msgContext);
            }

            public void preHandleIncoming(MessageContext msgContext) {
                JAXRPCHandler.this.invokeClientIncomingPreHandler(msgContext);
            }
        };
    }

    protected boolean invokeServerRequestHandler(MessageContext msgContext) throws WebServicesFault {
        return this.getHandlerChain().handleRequest(msgContext);
    }

    protected boolean invokeServerResponseHandler(MessageContext msgContext) throws WebServicesFault {
        return this.getHandlerChain().handleResponse(msgContext);
    }

    protected boolean invokeServerFaultHandler(MessageContext msgContext) throws WebServicesFault {
        return this.getHandlerChain().handleFault(msgContext);
    }

    protected void invokeServerClosureHandler(MessageContext msgContext) {
        this.getHandlerChain().handleClosure(msgContext);
    }

    protected void invokeServerIncomingPreHandler(MessageContext msgContext) {
        this.getHandlerChain().preHandleIncoming(msgContext);
    }

    protected boolean invokeClientRequestHandler(MessageContext msgContext) throws WebServicesFault {
        return this.getHandlerChain().handleRequest(msgContext);
    }

    protected boolean invokeClientResponseHandler(MessageContext msgContext) throws WebServicesFault {
        return this.getHandlerChain().handleResponse(msgContext);
    }

    protected boolean invokeClientFaultHandler(MessageContext msgContext) throws WebServicesFault {
        return this.getHandlerChain().handleFault(msgContext);
    }

    protected void invokeClientClosureHandler(MessageContext msgContext) {
        this.getHandlerChain().handleClosure(msgContext);
    }

    protected void invokeClientIncomingPreHandler(MessageContext msgContext) {
        this.getHandlerChain().preHandleIncoming(msgContext);
    }

    public void _destroy() {
        super._destroy();
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
            this._handlerChain = null;
        }
        if (this._actorHeaderBindings != null) {
            this._actorHeaderBindings.clear();
            this._actorHeaderBindings = null;
        }
        if (this._handlerChainActorHeaderBindings != null) {
            this._handlerChainActorHeaderBindings.clear();
            this._handlerChainActorHeaderBindings = null;
        }
        if (this._allActorHeaderBindings != null) {
            this._allActorHeaderBindings.clear();
            this._allActorHeaderBindings = null;
        }
    }

    public int getModeClientServer() {
        return this._modeClientServer;
    }

    public void setModeClientServer(int i) {
        this._modeClientServer = i;
    }

    static {
        _defaultActors.add("");
        _defaultActors.add("http://schemas.xmlsoap.org/soap/actor/next");
        _defaultActors.add("http://www.w3.org/2002/06/soap-envelope/actor/next");
        booleanOptions = new HashSet<String>(Arrays.asList("sendMultiRefs", "sendXsiTypes", "sendXMLDeclaration"));
    }

    public static class ActorHeaderBindings {
        private Map bindings = new HashMap();
        private static final String emptyActor = "".intern();

        public ActorHeaderBindings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActorHeaderBindings(ActorHeaderBindings src) {
            Iterator entries = src.bindings.entrySet().iterator();
            Map map = src.bindings;
            synchronized (map) {
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    this.addBinding((String)entry.getKey(), (Set)entry.getValue());
                }
            }
        }

        public boolean actorBoundToHeader(String actor, QName header) {
            Set headers;
            boolean result;
            if (actor == null) {
                actor = emptyActor;
            }
            boolean bl = result = (headers = (Set)this.bindings.get(actor)) != null && headers.contains(header);
            if (log.isDebugEnabled()) {
                if (headers == null) {
                    log.debug("actorBoundToHeader: actor \"" + actor + "\" is UNDEFINED");
                } else {
                    log.debug("actorBoundToHeader: actor \"" + actor + "\" " + (headers.contains(header) ? "IS" : "IS NOT") + " bound to header \"" + header + "\"");
                }
            }
            return result;
        }

        public boolean nodeActorNotBoundToHeader(String actor, QName header) {
            Set headers;
            boolean result;
            if (actor == null) {
                actor = emptyActor;
            }
            boolean bl = result = (headers = (Set)this.bindings.get(actor)) != null && !headers.contains(header);
            if (log.isDebugEnabled()) {
                if (headers == null) {
                    log.debug("nodeActorNotBoundToHeader: actor \"" + actor + "\" is UNDEFINED");
                } else {
                    log.debug("nodeActorNotBoundToHeader: actor \"" + actor + "\" " + (headers.contains(header) ? "IS" : "IS NOT") + " bound to header \"" + header + "\"");
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBinding(String actor, Collection headers) {
            if (actor == null) {
                actor = emptyActor;
            }
            Map map = this.bindings;
            synchronized (map) {
                Set set = this.newActor(actor);
                set.addAll(headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBinding(String actor, QName header) {
            if (actor == null) {
                actor = emptyActor;
            }
            Map map = this.bindings;
            synchronized (map) {
                Set headers = this.newActor(actor);
                headers.add(header);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addActor(String actor) {
            if (actor == null) {
                actor = emptyActor;
            }
            Map map = this.bindings;
            synchronized (map) {
                Set set = this.newActor(actor);
            }
        }

        private Set newActor(String actor) {
            Set headers = (Set)this.bindings.get(actor);
            if (headers == null) {
                headers = new QNameSet();
                this.bindings.put(actor, headers);
            }
            return headers;
        }

        public String toString() {
            return "ActorHeaderBindings:" + this.bindings.toString();
        }

        public void clear() {
            Iterator sets = this.bindings.values().iterator();
            while (sets.hasNext()) {
                Set set = (Set)sets.next();
                set.clear();
            }
            this.bindings.clear();
        }
    }

    public static class QNameSet
    extends TreeSet {
        private static final Comparator qnameComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = o1 == null ? "null" : o1.toString();
                String s2 = o2 == null ? "null" : o2.toString();
                return s1.compareTo(s2);
            }
        };

        public QNameSet() {
            super(qnameComparator);
        }
    }

    protected static abstract class BasicClosureHandler
    extends BasicHandler
    implements ClosureHandler {
        protected BasicClosureHandler() {
        }
    }

    protected static abstract class BasicFullHandler
    extends BasicHandler
    implements ClosureHandler,
    PreHandler {
        protected BasicFullHandler() {
        }
    }
}

