/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.websphere.csi.PooledObject;
import com.ibm.websphere.csi.PooledObjectMaster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPool;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;

public class HandlerProxy
implements PooledObjectMaster,
SystemHandler {
    protected static Log log = LogFactory.getLog(HandlerProxy.class.getName());
    private HandlerPool _owningPool;
    private javax.xml.rpc.handler.Handler _handler;

    public HandlerProxy(HandlerPool owningPool) throws IllegalAccessException, InstantiationException {
        this._owningPool = owningPool;
        this._handler = (javax.xml.rpc.handler.Handler)this._owningPool.getHandlerClass().newInstance();
        this._handler.init(owningPool.getHandlerInfo());
    }

    public String getHandlerClassName() {
        return this._owningPool.getHandlerClassName();
    }

    public PooledObject newInstance() {
        try {
            return new HandlerProxy(this._owningPool);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerProxy.newInstance", "95", this);
            log.error(Messages.getMessage("jaxRpcHandlerUnexpectedClassLoadFailure00", this.getHandlerClassName()), e);
            throw new JAXRPCException(Messages.getMessage("jaxRpcHandlerUnexpectedClassLoadFailure00", this.getHandlerClassName()), e);
        }
    }

    public void discard() {
        this._handler.destroy();
    }

    public void reset() {
    }

    public void init(HandlerInfo info) {
    }

    public void destroy() {
        this._handler.destroy();
    }

    public boolean handleRequest(MessageContext context) {
        return this._handler.handleRequest(context);
    }

    public boolean handleResponse(MessageContext context) {
        return this._handler.handleResponse(context);
    }

    public boolean handleFault(MessageContext context) {
        return this._handler.handleFault(context);
    }

    public void handleClosure(MessageContext context) {
        if (this._handler instanceof Handler) {
            ((Handler)this._handler).handleClosure(context);
        }
    }

    public void preHandleIncoming(MessageContext context) {
        if (this._handler instanceof SystemHandler) {
            ((SystemHandler)this._handler).preHandleIncoming(context);
        }
    }

    public QName[] getHeaders() {
        return this._handler.getHeaders();
    }
}

