/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.http;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import org.apache.commons.logging.Log;

public class HTTPActionHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(HTTPActionHandler.class.getName());

    public void invoke(MessageContext msgContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: HTTPActionHandler::invoke");
        }
        if (msgContext.getPort() == null) {
            boolean useAction = msgContext.useSOAPAction();
            String action = msgContext.getSOAPActionURI();
            if (log.isDebugEnabled()) {
                log.debug("  HTTP SOAPActionUse: " + useAction);
                log.debug("  HTTP SOAPAction: " + action);
            }
            if (action == null || !useAction) {
                throw new WebServicesFault("Server.NoHTTPSOAPAction", Messages.getMessage("noSOAPAction00"), null, null);
            }
            if ((action = action.trim()).length() > 0) {
                msgContext.setTargetPort(action);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: HTTPActionHandler::invoke");
        }
    }
}

