/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.SimpleSession;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.SessionUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class SimpleSessionHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleSessionHandler.class.getName());
    public static final String SESSION_ID = "SimpleSession.id";
    public static final String SESSION_NS = "http://websphere.ibm.com/webservices/session";
    public static final String SESSION_LOCALPART = "sessionID";
    public static final QName sessionHeaderName = QNameTable.createQName("http://websphere.ibm.com/webservices/session", "sessionID");
    private Hashtable activeSessions = new Hashtable();
    private long reapPeriodicity = 30L;
    private long lastReapTime = 0L;
    private int defaultSessionTimeout = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext context) throws WebServicesFault {
        long curTime = System.currentTimeMillis();
        boolean reap = false;
        SimpleSessionHandler simpleSessionHandler = this;
        synchronized (simpleSessionHandler) {
            if (curTime > this.lastReapTime + this.reapPeriodicity * 1000L) {
                reap = true;
                this.lastReapTime = curTime;
            }
        }
        if (reap) {
            Object key;
            Set entries = this.activeSessions.entrySet();
            HashSet<Object> victims = new HashSet<Object>();
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                key = entry.getKey();
                SimpleSession session = (SimpleSession)entry.getValue();
                if (curTime - session.getLastAccessTime() <= (long)(session.getTimeout() * 1000)) continue;
                log.debug(Messages.getMessage("timeout00", key.toString()));
                victims.add(key);
            }
            i = victims.iterator();
            while (i.hasNext()) {
                key = i.next();
                SimpleSession session = (SimpleSession)this.activeSessions.get(key);
                this.activeSessions.remove(key);
                Enumeration keys = session.getKeys();
                while (keys != null && keys.hasMoreElements()) {
                    String keystr = (String)keys.nextElement();
                    Object obj = session.get(keystr);
                    if (obj == null || !(obj instanceof ServiceLifecycle)) continue;
                    ((ServiceLifecycle)obj).destroy();
                }
            }
        }
        if (context.isClient()) {
            this.doClient(context);
        } else {
            this.doServer(context);
        }
    }

    public void doClient(MessageContext context) throws WebServicesFault {
        if (context.getPastPivot()) {
            try {
                Message msg = context.getResponseMessage();
                if (msg == null) {
                    return;
                }
                SOAPEnvelope env = msg.getSOAPEnvelope();
                SOAPHeader sh = (SOAPHeader)env.getHeader();
                Iterator it = sh.getChildElements(SESSION_NS, SESSION_LOCALPART);
                SOAPHeaderElement header = null;
                if (it.hasNext()) {
                    header = (SOAPHeaderElement)it.next();
                }
                if (header == null) {
                    return;
                }
                Long id = (Long)header.asObject(Constants.XSD_LONG);
                WebServicesEngine engine2 = context.getEngine();
                engine2.setOption(SESSION_ID, id);
                header.setProcessed(true);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doClient", "258", this);
                throw WebServicesFault.makeFault(e);
            }
        }
        WebServicesEngine engine3 = context.getEngine();
        Long id = (Long)engine3.getOption(SESSION_ID);
        if (id == null) {
            return;
        }
        Message msg = context.getRequestMessage();
        if (msg == null) {
            throw new WebServicesFault(Messages.getMessage("noRequest00"));
        }
        SOAPEnvelope env = msg.getSOAPEnvelope();
        try {
            SOAPHeaderElement header = env.getSOAPFactory().createSOAPHeaderElement(SESSION_NS, SESSION_LOCALPART);
            header.setAlternateContent(id);
            env.getHeader().addChildElement((SOAPElement)header);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doClient", "281", this);
            throw WebServicesFault.makeFault(e);
        }
    }

    public void doServer(MessageContext context) throws WebServicesFault {
        Long id;
        if (context.getPastPivot()) {
            Long id2 = (Long)context.getProperty(SESSION_ID);
            if (id2 == null) {
                return;
            }
            Message msg = context.getResponseMessage();
            if (msg == null) {
                return;
            }
            SOAPEnvelope env = msg.getSOAPEnvelope();
            try {
                SOAPHeaderElement header = env.getSOAPFactory().createSOAPHeaderElement(SESSION_NS, SESSION_LOCALPART);
                header.setAlternateContent(id2);
                env.getHeader().addChildElement((SOAPElement)header);
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doServer", "311", this);
                throw WebServicesFault.makeFault(e);
            }
        }
        Message msg = context.getRequestMessage();
        if (msg == null) {
            throw new WebServicesFault(Messages.getMessage("noRequest00"));
        }
        SOAPHeaderElement header = null;
        SOAPEnvelope env = msg.getSOAPEnvelope();
        try {
            SOAPHeader sh = (SOAPHeader)env.getHeader();
            Iterator it = sh.getChildElements(SESSION_NS, SESSION_LOCALPART);
            if (it.hasNext()) {
                header = (SOAPHeaderElement)it.next();
            }
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doServer", "329", this);
            throw WebServicesFault.makeFault(se);
        }
        if (header != null) {
            try {
                id = (Long)header.asObject(Constants.XSD_LONG);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doServer", "341", this);
                throw WebServicesFault.makeFault(e);
            }
        } else {
            id = this.getNewSession();
        }
        SimpleSession session = (SimpleSession)this.activeSessions.get(id);
        if (session == null) {
            id = this.getNewSession();
            session = (SimpleSession)this.activeSessions.get(id);
        }
        session.touch();
        context.setSession(session);
        context.setProperty(SESSION_ID, id);
    }

    private synchronized Long getNewSession() {
        Long id = SessionUtils.generateSession();
        SimpleSession session = new SimpleSession();
        session.setTimeout(this.defaultSessionTimeout);
        this.activeSessions.put(id, session);
        return id;
    }

    public void setReapPeriodicity(long reapTime) {
        this.reapPeriodicity = reapTime;
    }

    public void setDefaultSessionTimeout(int defaultSessionTimeout) {
        this.defaultSessionTimeout = defaultSessionTimeout;
    }
}

