/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.encoding.SimpleType;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanSerializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.Serializer;

public class SimpleBeanSerializerFactory
extends BaseSerializerFactory {
    protected BeanDesc beanDesc = null;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;

    public SimpleBeanSerializerFactory(Class javaType, QName xmlType) {
        super(SimpleBeanSerializer.class, xmlType, javaType);
    }

    public static SimpleBeanSerializerFactory create(Class javaType, QName xmlType, QName compQName, QName compTypeQName) {
        return new SimpleBeanSerializerFactory(javaType, xmlType);
    }

    protected void lazyInitialization() {
        super.lazyInitialization();
        this.beanDesc = BeanDesc.getBeanDescForClass(this.javaType);
        if (this.beanDesc == null) {
            this.propertyDescriptor = BeanUtils.getPd(this.javaType, null);
        }
    }

    public Serializer getSerializerAs(String mechanismType) throws JAXRPCException {
        Serializer ser = super.getSerializerAs(mechanismType);
        if (ser != null && this.beanDesc != null) {
            if (ser instanceof SimpleBeanSerializer) {
                ((SimpleBeanSerializer)ser).setup(this.beanDesc, this.beanDesc.getPropertyDescriptors());
            } else if (ser instanceof SimpleSerializer && SimpleType.class.isAssignableFrom(this.javaType)) {
                ((SimpleSerializer)ser).setup(this.beanDesc, this.beanDesc.getPropertyDescriptors());
            }
        }
        return ser;
    }
}

