/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.utils.DeserializerTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MapDeserializer
extends Deserializer {
    protected static Log log = LogFactory.getLog(MapDeserializer.class.getName());
    public static final Object KEYHINT = new Object();
    public static final Object VALHINT = new Object();
    public static final Object NILHINT = new Object();

    public MapDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public void onStartElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter MapDeserializer::startElement()");
        }
        if (AttributeUtils.isNil(attributes)) {
            return;
        }
        this.setValue(new HashMap());
        if (log.isDebugEnabled()) {
            log.debug("Exit: MapDeserializer::startElement()");
        }
    }

    public DEventProcessor onStartChild(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MapDeserializer::onStartChild()");
        }
        ItemDeserializer itemDeser = new ItemDeserializer(this);
        this.addChildDeserializer(itemDeser, attributes.getValue("href"));
        if (log.isDebugEnabled()) {
            log.debug("Exit: MapDeserializer::onStartChild()");
        }
        return itemDeser;
    }

    public void setValue(Object value, Object hint) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("gotValue00", "MapDeserializer", "" + value));
        }
        if (hint instanceof Deserializer) {
            super.setValue(value, hint);
        } else {
            ((Map)this.value).put(hint, value);
        }
    }

    class ItemDeserializer
    extends Deserializer {
        Object key;
        Object myValue;
        int numSet;
        MapDeserializer md;

        ItemDeserializer(MapDeserializer md) {
            super(null, null);
            this.numSet = 0;
            this.md = null;
            this.md = md;
        }

        public void setValue(Object val, Object hint) throws SAXException {
            if (hint instanceof Deserializer) {
                super.setValue(this.value, hint);
            } else {
                if (hint == KEYHINT) {
                    this.key = val;
                } else if (hint == VALHINT) {
                    this.myValue = val;
                } else if (hint != NILHINT) {
                    return;
                }
                ++this.numSet;
                if (this.numSet == 2) {
                    this.md.setValue(this.myValue, this.key);
                }
            }
        }

        public DEventProcessor onStartChild(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
            QName typeQName = AttributeUtils.getTypeFromAttributes(namespace, localName, attributes, mappingScope);
            Deserializer dser = context.getDeserializer(null, typeQName);
            if (dser == null) {
                dser = new DefaultDeserializer();
            }
            DeserializerTarget dt = null;
            if (AttributeUtils.isNil(attributes)) {
                dt = new DeserializerTarget(this, NILHINT);
            } else if (localName.equals("key")) {
                dt = new DeserializerTarget(this, KEYHINT);
            } else if (localName.equals("value")) {
                dt = new DeserializerTarget(this, VALHINT);
            }
            if (dt != null) {
                dser.registerValueTarget(dt);
            }
            this.addChildDeserializer(dser, attributes.getValue("href"));
            return dser;
        }
    }
}

