/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import com.ibm.ws.webservices.engine.types.HexBinary;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public class HexSerializer
implements SimpleValueSerializer {
    protected QName xmlType;
    protected Class javaType;

    public HexSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        context.getSerializationWriter().simpleElement(name, attributes, this.getValueAsString(value, context));
    }

    public String getValueAsString(Object value, SerializationContext context) {
        value = JavaUtils.convert(value, this.javaType);
        if (this.javaType == HexBinary.class) {
            return ((HexBinary)value).toString();
        }
        return HexBinary.encode((byte[])value);
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

