/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class EnumSerializer
extends SimpleSerializer {
    protected static Log log = LogFactory.getLog(EnumSerializer.class.getName());
    private Method getValueMethod = null;
    private QName componentTypeQName = null;

    public EnumSerializer(Class javaType, QName xmlType, QName compQName, QName componentTypeQName) {
        super(javaType, xmlType);
        this.componentTypeQName = componentTypeQName;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        context.getSerializationWriter().simpleElement(name, attributes, this.getValueAsString(value, context));
    }

    public String getValueAsString(Object value, SerializationContext context) {
        try {
            if (this.getValueMethod == null) {
                try {
                    this.getValueMethod = (Method)AccessController.doPrivileged(new getGetValuePRIV(this.javaType));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            return super.getValueAsString(this.getValueMethod.invoke(value, null), context);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.EnumSerializer.getValueAsString", "136", this);
            log.error(Messages.getMessage("exception00"), e);
            return null;
        }
    }

    public String getBuildNumber() {
        return null;
    }

    private class getGetValuePRIV
    implements PrivilegedExceptionAction {
        private Class clazz;

        getGetValuePRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() throws Exception {
            return this.clazz.getMethod("getValue", null);
        }
    }
}

