/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public class CalendarSerializer
implements SimpleValueSerializer {
    private static final SimpleDateFormat zuluDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final SimpleDateFormat zuluDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat zuluTime = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
    protected QName xmlType;
    protected Class javaType;
    private QName componentTypeQName;

    public CalendarSerializer(Class javaType, QName xmlType, QName compQName, QName componentTypeQName) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.componentTypeQName = componentTypeQName == null ? xmlType : componentTypeQName;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        context.getSerializationWriter().simpleElement(name, attributes, this.getValueAsString(value, context));
    }

    public String getValueAsString(Object value, SerializationContext context) {
        if (Constants.equals(Constants.XSD_DATE, this.componentTypeQName)) {
            return CalendarSerializer.getDateValueAsString(value);
        }
        if (Constants.equals(Constants.XSD_TIME, this.componentTypeQName)) {
            return CalendarSerializer.getTimeValueAsString(value);
        }
        return CalendarSerializer.getDateTimeValueAsString(value);
    }

    public static synchronized String getDateValueAsString(Object value) {
        StringBuffer buf = new StringBuffer();
        if (((Calendar)value).get(0) == 0) {
            buf.append("-");
            ((Calendar)value).set(0, 1);
        }
        Date date = ((Calendar)value).getTime();
        buf.append(zuluDate.format(date));
        return buf.toString();
    }

    public static synchronized String getTimeValueAsString(Object value) {
        return zuluTime.format(((Calendar)value).getTime());
    }

    public static synchronized String getDateTimeValueAsString(Object value) {
        Date date = value instanceof Date ? (Date)value : ((Calendar)value).getTime();
        return zuluDateTime.format(date);
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }

    static {
        zuluDateTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        zuluTime.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

