/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.custom;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.custom.CustomProvider;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utils {
    public static final String PROVIDER_NAMESPACE = "http://www.ibm.com/webservices/customdatabinding/2004/06";
    public static final String ATTRIBUTE_SCOPE = "scope";
    public static final String ATTRIBUTE_SCOPE_SERVER = "server";
    public static final String ATTRIBUTE_SCOPE_APPLICATION = "application";
    public static final String ATTRIBUTE_SCOPE_MODULE = "module";
    public static final String ELEM_MAPPING = "mapping";
    public static final String ELEM_XML_QNAME = "xmlQName";
    public static final String ELEM_QNAME_SCOPE = "qnameScope";
    public static final String ELEM_JAVA_NAME = "javaName";
    public static final String ELEM_BINDER = "binder";
    public static final String ELEM_DESCRIPTION = "description";
    public static final String ELEM_PROPERTY = "initParam";
    public static final String ELEM_PROPERTY_NAME = "name";
    public static final String ELEM_PROPERTY_VALUE = "value";
    public static final String CUSTOM_BINDING_PROVIDER_XML = "META-INF/services/CustomBindingProvider.xml";
    private static Log log = LogFactory.getLog(Utils.class.getName());
    static final WeakHashMap providerCache = new WeakHashMap();
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory;

    public static final synchronized List loadCustomProviders(ClassLoader classLoader) {
        ArrayList<CustomProvider> providers;
        if (log.isDebugEnabled()) {
            log.debug("Entered loadCustomProviders with classloader: " + classLoader.toString());
        }
        if ((providers = (ArrayList<CustomProvider>)providerCache.get(classLoader)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found cached custom binding providers...");
            }
            return providers;
        }
        providers = new ArrayList<CustomProvider>();
        try {
            IExtensionPoint extensionPoint;
            HashSet<URL> resourceSet = new HashSet<URL>();
            Enumeration e = classLoader.getResources(CUSTOM_BINDING_PROVIDER_XML);
            while (e != null && e.hasMoreElements()) {
                resourceSet.add(e.nextElement());
            }
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".customBindingProvider";
            String resourceName = CUSTOM_BINDING_PROVIDER_XML;
            if (registry != null && (extensionPoint = registry.getExtensionPoint(epid)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Processing extension point " + epid);
                }
                HashSet<String> bundlesProcessed = new HashSet<String>();
                IExtension[] extensions = extensionPoint.getExtensions();
                for (int i = 0; i < extensions.length; ++i) {
                    String bundleName;
                    Bundle bundle;
                    if (log.isDebugEnabled()) {
                        log.debug("Processing extension " + extensions[i].getUniqueIdentifier());
                    }
                    if ((bundle = Platform.getBundle(extensions[i].getNamespace())) == null || bundlesProcessed.contains(bundleName = bundle.getSymbolicName())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("processing bundle " + bundleName);
                    }
                    bundlesProcessed.add(bundleName);
                    e = null;
                    try {
                        e = bundle.getResources(resourceName);
                    }
                    catch (IOException e1) {
                        log.error("Exception trying to get bundle resources", e1);
                    }
                    while (e != null && e.hasMoreElements()) {
                        resourceSet.add((URL)e.nextElement());
                    }
                }
            }
            Iterator i = resourceSet.iterator();
            while (i.hasNext()) {
                InputStream is;
                Document doc;
                Element providerElem;
                String providerScope;
                URL url = (URL)i.next();
                String path = url.toString();
                if (log.isDebugEnabled()) {
                    log.debug("Loading custom bindings from file: " + path);
                }
                if ((providerScope = (providerElem = (doc = XMLUtils.newDocument(is = url.openStream())).getDocumentElement()).getAttributeNS(PROVIDER_NAMESPACE, ATTRIBUTE_SCOPE)) == null || providerScope.length() == 0) {
                    providerScope = ATTRIBUTE_SCOPE_MODULE;
                }
                CustomProvider provider = new CustomProvider(path, providerScope);
                for (Node node = providerElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                    String localName = node.getLocalName();
                    if (localName == null || !localName.equals(ELEM_MAPPING)) continue;
                    String xmlQNameURI = null;
                    String xmlQNameLocalPart = null;
                    String javaName = null;
                    String mappingScope = null;
                    String binderClass = null;
                    Properties initParams = new Properties();
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        localName = node2.getLocalName();
                        if (localName == null) continue;
                        if (localName.equals(ELEM_XML_QNAME)) {
                            String qname = node2.getFirstChild().getNodeValue();
                            int idx = qname.indexOf(58);
                            String prefix = qname.substring(0, idx);
                            xmlQNameLocalPart = qname.substring(idx + 1);
                            Element tmpElem = (Element)node2;
                            while (xmlQNameURI == null) {
                                xmlQNameURI = tmpElem.getAttribute("xmlns:" + prefix);
                                if (xmlQNameURI == null || xmlQNameURI.length() != 0) continue;
                                xmlQNameURI = null;
                                if ((tmpElem = tmpElem.getParentNode() instanceof Document ? null : (Element)tmpElem.getParentNode()) != null) continue;
                            }
                            if (xmlQNameURI != null) continue;
                            log.warn(Messages.getMessage("noNamespaceForMapping", path));
                            continue;
                        }
                        if (localName.equals(ELEM_JAVA_NAME)) {
                            javaName = node2.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (localName.equals(ELEM_QNAME_SCOPE)) {
                            mappingScope = node2.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!localName.equals(ELEM_BINDER)) continue;
                        binderClass = node2.getFirstChild().getNodeValue();
                    }
                    if (mappingScope.equals("element") && !xmlQNameLocalPart.startsWith(">")) {
                        xmlQNameLocalPart = ">" + xmlQNameLocalPart;
                    }
                    provider.addMapping(QNameTable.createQName(xmlQNameURI, xmlQNameLocalPart), javaName, mappingScope, binderClass, initParams);
                }
                providers.add(provider);
            }
        }
        catch (Exception ioe) {
            FFDCFilter.processException(ioe, "com.ibm.ws.webservices.engine.encoding.custom.Utils.loadCustomProviders", "220");
            log.error(Messages.getMessage("loadCustomProviderError"), ioe);
        }
        providerCache.put(classLoader, providers);
        if (log.isDebugEnabled()) {
            log.debug("Cached custom binding providers with classloader: " + classLoader.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("Exiting loadCustomProviders.  There are " + providerCache.size() + " map pairs in the HashMap.");
        }
        return providers;
    }

    public static void populateTypeMapping(List providers, TypeMapping tm) {
        Iterator it = providers.iterator();
        while (it.hasNext()) {
            CustomProvider provider = (CustomProvider)it.next();
            QName[] qnames = provider.getQNames();
            for (int i = 0; i < qnames.length; ++i) {
                String javaName = provider.getJavaName(qnames[i]);
                String binderName = provider.getBinderName(qnames[i], javaName);
                try {
                    Class javaType = ClassUtils.forName(javaName);
                    SerializerFactory sf = BaseSerializerFactory.createFactory(class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory == null ? Utils.class$("com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory") : class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory, javaType, qnames[i], binderName);
                    DeserializerFactory df = BaseDeserializerFactory.createFactory(class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory == null ? Utils.class$("com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializerFactory") : class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory, javaType, qnames[i], binderName);
                    tm.register(javaType, qnames[i], sf, df);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    FFDCFilter.processException(cnfe, "com.ibm.ws.webservices.engine.encoding.custom.Utils.populateTypeMapping", "251");
                    new RuntimeException(cnfe);
                }
            }
        }
    }
}

