/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class DefaultDeserializer
extends Deserializer {
    protected static Log log = LogFactory.getLog(DefaultDeserializer.class.getName());

    public DefaultDeserializer() {
        super(null, null);
    }

    public void onStartElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        QName type = AttributeUtils.getTypeFromAttributes(namespace, localName, attributes, mappingScope);
        if (type == null && (type = this.defaultType) == null) {
            type = Constants.WEBSERVICES_SOAPELEMENT;
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("gotType00", "Deser", "" + type));
        }
        if (type != null) {
            Deserializer dser = context.getDeserializer(null, type);
            if (dser != null) {
                dser.moveValueTargets(this);
                context.getEventConverter().popDEventProcessor();
                context.getEventConverter().pushDEventProcessor(dser);
                dser.startElement(namespace, localName, prefixedName, attributes, mappingScope, context);
                this.inUse = false;
            } else {
                throw new SAXException(Messages.getMessage("noDeser00", "" + type));
            }
        }
    }

    public DEventProcessor onStartChild(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        throw new SAXException(Messages.getMessage("badDEvent00", "onStartChild", prefixedName, this.getClass().getName()));
    }
}

