/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployableItem;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.HandlerClassFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDHandler
extends WSDDDeployableItem
implements Comparable {
    private static Log log = LogFactory.getLog(WSDDHandler.class.getName());
    public static final String HANDLER_PARAM_PREFIX = "com.ibm.websphere.webservices.handler.";
    public static final String HANDLER_PARAM_NAME = "com.ibm.websphere.webservices.handler.name";
    public static final String HANDLER_PARAM_CATEGORY = "com.ibm.websphere.webservices.handler.category";
    public static final String HANDLER_PARAM_PRIORITY = "com.ibm.websphere.webservices.handler.priority";
    public static final String HANDLER_PARAM_POSITION = "com.ibm.websphere.webservices.handler.position";
    public static final String HANDLER_PARAM_ROLE = "com.ibm.websphere.webservices.handler.role";
    public static final String HANDLER_PARAM_FLOW = "com.ibm.websphere.webservices.handler.flow";
    public static final int MAX_PRIORITY = 1000;
    public static final int MIN_PRIORITY = 2147482647;
    public static final int INTERNAL_MAX_PRIORITY = 0;
    public static final int INTERNAL_MIN_PRIORITY = Integer.MAX_VALUE;
    public static final int DEFAULT_PRIORITY = 2147482647;
    public static final int PRIORITY_NOTSET = -1;
    private boolean loadedClass = false;
    private Class javaClass = null;
    private QName type;
    private int priority = 2147482647;

    public WSDDHandler() {
    }

    public WSDDHandler(Element e) throws WSDDException {
        super(e);
        String priorityStr;
        String typeStr = e.getAttribute("type");
        if (typeStr != null && !typeStr.equals("")) {
            this.setType(XMLUtils.getQNameFromString(typeStr, e));
        }
        if ((priorityStr = e.getAttribute("priority")) != null && !priorityStr.equals("")) {
            this.setPriority(priorityStr);
        }
        if (this.getType() == null && this.getClass() == WSDDHandler.class) {
            throw new WSDDException(Messages.getMessage("noTypeAttr00"));
        }
    }

    protected boolean loadableParam(String paramName) {
        return !paramName.startsWith(HANDLER_PARAM_PREFIX);
    }

    public void setName(String name) {
        super.setName(name);
        this.setParameter(HANDLER_PARAM_NAME, name, true);
    }

    protected final Handler makeNewInstance(EngineConfiguration registry) throws ConfigurationException {
        if (this.getType() == null || "http://websphere.ibm.com/webservices/wsdd/dispatchers/java".equals(this.getType().getNamespaceURI())) {
            return this.makeNewHandler(registry);
        }
        throw new WSDDException(Messages.getMessage("badTypeNamespace00", this.getType().getNamespaceURI(), "http://websphere.ibm.com/webservices/wsdd/dispatchers/java"));
    }

    protected Handler makeNewHandler(EngineConfiguration registry) throws ConfigurationException {
        Class c = null;
        try {
            c = this.getJavaClass();
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDHandler.makeNewHandler", "200", this);
            throw WSDDException.makeWSDDException(e);
        }
        Handler h = null;
        if (c != null) {
            try {
                h = (Handler)c.newInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDHandler.makeNewHandler", "209", this);
                throw WSDDException.makeWSDDException(e);
            }
            if (h != null) {
                if (this.getQName() != null) {
                    h.setName(this.getQName().getLocalPart());
                }
                h.setOptions(this.getParametersTable());
            }
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getJavaClass() throws ClassNotFoundException {
        if (!this.loadedClass) {
            block13: {
                try {
                    QName type = this.getType();
                    if (type == null || !"http://websphere.ibm.com/webservices/wsdd/dispatchers/java".equals(type.getNamespaceURI())) {
                        this.javaClass = null;
                    } else {
                        this.javaClass = ClassUtils.forName(type.getLocalPart());
                        if (HandlerClassFactory.class.isAssignableFrom(this.javaClass)) {
                            try {
                                HandlerClassFactory factory = (HandlerClassFactory)this.javaClass.newInstance();
                                Class newClass = factory.getHandlerClass();
                                if (log.isDebugEnabled() && newClass != this.javaClass) {
                                    if (newClass == null) {
                                        log.debug("Factory returned null class.");
                                    } else {
                                        log.debug("Factory returned alternate class '" + newClass.getName() + "'");
                                    }
                                }
                                this.javaClass = newClass;
                            }
                            catch (IllegalAccessException e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.axis.ext.deployment.wsdd.WSDDHandler.getJavaClass", "74", this);
                                log.error(Messages.getMessage("exception00"), e);
                                this.javaClass = null;
                            }
                            catch (InstantiationException e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.axis.ext.deployment.wsdd.WSDDHandler.getJavaClass", "78", this);
                                log.error(Messages.getMessage("exception00"), e);
                                this.javaClass = null;
                            }
                        }
                    }
                    Object var5_6 = null;
                    if (this.javaClass != null || !log.isDebugEnabled()) break block13;
                    log.debug("handler \"" + (this.getQName() == null ? "<noname>" : this.getQName().getLocalPart()) + "\" unable to load \"" + (this.type == null ? "<notype>" : this.type.getLocalPart()) + "\"");
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (this.javaClass == null && log.isDebugEnabled()) {
                        log.debug("handler \"" + (this.getQName() == null ? "<noname>" : this.getQName().getLocalPart()) + "\" unable to load \"" + (this.type == null ? "<notype>" : this.type.getLocalPart()) + "\"");
                    }
                    this.loadedClass = true;
                    throw throwable;
                }
            }
            this.loadedClass = true;
            {
            }
        }
        return this.javaClass;
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName type) {
        this.type = type;
    }

    public int getPriority() {
        if (this.priority == -1) {
            this.setPriority(2147482647);
        }
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.setParameter(HANDLER_PARAM_PRIORITY, String.valueOf(priority), true);
    }

    public void setPriority(String priorityStr) {
        if (priorityStr != null) {
            try {
                this.setPriority(Integer.parseInt(priorityStr));
            }
            catch (NumberFormatException nfe) {
                this.setPriority(2147482647);
            }
        }
    }

    protected QName getElementName() {
        return QNAME_HANDLER;
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        if (this.getQName() != null) {
            attrs.addAttribute("", "name", "name", "CDATA", context.getSerializationWriter().qName2String(this.getQName()));
        }
        if (this.getPriority() != 2147482647) {
            attrs.addAttribute("", "priority", "priority", "CDATA", String.valueOf(this.getPriority()));
        }
        context.getSerializationWriter().startElement(WSDDConstants.QNAME_HANDLER, attrs);
        this.writeParamsToContext(context);
        context.getSerializationWriter().endElement();
    }

    public int compareTo(Object obj) {
        return obj instanceof WSDDHandler ? this.getPriority() - ((WSDDHandler)obj).getPriority() : -1;
    }
}

