/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDocumentation;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class WSDDElement
extends WSDDConstants
implements Serializable {
    private static Log log = LogFactory.getLog(WSDDElement.class.getName());
    private WSDDDocumentation documentation = null;

    public WSDDElement() {
    }

    public WSDDElement(Element e) throws WSDDException {
        this.validateCandidateElement(e);
    }

    protected abstract QName getElementName();

    private void validateCandidateElement(Element e) throws WSDDException {
        QName name = this.getElementName();
        String eLocal = e.getLocalName().equals("requestFlow") || e.getLocalName().equals("responseFlow") ? "chain" : e.getLocalName();
        if (null == e || null == e.getNamespaceURI() || null == eLocal || !e.getNamespaceURI().equals(name.getNamespaceURI()) || !eLocal.equals(name.getLocalPart())) {
            throw new WSDDException(Messages.getMessage("invalidWSDD00", e.toString(), name.toString()));
        }
    }

    public Element getChildElement(Element e, String name) {
        Element[] elements = this.getChildElements(e, name);
        if (elements.length == 0) {
            return null;
        }
        return elements[0];
    }

    public Element[] getChildElements(Element e, String name) {
        Vector<Element> els = new Vector<Element>();
        for (Node thisNode = e.getFirstChild(); thisNode != null; thisNode = thisNode.getNextSibling()) {
            Element el;
            if (!(thisNode instanceof Element) || !(el = (Element)thisNode).getLocalName().equals(name)) continue;
            els.add(el);
        }
        Element[] elements = new Element[els.size()];
        els.toArray(elements);
        return elements;
    }

    public WSDDDocumentation getDocumentation() {
        return this.documentation;
    }

    public abstract void writeToContext(SerializationContext var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() throws ConfigurationException {
        StringWriter sw = new StringWriter();
        try {
            BufferedWriter writer = new BufferedWriter(sw);
            try {
                SerializationContextImpl context = new SerializationContextImpl(writer, null);
                context.getSerializationWriter().setPretty(true);
                this.writeToContext(context);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ((Writer)writer).close();
                throw throwable;
            }
            ((Writer)writer).close();
            {
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement.getDocument", "234", this);
            throw WSDDException.makeWSDDException(e);
        }
        try {
            return XMLUtils.newDocument(new InputSource(new StringReader(sw.getBuffer().toString())));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement.getDocument", "241", this);
            log.error(Messages.getMessage("exception00"), e);
            return null;
        }
    }

    public void dump() {
        if (log.isDebugEnabled()) {
            try {
                Document doc = this.getDocument();
                log.debug(this.getElementName().getLocalPart() + " is\n" + XMLUtils.DocumentToString(doc));
            }
            catch (IOException e) {
                log.debug(Messages.getMessage("dumpService.failed"), e);
            }
        }
    }
}

