/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.lifecycle.ConfigurableLifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleOwner;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleSetImpl;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleObject;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public abstract class WSDDDeployableItem
extends WSDDElement
implements LifeCycleOwner,
_LifeCycleObject,
ConfigurableLifeCycleObject {
    private static Log log = LogFactory.getLog(WSDDDeployableItem.class.getName());
    private QName qname;
    public static final String OPTION_SCOPE = "scope";
    public static final int SCOPE_PER_REQUEST = 0;
    public static final int SCOPE_PER_MODULE = 1;
    public static final int SCOPE_PER_APPLICATION = 2;
    public static final int SCOPE_PER_SERVER = 3;
    public static String[] scopeStrings = new String[]{"request", "module", "application", "server"};
    private int scope = 3;
    private Handler singletonInstance = null;
    private Configurable _configurable = new ConfigurableImpl();
    private LifeCycleSetImpl _lifeCycleSet = this.lifeCycleSetFactory(this);

    public WSDDDeployableItem() {
    }

    public WSDDDeployableItem(Element e) throws WSDDException {
        super(e);
        String scopeStr;
        String name = e.getAttribute("name");
        if (name != null && !name.equals("")) {
            this.setName(name);
        }
        if ((scopeStr = e.getAttribute(OPTION_SCOPE)) != null) {
            for (int i = 0; i < scopeStrings.length; ++i) {
                if (!scopeStr.equals(scopeStrings[i])) continue;
                this.scope = i;
                break;
            }
        }
        Element[] paramElements = this.getChildElements(e, "parameter");
        for (int i = 0; i < paramElements.length; ++i) {
            Element param = paramElements[i];
            String pname = param.getAttribute("name");
            if (!this.loadableParam(pname)) continue;
            String value = param.getAttribute("value");
            String locked = param.getAttribute("locked");
            this.setOption(pname, value, JavaUtils.isTrueExplicitly(locked));
        }
    }

    protected boolean loadableParam(String paramName) {
        return true;
    }

    public void setName(String name) {
        this.setQName(QNameTable.createQName(null, name.intern()));
    }

    public void setQName(QName qname) {
        this.qname = qname;
    }

    public QName getQName() {
        return this.qname;
    }

    protected void setScope(int _scope) {
        this.scope = _scope;
    }

    public void setParameter(String name, Object value) {
        this.setOption(name, value);
    }

    public void setParameter(String name, Object value, boolean lock) {
        this.setOption(name, value, lock);
    }

    public String getParameter(String name) {
        return (String)this.getOption(name);
    }

    public LockableHashtable getParametersTable() {
        Map options = this._configurable.getOptions();
        LockableHashtable parameters = options instanceof LockableHashtable ? (LockableHashtable)options : null;
        return parameters;
    }

    public void setParameters(Map map) {
        this.setOptions(map);
    }

    public void writeParamsToContext(SerializationContext context) throws IOException {
        LockableHashtable parameters = this.getParametersTable();
        if (parameters == null) {
            return;
        }
        Set entries = parameters.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "name", "name", "CDATA", name);
            attrs.addAttribute("", "value", "value", "CDATA", entry.getValue().toString());
            if (parameters.isKeyLocked(name)) {
                attrs.addAttribute("", "locked", "locked", "CDATA", "true");
            }
            context.getSerializationWriter().simpleElement(QNAME_PARAM, attrs, null);
        }
    }

    public void removeParameter(String name) {
        this.removeOption(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Handler getInstance(EngineConfiguration registry) throws ConfigurationException {
        if (this.scope == 3) {
            WSDDDeployableItem wSDDDeployableItem = this;
            synchronized (wSDDDeployableItem) {
                if (this.singletonInstance == null) {
                    this.singletonInstance = this.makeNewInstance(registry);
                    if (this.singletonInstance != null) {
                        this.manageLifeCycleOf(this.singletonInstance);
                    }
                }
            }
            return this.singletonInstance;
        }
        Handler result = this.makeNewInstance(registry);
        if (result != null) {
            this.tempManageLifeCycleOf(result);
        }
        return result;
    }

    protected Handler makeNewInstance(EngineConfiguration registry) throws ConfigurationException {
        return null;
    }

    protected LifeCycleSetImpl lifeCycleSetFactory(_LifeCycleObject container) {
        return new LifeCycleSetImpl(container, true, false);
    }

    public void setOwner(LifeCycleOwner owner) throws LifeCycleException {
        this._lifeCycleSet.setOwner(owner);
    }

    public LifeCycleOwner getOwner() {
        return this._lifeCycleSet.getOwner();
    }

    public final void init() throws LifeCycleException {
        this._lifeCycleSet.init();
    }

    public void _init() throws LifeCycleException {
        this._lifeCycleSet._init();
    }

    public final void destroy() {
        this._lifeCycleSet.destroy();
    }

    public void _destroy() {
        this._lifeCycleSet._destroy();
    }

    public int getState() {
        return this._lifeCycleSet.getState();
    }

    public boolean isActive() {
        return this._lifeCycleSet.isActive();
    }

    public void verifyActive() throws LifeCycleException {
        this._lifeCycleSet.verifyActive();
    }

    public void verifyInactive() throws LifeCycleException {
        this._lifeCycleSet.verifyInactive();
    }

    public boolean releaseLifeCycleManagementOf(LifeCycleObject object) throws LifeCycleException {
        if (object == this.singletonInstance) {
            return false;
        }
        return this._lifeCycleSet.releaseLifeCycleManagementOf(object);
    }

    protected boolean manageLifeCycleOf(LifeCycleObject object) {
        return this._lifeCycleSet.manageLifeCycleOf(object);
    }

    protected boolean tempManageLifeCycleOf(LifeCycleObject object) {
        return this._lifeCycleSet.manageLifeCycleOf(object, false);
    }

    public final void setOptionsDefault(Configured dephault) {
        this._lifeCycleSet.verifyInactive();
        this._configurable.setOptionsDefault(dephault);
    }

    public final void setOption(String name, Object value) {
        this._lifeCycleSet.verifyInactive();
        this._configurable.setOption(name, value);
    }

    public final void setOption(String name, Object value, boolean lock) {
        this._lifeCycleSet.verifyInactive();
        this._configurable.setOption(name, value, lock);
    }

    public final boolean setOptionDefault(String name, Object value) {
        this._lifeCycleSet.verifyInactive();
        return this._configurable.setOptionDefault(name, value);
    }

    public final boolean setOptionDefault(String name, Object value, boolean lock) {
        this._lifeCycleSet.verifyInactive();
        return this._configurable.setOptionDefault(name, value, lock);
    }

    public final void setOptions(Map opts) {
        this._lifeCycleSet.verifyInactive();
        this._configurable.setOptions(opts);
    }

    public final Object getOption(String name) {
        return this._configurable.getOption(name);
    }

    public final Map getOptions() {
        return this._configurable.getOptions();
    }

    public Set getOptionsBooleanNames() {
        return this._configurable.getOptionsBooleanNames();
    }

    public final void removeOption(String name) {
        this._configurable.removeOption(name);
    }
}

