/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Connection;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.SessionContext;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Metadata;
import com.ibm.wsspi.wsaddressing.ServiceName;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPElement;

public abstract class Stub
implements javax.xml.rpc.Stub {
    protected javax.xml.rpc.Service service = null;
    protected Connection connection = null;
    protected WebServicesEngine engine = null;
    protected boolean maintainSessionSet = false;
    protected boolean maintainSession = false;
    protected Properties cachedProperties = new Properties();
    protected String cachedUsername = null;
    protected String cachedPassword = null;
    protected String cachedhttpProxyHost = null;
    protected String cachedhttpProxyPort = null;
    protected String cachedhttpProxyUser = null;
    protected String cachedhttpProxyPassword = null;
    protected String cachedhttpsProxyHost = null;
    protected String cachedhttpsProxyPort = null;
    protected String cachedhttpsProxyUser = null;
    protected String cachedhttpsProxyPassword = null;
    protected String cachedsslCfgName = null;
    protected Boolean cachedhttpRedirectEnabled = null;
    protected URL cachedEndpoint = null;
    protected Integer cachedTimeout = null;
    protected Integer cachedWriteTimeout = null;
    protected QName cachedPortName = null;
    protected ThreadLocal cachedSessionContext = new ThreadLocal();
    protected ThreadLocal cachedRequestTransportHeaders = new ThreadLocal();
    protected ThreadLocal cachedResponseTransportHeaders = new ThreadLocal();
    protected ThreadLocal cachedResponseTransportHeadersTemplate = new ThreadLocal();
    protected ThreadLocal cachedRequestSoapHeaders = new ThreadLocal();
    protected ThreadLocal cachedResponseSoapHeaders = new ThreadLocal();
    protected ThreadLocal cachedResponseSoapHeaderTemplates = new ThreadLocal();
    protected MessageContext[] messageContexts;
    private Map endpointMap = Collections.synchronizedMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _setProperty(String name, Object value) {
        boolean messageContextsAlreadySet = false;
        if (name == null) {
            throw new JAXRPCException(Messages.getMessage("badProp03"));
        }
        if (!(value != null || "com.ibm.ws.webservices.engine.session.context".equals(name) || "com.ibm.websphere.webservices.requestTransportProperties".equals(name) || "com.ibm.websphere.webservices.responseTransportProperties".equals(name) || "com.ibm.websphere.webservices.requestSoapHeaders".equals(name) || "com.ibm.websphere.webservices.responseSoapHeaders".equals(name))) {
            throw new JAXRPCException(Messages.getMessage("badProp04"));
        }
        if (name.equals("javax.xml.rpc.security.auth.username")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedUsername = (String)value;
        } else if (name.equals("javax.xml.rpc.security.auth.password")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedPassword = (String)value;
        } else if (name.equals("http.proxyHost")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedhttpProxyHost = (String)value;
        } else if (name.equals("http.proxyPort")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedhttpProxyPort = (String)value;
        } else if (name.equals("http.proxyUser")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedhttpProxyUser = (String)value;
        } else if (name.equals("http.proxyPassword")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedhttpProxyPassword = (String)value;
        } else if (name.equals("https.proxyHost")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedhttpsProxyHost = (String)value;
        } else if (name.equals("https.proxyPort")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedhttpsProxyPort = (String)value;
        } else if (name.equals("https.proxyUser")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedhttpsProxyUser = (String)value;
        } else if (name.equals("https.proxyPassword")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedhttpsProxyPassword = (String)value;
        } else if (name.equals("ssl.configName")) {
            if (!(value instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.cachedsslCfgName = (String)value;
        } else if (name.equals("javax.xml.rpc.service.endpoint.address")) {
            Stub stub = this;
            synchronized (stub) {
                if (!(value instanceof String)) {
                    throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
                }
                try {
                    this.cachedEndpoint = (URL)this.endpointMap.get((String)value);
                    if (this.cachedEndpoint == null) {
                        if (this.endpointMap.size() >= 15) {
                            this.endpointMap.clear();
                        }
                        this.cachedEndpoint = new URL((String)value);
                        this.endpointMap.put((String)value, this.cachedEndpoint);
                    }
                }
                catch (MalformedURLException mue) {
                    FFDCFilter.processException((Throwable)mue, "com.ibm.ws.webservices.engine.client.Stub._setProperty", "158", this);
                    throw new JAXRPCException(mue.getMessage());
                }
                this.connection = ((Service)this.service).getConnection(this.cachedEndpoint);
            }
            for (int i = 0; i < this.messageContexts.length; ++i) {
                if (this.messageContexts[i] == null) continue;
                this.messageContexts[i].setProperty(name, value);
            }
            messageContextsAlreadySet = true;
        } else if (name.equals("javax.xml.rpc.session.maintain")) {
            if (!(value instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.maintainSessionSet = true;
            this.maintainSession = (Boolean)value;
        } else if (name.equals("com.ibm.ws.webservices.engine.session.context")) {
            if (value != null && !(value instanceof SessionContext)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "com.ibm.ws.webservices.engine.session.SessionContext", value == null ? "null" : value.getClass().getName()}));
            }
            this.cachedSessionContext.set(value);
            value = this.cachedSessionContext;
        } else if (name.equals("com.ibm.websphere.webservices.requestTransportProperties")) {
            Stub.validateTransportPropertiesHashMap(value, name);
            this.cachedRequestTransportHeaders.set(value);
            value = this.cachedRequestTransportHeaders;
        } else if (name.equals("com.ibm.websphere.webservices.responseTransportProperties")) {
            Stub.validateTransportPropertiesHashMap(value, name);
            this.cachedResponseTransportHeaders.set(value);
            ArrayList hdrNames = null;
            if (value != null) {
                hdrNames = new ArrayList(((HashMap)value).keySet());
            }
            this.cachedResponseTransportHeadersTemplate.set(hdrNames);
            value = this.cachedResponseTransportHeaders;
        } else if (name.equals("http.redirect.enabled")) {
            if (!(value instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.cachedhttpRedirectEnabled = (Boolean)value;
        } else if (name.equals("com.ibm.websphere.webservices.requestSoapHeaders")) {
            Stub.validateSoapHeadersHashMap(value, name);
            this.cachedRequestSoapHeaders.set(value);
            value = this.cachedRequestSoapHeaders;
        } else if (name.equals("com.ibm.websphere.webservices.responseSoapHeaders")) {
            Stub.validateSoapHeadersHashMap(value, name);
            this.cachedResponseSoapHeaders.set(value);
            ArrayList hdrNames = null;
            if (value != null) {
                hdrNames = new ArrayList(((HashMap)value).keySet());
            }
            this.cachedResponseSoapHeaderTemplates.set(hdrNames);
            value = this.cachedResponseSoapHeaders;
        } else if (name.equals("enableTransactionalOneWay")) {
            if (!(value instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.cachedProperties.put(name, value);
        } else if (name.equals("com.ibm.websphere.wsaddressing.destinationEPR")) {
            Stub hdrNames = this;
            synchronized (hdrNames) {
                ServiceName sn;
                Metadata met;
                URI uri;
                if (!(value instanceof EndpointReference)) {
                    throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
                }
                for (int i = 0; i < this.messageContexts.length; ++i) {
                    if (this.messageContexts[i] == null) continue;
                    this.messageContexts[i].setProperty(name, value);
                }
                messageContextsAlreadySet = true;
                this.cachedProperties.put(name, value);
                EndpointReference epr = (EndpointReference)value;
                AttributedURI auri = epr.getAddress();
                if (auri != null && (uri = auri.getURI()) != null) {
                    this._setProperty("javax.xml.rpc.service.endpoint.address", uri.toString());
                }
                if ((met = ((EndpointReference)value).getMetadata()) != null && (sn = met.getServiceName()) != null) {
                    QName sername = sn.getQName();
                    QName wsdlServiceName = this.service.getServiceName();
                    if (wsdlServiceName != null && !wsdlServiceName.equals(sername)) {
                        String erpSername = sername == null ? "null" : sername.toString();
                        throw new JAXRPCException(Messages.getMessage("MismatchedServiceName", erpSername, wsdlServiceName.toString()));
                    }
                    String epname = sn.getEndpointName();
                    if (epname != null) {
                        QName epPort = new QName(epname);
                        QName existingPort = this.getPortName();
                        if (existingPort != null && !existingPort.equals(epPort)) {
                            String epPortStr = epPort == null ? "null" : epPort.toString();
                            throw new JAXRPCException(Messages.getMessage("MismatchedPortName", epPortStr, existingPort.toString()));
                        }
                    }
                }
            }
        } else {
            if (name.startsWith("java.") || name.startsWith("javax.")) {
                throw new JAXRPCException(Messages.getMessage("badProp05", name));
            }
            this.cachedProperties.put(name, value);
        }
        if (!messageContextsAlreadySet) {
            for (int i = 0; i < this.messageContexts.length; ++i) {
                if (this.messageContexts[i] == null) continue;
                this.messageContexts[i].setProperty(name, value);
            }
        }
    }

    public Object _getProperty(String name) {
        if (name != null) {
            Object retObj = null;
            if (name.equals("javax.xml.rpc.security.auth.username")) {
                retObj = this.cachedUsername;
            } else if (name.equals("javax.xml.rpc.security.auth.password")) {
                retObj = this.cachedPassword;
            } else if (name.equals("http.proxyHost")) {
                retObj = this.cachedhttpProxyHost;
            } else if (name.equals("http.proxyPort")) {
                retObj = this.cachedhttpProxyPort;
            } else if (name.equals("http.proxyUser")) {
                retObj = this.cachedhttpProxyUser;
            } else if (name.equals("http.proxyPassword")) {
                retObj = this.cachedhttpProxyPassword;
            } else if (name.equals("https.proxyHost")) {
                retObj = this.cachedhttpsProxyHost;
            } else if (name.equals("https.proxyPort")) {
                retObj = this.cachedhttpsProxyPort;
            } else if (name.equals("https.proxyUser")) {
                retObj = this.cachedhttpsProxyUser;
            } else if (name.equals("https.proxyPassword")) {
                retObj = this.cachedhttpsProxyPassword;
            } else if (name.equals("ssl.configName")) {
                retObj = this.cachedsslCfgName;
            } else if (name.equals("javax.xml.rpc.service.endpoint.address")) {
                retObj = this.cachedEndpoint.toString();
            } else if (name.equals("javax.xml.rpc.session.maintain")) {
                retObj = this.maintainSessionSet ? new Boolean(this.maintainSession) : null;
            } else if (name.equals("com.ibm.ws.webservices.engine.session.context")) {
                retObj = this.cachedSessionContext.get();
            } else if (name.equals("com.ibm.websphere.webservices.requestTransportProperties")) {
                retObj = this.cachedRequestTransportHeaders.get();
            } else if (name.equals("com.ibm.websphere.webservices.responseTransportProperties")) {
                retObj = this.cachedResponseTransportHeaders.get();
            } else if (name.equals("http.redirect.enabled")) {
                retObj = this.cachedhttpRedirectEnabled;
            } else if (name.equals("com.ibm.websphere.webservices.requestSoapHeaders")) {
                retObj = this.cachedRequestSoapHeaders.get();
            } else if (name.equals("com.ibm.websphere.webservices.responseSoapHeaders")) {
                retObj = this.cachedResponseSoapHeaders.get();
            } else if (name.startsWith("java.") || name.startsWith("javax.")) {
                throw new JAXRPCException(Messages.getMessage("badProp05", name));
            }
            if (retObj == null) {
                return this.cachedProperties.get(name);
            }
            return retObj;
        }
        throw new JAXRPCException(Messages.getMessage("badProp03"));
    }

    public Iterator _getPropertyNames() {
        return this.cachedProperties.keySet().iterator();
    }

    public void setUsername(String username) {
        this.cachedUsername = username;
        for (int i = 0; i < this.messageContexts.length; ++i) {
            if (this.messageContexts[i] == null) continue;
            this.messageContexts[i].setUsername(username);
        }
    }

    public String getUsername() {
        return this.cachedUsername;
    }

    public void setPassword(String password) {
        this.cachedPassword = password;
        for (int i = 0; i < this.messageContexts.length; ++i) {
            if (this.messageContexts[i] == null) continue;
            this.messageContexts[i].setPassword(password);
        }
    }

    public String getPassword() {
        return this.cachedPassword;
    }

    public int getTimeout() {
        return this.cachedTimeout == null ? 0 : this.cachedTimeout;
    }

    public void setTimeout(int timeout) {
        this.cachedTimeout = new Integer(timeout);
        for (int i = 0; i < this.messageContexts.length; ++i) {
            if (this.messageContexts[i] == null) continue;
            this.messageContexts[i].setTimeout(this.cachedTimeout);
        }
    }

    public void setWriteTimeout(int timeout) {
        this.cachedWriteTimeout = new Integer(timeout);
        for (int i = 0; i < this.messageContexts.length; ++i) {
            if (this.messageContexts[i] == null) continue;
            this.messageContexts[i].setWriteTimeout(this.cachedTimeout);
        }
    }

    public QName getPortName() {
        return this.cachedPortName;
    }

    public void setPortName(QName portName) {
        this.cachedPortName = portName;
        for (int i = 0; i < this.messageContexts.length; ++i) {
            if (this.messageContexts[i] == null) continue;
            this.messageContexts[i].setPortName(portName);
        }
    }

    public void setPortName(String portName) {
        this.setPortName(QNameTable.createQName(null, portName));
    }

    public void setMaintainSession(boolean session) {
        this.maintainSessionSet = true;
        this.maintainSession = session;
        this.cachedProperties.put("javax.xml.rpc.session.maintain", new Boolean(session));
        for (int i = 0; i < this.messageContexts.length; ++i) {
            if (this.messageContexts[i] == null) continue;
            this.messageContexts[i].setMaintainSession(this.maintainSession);
        }
    }

    protected void primeMessageContext(MessageContext msgContext) throws WebServicesFault {
        try {
            if (this.maintainSessionSet) {
                msgContext.setMaintainSession(this.maintainSession);
            }
            if (this.cachedUsername != null) {
                msgContext.setUsername(this.cachedUsername);
            }
            if (this.cachedPassword != null) {
                msgContext.setPassword(this.cachedPassword);
            }
            if (this.cachedhttpProxyHost != null) {
                msgContext.setProperty("http.proxyHost", this.cachedhttpProxyHost);
            }
            if (this.cachedhttpProxyPort != null) {
                msgContext.setProperty("http.proxyPort", this.cachedhttpProxyPort);
            }
            if (this.cachedhttpProxyUser != null) {
                msgContext.setProperty("http.proxyUser", this.cachedhttpProxyUser);
            }
            if (this.cachedhttpProxyPassword != null) {
                msgContext.setProperty("http.proxyPassword", this.cachedhttpProxyPassword);
            }
            if (this.cachedhttpsProxyHost != null) {
                msgContext.setProperty("https.proxyHost", this.cachedhttpsProxyHost);
            }
            if (this.cachedhttpsProxyPort != null) {
                msgContext.setProperty("https.proxyPort", this.cachedhttpsProxyPort);
            }
            if (this.cachedhttpsProxyUser != null) {
                msgContext.setProperty("https.proxyUser", this.cachedhttpsProxyUser);
            }
            if (this.cachedhttpsProxyPassword != null) {
                msgContext.setProperty("https.proxyPassword", this.cachedhttpsProxyPassword);
            }
            if (this.cachedsslCfgName != null) {
                msgContext.setProperty("ssl.configName", this.cachedsslCfgName);
            }
            if (this.cachedhttpRedirectEnabled != null) {
                msgContext.setProperty("http.redirect.enabled", this.cachedhttpRedirectEnabled);
            }
            if (this.cachedEndpoint != null) {
                msgContext.setTargetEndpointAddress(this.cachedEndpoint);
            }
            if (this.cachedTimeout != null) {
                msgContext.setTimeout(this.cachedTimeout);
            }
            if (this.cachedWriteTimeout != null) {
                msgContext.setWriteTimeout(this.cachedWriteTimeout);
            }
            if (this.cachedPortName != null) {
                msgContext.setPortName(this.cachedPortName);
            }
            msgContext.setProperty("com.ibm.ws.webservices.engine.session.context", this.cachedSessionContext);
            msgContext.setProperty("com.ibm.websphere.webservices.requestTransportProperties", this.cachedRequestTransportHeaders);
            msgContext.setProperty("com.ibm.websphere.webservices.requestSoapHeaders", this.cachedRequestSoapHeaders);
            Enumeration<Object> keys = this.cachedProperties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                msgContext.setProperty(key, this.cachedProperties.get(key));
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.client.Stub.primeMessageContext", "589", this);
            throw new WebServicesFault(Messages.getMessage("mcFailure", t.toString()));
        }
    }

    protected TypeMapping getTypeMapping(String encoding) {
        TypeMappingRegistry tmr = this.engine.getTypeMappingRegistry();
        TypeMapping tm = (TypeMapping)tmr.getTypeMapping(encoding);
        TypeMapping defaultTM = (TypeMapping)tmr.getDefaultTypeMapping();
        if (tm == null || tm == defaultTM) {
            tm = (TypeMapping)tmr.createTypeMapping();
            tm.setSupportedEncodings(new String[]{encoding});
            tmr.register(encoding, tm);
        }
        return tm;
    }

    protected Object convert(final Object obj, final Class cla) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return JavaUtils.convert(obj, cla);
            }
        });
    }

    public static void validateTransportPropertiesHashMap(Object value, String propertyName) {
        if (value != null && !(value instanceof HashMap)) {
            throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{propertyName, "java.util.HashMap", value.getClass().getName()}));
        }
        HashMap hashMap = (HashMap)value;
        if (hashMap != null) {
            if ("com.ibm.websphere.webservices.requestTransportProperties".equals(propertyName) && hashMap.isEmpty()) {
                throw new JAXRPCException(Messages.getMessage("badProp04"));
            }
            Set keySet = hashMap.keySet();
            Iterator keyIterator = keySet.iterator();
            while (keyIterator.hasNext()) {
                Object checkKey = keyIterator.next();
                if (checkKey == null) {
                    throw new JAXRPCException(Messages.getMessage("badProp04"));
                }
                if (!(checkKey instanceof String)) {
                    throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{propertyName, "java.lang.String", checkKey.getClass().getName()}));
                }
                if (!"com.ibm.websphere.webservices.requestTransportProperties".equals(propertyName)) continue;
                Object checkValue = hashMap.get(checkKey);
                if (checkValue == null) {
                    throw new JAXRPCException(Messages.getMessage("badProp04"));
                }
                if (checkValue instanceof String) continue;
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{propertyName, "java.lang.String", checkValue.getClass().getName()}));
            }
        }
    }

    public static void validateSoapHeadersHashMap(Object value, String propertyName) {
        if (value != null && !(value instanceof HashMap)) {
            throw new IllegalArgumentException(Messages.getMessage("badProp06", new String[]{propertyName, value.getClass().getName()}));
        }
        HashMap hashMap = (HashMap)value;
        if (hashMap != null) {
            if ("com.ibm.websphere.webservices.requestSoapHeaders".equals(propertyName) && hashMap.isEmpty()) {
                throw new IllegalArgumentException(Messages.getMessage("badProp07", new String[]{propertyName}));
            }
            Set keySet = hashMap.keySet();
            Iterator keyIterator = keySet.iterator();
            while (keyIterator.hasNext()) {
                Object checkValue;
                Object checkKey = keyIterator.next();
                if (checkKey == null) {
                    throw new IllegalArgumentException(Messages.getMessage("badProp08", new String[]{propertyName}));
                }
                if (!(checkKey instanceof QName)) {
                    throw new IllegalArgumentException(Messages.getMessage("badProp09", new String[]{propertyName, checkKey.getClass().getName()}));
                }
                if ("com.ibm.websphere.webservices.requestSoapHeaders".equals(propertyName)) {
                    checkValue = hashMap.get(checkKey);
                    if (checkValue == null) {
                        throw new IllegalArgumentException(Messages.getMessage("badProp10", new String[]{propertyName}));
                    }
                    if (!(checkValue instanceof String) && !(checkValue instanceof SOAPElement)) {
                        throw new IllegalArgumentException(Messages.getMessage("badProp11", new String[]{propertyName, checkValue.getClass().getName()}));
                    }
                }
                if (!"com.ibm.websphere.webservices.responseSoapHeaders".equals(propertyName) || (checkValue = hashMap.get(checkKey)) == null) continue;
                throw new IllegalArgumentException(Messages.getMessage("badProp12", new String[]{propertyName}));
            }
        }
    }

    protected final class Invoke {
        private Connection connection;
        private MessageContext msgContext;
        private Object[] parameters;

        public Invoke(Connection connection, MessageContext msgContext, Object[] parameters) {
            this.connection = connection;
            this.msgContext = msgContext;
            this.parameters = parameters;
        }

        public Vector invoke() throws WebServicesFault {
            HashMap transportResponseHeaders = (HashMap)Stub.this.cachedResponseTransportHeaders.get();
            if (transportResponseHeaders != null) {
                transportResponseHeaders.clear();
                ArrayList transportResponseHeaderNames = (ArrayList)Stub.this.cachedResponseTransportHeadersTemplate.get();
                if (transportResponseHeaderNames != null) {
                    Iterator i = transportResponseHeaderNames.iterator();
                    while (i.hasNext()) {
                        transportResponseHeaders.put(i.next(), null);
                    }
                }
            }
            this.msgContext.setProperty("com.ibm.websphere.webservices.responseTransportProperties", Stub.this.cachedResponseTransportHeaders);
            HashMap hm = (HashMap)Stub.this.cachedResponseSoapHeaders.get();
            if (hm != null) {
                hm.clear();
                ArrayList hdrNames = (ArrayList)Stub.this.cachedResponseSoapHeaderTemplates.get();
                if (hdrNames != null) {
                    Iterator i = hdrNames.iterator();
                    while (i.hasNext()) {
                        hm.put(i.next(), null);
                    }
                }
                this.msgContext.setProperty("com.ibm.websphere.webservices.responseSoapHeaders", hm);
            }
            Vector ret = this.connection.invoke(this.msgContext, this.parameters, null, null);
            Object sessionContext = this.msgContext.getProperty("com.ibm.ws.webservices.engine.session.context");
            if (sessionContext != null) {
                Stub.this.cachedSessionContext.set(sessionContext);
                for (int i = 0; i < Stub.this.messageContexts.length; ++i) {
                    if (Stub.this.messageContexts[i] == null || sessionContext == null) continue;
                    boolean enableMultiThreadedSession = false;
                    Object o = this.msgContext.getProperty("enableMultiThreadedSession");
                    if (o != null) {
                        enableMultiThreadedSession = (Boolean)o;
                    }
                    if (enableMultiThreadedSession) {
                        Stub.this.messageContexts[i].setProperty("com.ibm.ws.webservices.engine.session.context", sessionContext);
                        continue;
                    }
                    Stub.this.messageContexts[i].setProperty("com.ibm.ws.webservices.engine.session.context", Stub.this.cachedSessionContext);
                }
            }
            return ret;
        }
    }
}

