/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Options;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public class AdminClient {
    protected static Log log = LogFactory.getLog(AdminClient.class.getName());
    private static ThreadLocal defaultConfiguration = new ThreadLocal();
    protected Call call;
    protected static final String ROOT_UNDEPLOY = WSDDConstants.QNAME_UNDEPLOY.getLocalPart();

    public static void setDefaultConfiguration(EngineConfiguration config2) {
        defaultConfiguration.set(config2);
    }

    public AdminClient() {
        try {
            EngineConfiguration config2 = (EngineConfiguration)defaultConfiguration.get();
            Service service = config2 != null ? new Service(config2) : new Service();
            this.call = (Call)service.createCall();
        }
        catch (ServiceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.client.AdminClient.AdminClient", "146", this);
            log.fatal(Messages.getMessage("couldntCall00"), e);
            this.call = null;
        }
    }

    public Call getCall() {
        return this.call;
    }

    public String list(Options opts) throws Exception {
        this.processOpts(opts);
        return this.list();
    }

    public String list() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("doList00"));
        }
        String str = "<m:list xmlns:m=\"http://websphere.ibm.com/webservices/wsdd/\"/>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String quit(Options opts) throws Exception {
        this.processOpts(opts);
        return this.quit();
    }

    public String quit() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("doQuit00"));
        }
        String str = "<m:quit xmlns:m=\"http://websphere.ibm.com/webservices/wsdd/\"/>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String undeployHandler(String handlerName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("doQuit00"));
        }
        String str = "<m:" + ROOT_UNDEPLOY + " xmlns:m=\"" + "http://websphere.ibm.com/webservices/wsdd/" + "\">" + "<handler name=\"" + handlerName + "\"/>" + "</m:" + ROOT_UNDEPLOY + ">";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String undeployPort(String portName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("doQuit00"));
        }
        String str = "<m:" + ROOT_UNDEPLOY + " xmlns:m=\"" + "http://websphere.ibm.com/webservices/wsdd/" + "\">" + "<port name=\"" + portName + "\"/>" + "</m:" + ROOT_UNDEPLOY + ">";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String process(String[] args) throws Exception {
        StringBuffer sb = new StringBuffer();
        Options opts = new Options(args);
        opts.setDefaultURL("http://localhost:8080/web/services/AdminService");
        if (opts.isFlagSet('d') > 0) {
            // empty if block
        }
        if ((args = opts.getRemainingArgs()) == null) {
            log.info(Messages.getMessage("usage00", "AdminClient xml-files | list"));
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            ByteArrayInputStream input = null;
            if (args[i].equals("list")) {
                sb.append(this.list(opts));
                continue;
            }
            if (args[i].equals("quit")) {
                sb.append(this.quit(opts));
                continue;
            }
            if (args[i].equals("passwd")) {
                log.info(Messages.getMessage("changePwd00"));
                if (args[i + 1] == null) {
                    log.error(Messages.getMessage("needPwd00"));
                    return null;
                }
                String str = "<m:passwd xmlns:m=\"http://websphere.ibm.com/webservices/wsdd/\">";
                str = str + args[i + 1];
                str = str + "</m:passwd>";
                input = new ByteArrayInputStream(str.getBytes());
                ++i;
                sb.append(this.process(opts, input));
                continue;
            }
            if (args[i].indexOf(File.pathSeparatorChar) == -1) {
                log.info(Messages.getMessage("processFile00", args[i]));
                sb.append(this.process(opts, args[i]));
                continue;
            }
            StringTokenizer tokenizer = null;
            tokenizer = new StringTokenizer(args[i], File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String file = tokenizer.nextToken();
                log.info(Messages.getMessage("processFile00", file));
                sb.append(this.process(opts, file));
                if (!tokenizer.hasMoreTokens()) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void processOpts(Options opts) throws Exception {
        if (this.call == null) {
            throw new Exception(Messages.getMessage("nullCall00"));
        }
        this.call.setTargetEndpointAddress(new URL(opts.getURL()));
        this.call.setUsername(opts.getUser());
        this.call.setPassword(opts.getPassword());
        String tName = opts.isValueSet('t');
        if (tName != null && !tName.equals("")) {
            this.call.setProperty("transport_name", tName);
        }
    }

    public String process(InputStream input) throws Exception {
        return this.process(null, input);
    }

    public String process(URL xmlURL) throws Exception {
        return this.process(null, xmlURL.openStream());
    }

    public String process(String xmlFile) throws Exception {
        FileInputStream in = new FileInputStream(xmlFile);
        String result = this.process(null, in);
        in.close();
        return result;
    }

    public String process(Options opts, String xmlFile) throws Exception {
        this.processOpts(opts);
        return this.process(xmlFile);
    }

    public String process(Options opts, InputStream input) throws Exception {
        if (this.call == null) {
            throw new Exception(Messages.getMessage("nullCall00"));
        }
        if (opts != null) {
            this.processOpts(opts);
        }
        this.call.setUseSOAPAction(true);
        this.call.setSOAPActionURI("AdminService");
        List result = null;
        Element el = XMLUtils.newDocument(input).getDocumentElement();
        SOAPFactory sf = new SOAPFactory();
        SOAPBodyElement sbe = sf.createSOAPBodyElement(el.getNamespaceURI(), el.getLocalName());
        sbe.setPrefix(el.getPrefix());
        sbe.setAlternateContent(el);
        Object[] params = new Object[]{sbe};
        result = (List)this.call.invoke(params);
        input.close();
        if (result == null || result.isEmpty()) {
            throw new WebServicesFault(Messages.getMessage("nullResponse00"));
        }
        SOAPBodyElement body = (SOAPBodyElement)result.get(0);
        return body.toString();
    }

    public static void main(String[] args) {
        try {
            AdminClient admin = new AdminClient();
            String result = admin.process(args);
            if (result != null) {
                log.info(result);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.client.AdminClient.main", "375");
            log.error(Messages.getMessage("exception00"), e);
            System.exit(1);
        }
    }
}

