/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public class ManagedMemoryDataSource
implements DataSource {
    protected static Log log = LogFactory.getLog(ManagedMemoryDataSource.class.getName());
    protected String contentType = "application/octet-stream";
    InputStream ss = null;
    protected File diskCacheFile = null;
    protected WeakHashMap readers = new WeakHashMap();
    protected boolean deleted = false;
    public static final int READ_CHUNK_SZ = 32768;
    protected boolean debugEnabled = false;
    protected static int maxCached = 32768;
    protected LinkedList memorybuflist = new LinkedList();
    protected byte[] currentMemoryBuf = null;
    protected int currentMemoryBufSz = 0;
    protected int totalsz = 0;
    protected BufferedOutputStream cachediskstream = null;
    protected boolean closed = false;
    private IOException propagateIOException;
    protected static Log is_log;

    protected ManagedMemoryDataSource() {
    }

    public ManagedMemoryDataSource(InputStream ss, String contentType) throws IOException {
        this(ss, maxCached, contentType, true);
    }

    public ManagedMemoryDataSource(InputStream ss, int maxCachedIn, String contentType, boolean readall) throws IOException {
        this.ss = ss;
        maxCached = maxCachedIn;
        if (null != contentType && contentType.length() != 0) {
            this.contentType = contentType;
        }
        if (maxCached < -1) {
            throw new IllegalArgumentException(Messages.getMessage("badMaxCached", "" + maxCached));
        }
        if (log.isDebugEnabled()) {
            this.debugEnabled = true;
        }
        if (readall) {
            byte[] readbuffer = new byte[32768];
            int read = 0;
            do {
                if ((read = ss.read(readbuffer)) <= 0) continue;
                this.write(readbuffer, read);
            } while (read > -1);
            this.close();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public synchronized InputStream getInputStream() throws IOException {
        return new Instream();
    }

    public String getName() {
        String ret = null;
        try {
            this.flushToDisk();
            if (this.diskCacheFile != null) {
                ret = this.diskCacheFile.getAbsolutePath();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.getName", "232", this);
            this.diskCacheFile = null;
        }
        return ret;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    protected void write(byte[] data) throws IOException {
        this.write(data, data.length);
    }

    protected synchronized void write(byte[] data, int length) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        int writesz = length;
        int byteswritten = 0;
        if (null != this.memorybuflist && this.totalsz + writesz > maxCached && null == this.cachediskstream) {
            this.flushToDisk();
        }
        if (this.memorybuflist != null) {
            do {
                if (null == this.currentMemoryBuf) {
                    this.currentMemoryBuf = new byte[32768];
                    this.currentMemoryBufSz = 0;
                    this.memorybuflist.add(this.currentMemoryBuf);
                }
                int bytes2write = Math.min(writesz - byteswritten, this.currentMemoryBuf.length - this.currentMemoryBufSz);
                System.arraycopy(data, byteswritten, this.currentMemoryBuf, this.currentMemoryBufSz, bytes2write);
                this.currentMemoryBufSz += bytes2write;
                if ((byteswritten += bytes2write) >= writesz) continue;
                this.currentMemoryBuf = new byte[32768];
                this.currentMemoryBufSz = 0;
                this.memorybuflist.add(this.currentMemoryBuf);
            } while (byteswritten < writesz);
        }
        if (null != this.cachediskstream) {
            this.cachediskstream.write(data, 0, length);
        }
        this.totalsz += writesz;
    }

    protected synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (null != this.cachediskstream) {
                this.cachediskstream.close();
                this.cachediskstream = null;
            }
            if (null != this.memorybuflist) {
                if (this.currentMemoryBufSz > 0) {
                    byte[] tmp = new byte[this.currentMemoryBufSz];
                    System.arraycopy(this.currentMemoryBuf, 0, tmp, 0, this.currentMemoryBufSz);
                    this.memorybuflist.set(this.memorybuflist.size() - 1, tmp);
                }
                this.currentMemoryBuf = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (null != this.cachediskstream) {
            this.cachediskstream.close();
            this.cachediskstream = null;
        }
    }

    protected void flushToDisk() throws IOException, FileNotFoundException {
        this.propagateIOException = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ManagedMemoryDataSource.this.privilegedFlushToDisk();
                return null;
            }
        });
        if (this.propagateIOException != null) {
            throw this.propagateIOException;
        }
    }

    private Boolean privilegedDeleteCacheFile() {
        boolean ret = false;
        try {
            ret = this.diskCacheFile.delete();
        }
        catch (Exception ioe) {
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.privilegedDeleteCacheFile", "447", this);
            this.diskCacheFile.deleteOnExit();
        }
        return new Boolean(ret);
    }

    private void privilegedFlushToDisk() {
        try {
            LinkedList ml = this.memorybuflist;
            this.memorybuflist = null;
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("maxCached", "" + maxCached, "" + this.totalsz));
            }
            if (ml != null && null == this.cachediskstream) {
                try {
                    File attDir;
                    MessageContext mc = MessageContext.getCurrentThreadsContext();
                    String attdirStr = mc == null ? null : mc.getStrProp(MessageContext.ATTACHMENTS_DIR);
                    File file = attDir = attdirStr == null ? null : new File(attdirStr);
                    if (attDir != null && !attDir.exists()) {
                        attDir.mkdir();
                    }
                    this.diskCacheFile = File.createTempFile("WebServices", "webservices", attDir);
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("diskCache", this.diskCacheFile.getAbsolutePath()));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Adding temp file " + this.diskCacheFile.getAbsolutePath() + "to be deleted on VM Exit.");
                    }
                    this.diskCacheFile.deleteOnExit();
                    this.cachediskstream = new BufferedOutputStream(new FileOutputStream(this.diskCacheFile));
                    int listsz = ml.size();
                    Iterator it = ml.iterator();
                    while (it.hasNext()) {
                        byte[] rbuf = (byte[])it.next();
                        int bwrite = listsz-- == 0 ? this.currentMemoryBufSz : rbuf.length;
                        this.cachediskstream.write(rbuf, 0, bwrite);
                        if (!this.closed) continue;
                        this.cachediskstream.close();
                        this.cachediskstream = null;
                    }
                    this.memorybuflist = null;
                }
                catch (SecurityException se) {
                    FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.flushToDisk", "459", this);
                    this.diskCacheFile = null;
                    this.cachediskstream = null;
                    maxCached = Integer.MAX_VALUE;
                }
            }
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.privilegedFlushToDisk", "512", this);
            this.propagateIOException = ioe;
        }
    }

    public synchronized boolean delete() {
        boolean ret = false;
        this.deleted = true;
        this.memorybuflist = null;
        if (this.diskCacheFile != null) {
            if (this.cachediskstream != null) {
                try {
                    this.cachediskstream.close();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.delete", "488", this);
                }
                this.cachediskstream = null;
            }
            Iterator i = this.readers.keySet().iterator();
            while (i.hasNext()) {
                Instream stream = (Instream)i.next();
                if (null == stream) continue;
                try {
                    stream.close();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.delete", "502", this);
                }
            }
            this.readers.clear();
            Boolean privRet = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ManagedMemoryDataSource.this.privilegedDeleteCacheFile();
                }
            });
            ret = privRet;
        }
        return ret;
    }

    public static void main(String[] arg) {
        try {
            String readFile = arg[0];
            String writeFile = arg[1];
            FileInputStream ss = new FileInputStream(readFile);
            ManagedMemoryDataSource ms = new ManagedMemoryDataSource(ss, 0x100000, "foo/data", true);
            DataHandler dh = new DataHandler(ms);
            InputStream is = dh.getInputStream();
            FileOutputStream fo = new FileOutputStream(writeFile);
            byte[] buf = new byte[512];
            int read = 0;
            do {
                if ((read = is.read(buf)) <= 0) continue;
                fo.write(buf, 0, read);
            } while (read > -1);
            fo.close();
            is.close();
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.main", "957");
            log.error(Messages.getMessage("exception00"), e);
        }
    }

    static {
        String cacheSize = System.getProperty("com.ibm.websphere.webservices.attachements.maxMemCacheSize");
        if (cacheSize != null) {
            maxCached = Integer.parseInt(cacheSize) * 1024;
        }
        is_log = LogFactory.getLog(Instream.class.getName());
    }

    private class Instream
    extends InputStream {
        protected int bread = 0;
        FileInputStream fin = null;
        int currentIndex = 0;
        byte[] currentBuf = null;
        int currentBufPos = 0;
        boolean readClosed = false;
        private byte[] buffer = null;
        private IOException propagateReadException = null;

        protected Instream() throws IOException {
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            ManagedMemoryDataSource.this.readers.put(this, null);
        }

        public int available() throws IOException {
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            int ret = ManagedMemoryDataSource.this.totalsz - this.bread;
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("available() = " + ret + ".");
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                byte[] retb = new byte[1];
                int br = this.read(retb, 0, 1);
                if (br == -1) {
                    return -1;
                }
                return retb[0] == -1 ? 255 : retb[0];
            }
        }

        public boolean markSupported() {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("markSupported() = false.");
            }
            return false;
        }

        public void mark(int readlimit) {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("mark()");
            }
        }

        public void reset() throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("reset()");
            }
            throw new IOException(Messages.getMessage("noResetMark"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long skipped) throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("skip(" + skipped + ").");
            }
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            if (skipped < 1L) {
                return 0L;
            }
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                skipped = Math.min(skipped, (long)(ManagedMemoryDataSource.this.totalsz - this.bread));
                if (skipped == 0L) {
                    return 0L;
                }
                LinkedList ml = ManagedMemoryDataSource.this.memorybuflist;
                int bwritten = 0;
                if (ml != null) {
                    if (null == this.currentBuf) {
                        this.currentBuf = (byte[])ml.get(this.currentIndex);
                        this.currentBufPos = 0;
                    }
                    do {
                        long bcopy = Math.min((long)(this.currentBuf.length - this.currentBufPos), skipped - (long)bwritten);
                        bwritten = (int)((long)bwritten + bcopy);
                        this.currentBufPos = (int)((long)this.currentBufPos + bcopy);
                        if ((long)bwritten >= skipped) continue;
                        this.currentBuf = (byte[])ml.get(++this.currentIndex);
                        this.currentBufPos = 0;
                    } while ((long)bwritten < skipped);
                }
                if (null != this.fin) {
                    this.fin.skip(skipped);
                }
                this.bread = (int)((long)this.bread + skipped);
            }
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("skipped " + skipped + ".");
            }
            return skipped;
        }

        public int read(byte[] b, final int off, final int len) throws IOException {
            this.propagateReadException = null;
            this.buffer = b;
            Integer ret = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Instream.this.privilegedRead(off, len);
                }
            });
            if (this.propagateReadException != null) {
                throw this.propagateReadException;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer privilegedRead(int off, int len) {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug(this.hashCode() + " read(" + off + ", " + len + ")");
            }
            try {
                if (ManagedMemoryDataSource.this.deleted) {
                    throw new IOException(Messages.getMessage("resourceDeleted"));
                }
                if (this.readClosed) {
                    throw new IOException(Messages.getMessage("streamClosed"));
                }
                if (this.buffer == null) {
                    throw new InternalException(Messages.getMessage("nullInput"));
                }
                if (off < 0) {
                    throw new IndexOutOfBoundsException(Messages.getMessage("negOffset", "" + off));
                }
                if (len < 0) {
                    throw new IndexOutOfBoundsException(Messages.getMessage("length", "" + len));
                }
                if (len + off > this.buffer.length) {
                    throw new IndexOutOfBoundsException(Messages.getMessage("writeBeyond"));
                }
                if (len == 0) {
                    return new Integer(0);
                }
                int bwritten = 0;
                ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
                synchronized (managedMemoryDataSource) {
                    if (this.bread == ManagedMemoryDataSource.this.totalsz) {
                        return new Integer(-1);
                    }
                    LinkedList ml = ManagedMemoryDataSource.this.memorybuflist;
                    len = Math.min(len, ManagedMemoryDataSource.this.totalsz - this.bread);
                    if (ManagedMemoryDataSource.this.debugEnabled) {
                        is_log.debug("len = " + len);
                    }
                    if (ml != null) {
                        if (null == this.currentBuf) {
                            this.currentBuf = (byte[])ml.get(this.currentIndex);
                            this.currentBufPos = 0;
                        }
                        do {
                            int bcopy = Math.min(this.currentBuf.length - this.currentBufPos, len - bwritten);
                            System.arraycopy(this.currentBuf, this.currentBufPos, this.buffer, off + bwritten, bcopy);
                            this.currentBufPos += bcopy;
                            if ((bwritten += bcopy) >= len) continue;
                            this.currentBuf = (byte[])ml.get(++this.currentIndex);
                            this.currentBufPos = 0;
                        } while (bwritten < len);
                    }
                    if (bwritten == 0 && null != ManagedMemoryDataSource.this.diskCacheFile) {
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            is_log.debug(Messages.getMessage("reading", "" + len));
                        }
                        if (null == this.fin) {
                            if (ManagedMemoryDataSource.this.debugEnabled) {
                                is_log.debug(Messages.getMessage("openBread", ManagedMemoryDataSource.this.diskCacheFile.getCanonicalPath()));
                            }
                            if (ManagedMemoryDataSource.this.debugEnabled) {
                                is_log.debug(Messages.getMessage("openBread", "" + this.bread));
                            }
                            this.fin = new FileInputStream(ManagedMemoryDataSource.this.diskCacheFile);
                            if (this.bread > 0) {
                                this.fin.skip(this.bread);
                            }
                        }
                        if (ManagedMemoryDataSource.this.cachediskstream != null) {
                            if (ManagedMemoryDataSource.this.debugEnabled) {
                                is_log.debug(Messages.getMessage("flushing"));
                            }
                            ManagedMemoryDataSource.this.cachediskstream.flush();
                        }
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            is_log.debug(Messages.getMessage("flushing"));
                            is_log.debug("len=" + len);
                            is_log.debug("off=" + off);
                            is_log.debug("b.length=" + this.buffer.length);
                        }
                        bwritten = this.fin.read(this.buffer, off, len);
                    }
                    if (bwritten > 0) {
                        this.bread += bwritten;
                    }
                }
                if (ManagedMemoryDataSource.this.debugEnabled) {
                    is_log.debug(this.hashCode() + Messages.getMessage("read", "" + bwritten));
                }
                return new Integer(bwritten);
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.privilegedRead", "958", this);
                this.propagateReadException = ioe;
                return null;
            }
        }

        public synchronized void close() throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("close()");
            }
            if (!this.readClosed) {
                ManagedMemoryDataSource.this.readers.remove(this);
                this.readClosed = true;
                if (this.fin != null) {
                    this.fin.close();
                }
                this.fin = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

