/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.ImageDataSource;
import com.ibm.ws.webservices.engine.attachments.MimeMultipartDataSource;
import com.ibm.ws.webservices.engine.attachments.PlainTextDataSource;
import com.ibm.ws.webservices.engine.attachments.SourceDataSource;
import com.ibm.ws.webservices.engine.encoding.ser.ImageDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.MimeMultipartDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.PlainTextDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SourceDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.awt.Image;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;

public class AttachmentUtils {
    private AttachmentUtils() {
    }

    public static DataHandler getActivationDataHandler(Part part) throws WebServicesFault {
        if (null == part) {
            throw new WebServicesFault(Messages.getMessage("gotNullPart"));
        }
        if (!(part instanceof AttachmentPart)) {
            throw new WebServicesFault(Messages.getMessage("unsupportedAttach", part.getClass().getName(), AttachmentPart.class.getName()));
        }
        return ((AttachmentPart)part).getActivationDataHandler();
    }

    public static boolean isAttachment(Object value) {
        if (null == value) {
            return false;
        }
        return value instanceof DataHandler;
    }

    public static boolean isMIME(QName type) {
        if (type != null && "http://xml.apache.org/xml-soap".equals(type.getNamespaceURI())) {
            return Constants.MIME_IMAGE.equals(type) || Constants.MIME_PLAINTEXT.equals(type) || Constants.MIME_MULTIPART.equals(type) || Constants.MIME_SOURCE.equals(type) || Constants.MIME_OCTETSTREAM.equals(type) || Constants.MIME_DATA_HANDLER.equals(type);
        }
        return false;
    }

    public static String mime(QName type) {
        if (type != null && "http://xml.apache.org/xml-soap".equals(type.getNamespaceURI())) {
            String mime = null;
            if (Constants.MIME_IMAGE.equals(type)) {
                mime = "image/jpeg";
            } else if (Constants.MIME_PLAINTEXT.equals(type)) {
                mime = "text/plain";
            } else if (Constants.MIME_MULTIPART.equals(type)) {
                mime = "multipart/*";
            } else if (Constants.MIME_SOURCE.equals(type)) {
                mime = "text/xml";
            } else if (Constants.MIME_OCTETSTREAM.equals(type)) {
                mime = "application/octet-stream";
            } else if (Constants.MIME_DATA_HANDLER.equals(type)) {
                mime = "application/octet-stream";
            }
            return mime;
        }
        return null;
    }

    public static DataHandler dataHandlerForObject(String mimeType, Object attachment) throws SOAPException {
        DataSource ds = null;
        if (attachment instanceof DataHandler) {
            return (DataHandler)attachment;
        }
        if (mimeType != null) {
            if (attachment instanceof Image && mimeType.startsWith("image/")) {
                ds = new ImageDataSource("image", mimeType, (Image)attachment);
            } else if (attachment instanceof String && mimeType.equals("text/plain")) {
                ds = new PlainTextDataSource("plainText", (String)attachment);
            } else if (attachment instanceof MimeMultipart && mimeType.startsWith("multipart/")) {
                ds = new MimeMultipartDataSource("multipart", (MimeMultipart)attachment);
            } else if (attachment instanceof StreamSource && (mimeType.equals("application/xml") || mimeType.equals("text/xml"))) {
                ds = new SourceDataSource("source", mimeType, (StreamSource)attachment);
            }
        }
        if (ds == null) {
            throw new SOAPException(Messages.getMessage("mimeObjectClash00", mimeType, attachment.getClass().toString()));
        }
        return new DataHandler(ds);
    }

    public static Object objectForDataHandler(DataHandler dh) {
        String type = dh.getContentType();
        JAFDataHandlerDeserializer dser = null;
        if (type != null) {
            if (type.startsWith("image/")) {
                dser = new ImageDataHandlerDeserializer(null, null);
            } else if (type.equals("text/plain")) {
                dser = new PlainTextDataHandlerDeserializer(null, null);
            } else if (type.startsWith("multipart/")) {
                dser = new MimeMultipartDataHandlerDeserializer(null, null);
            } else if (type.equals("application/xml") || type.equals("text/xml")) {
                dser = new SourceDataHandlerDeserializer(null, null);
            }
        }
        return dser == null ? dh : dser.makeValue(dh);
    }
}

