/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.utils.BufferedWriter;
import com.ibm.ws.webservices.utils.LowFlushFilter;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPPart
extends com.ibm.ws.webservices.engine.xmlsoap.SOAPPart
implements Part {
    protected static Log log = LogFactory.getLog(SOAPPart.class.getName());
    private static final String[] formNames = new String[]{"**undefined-SOAPPart-form**", "FORM_WEBSERVICESINPUTSOURCE", "FORM_SOAP_FAULT", "FORM_WEBSERVICES_FAULT", "FORM_SOAPENVELOPE"};
    private static final int FORM_NONE = 0;
    private static final int FORM_WS_INPUTSOURCE = 1;
    private static final int FORM_SOAP_FAULT = 2;
    private static final int FORM_MUTABLES = 3;
    private static final int FORM_WEBSERVICES_FAULT = 3;
    private static final int FORM_SOAPENVELOPE = 4;
    private Object currentContent;
    private int currentForm;
    private int targetForm = 0;
    private WebServicesInputSource originalContent;
    private int originalParseLength = -1;
    private WebServicesInputSource cacheWebServicesInputSource = null;
    private SOAPEnvelope cacheSOAPEnvelope = null;
    private SOAPFaultException cacheSOAPFaultException = null;
    private WebServicesFault cacheWebServicesFault = null;
    private Message msg;
    private MimeHeaders mimeHeaders = new MimeHeaders();

    public SOAPPart(Object initialContents) {
        this(initialContents, null);
    }

    public SOAPPart(Object initialContents, Message msg) {
        this.msg = msg;
        int form = 1;
        if (initialContents instanceof SOAPEnvelope) {
            form = 4;
        } else if (initialContents instanceof WebServicesFault) {
            form = 3;
        } else if (initialContents instanceof SOAPFaultException) {
            form = 2;
        }
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart ctor(" + formNames[form] + ")");
        }
        this.setCurrentContent(initialContents, form);
        this.setMimeHeader("Content-Type", this.getContentType());
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPPart ctor()");
        }
        if (this.currentForm == 1 && msg != null) {
            ((WebServicesInputSource)this.currentContent).setEncoding(msg.getCharacterEncoding());
        }
    }

    public Message getMessage() {
        return this.msg;
    }

    public void setMessage(Message msg) {
        if (this.currentForm == 1) {
            ((WebServicesInputSource)this.currentContent).setEncoding(msg.getCharacterEncoding());
        }
        this.msg = msg;
    }

    public String getContentType() {
        if (this.msg != null) {
            return this.msg.getSOAPConstants().getContentTypeValue();
        }
        return "text/xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentLength() {
        int length;
        try {
            try {
                WebServicesInputSource wsis = this._getWebServicesInputSource();
                length = wsis.getContentLength();
            }
            catch (WebServicesFault fault) {
                length = 0;
                Object var4_5 = null;
                if (this.isCurrentFormMutable()) {
                    this._clearCache();
                }
            }
            Object var4_4 = null;
            if (this.isCurrentFormMutable()) {
                this._clearCache();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (this.isCurrentFormMutable()) {
                this._clearCache();
            }
            throw throwable;
        }
        return length;
    }

    public String getOriginalMessage() {
        if (this.originalContent == null) {
            return null;
        }
        return this.originalContent.getString();
    }

    public byte[] getOriginalMessageAsBytes() {
        if (this.originalContent == null) {
            return null;
        }
        return this.originalContent.getBytes();
    }

    public long getOriginalContentLength() {
        return this.originalParseLength < 0 ? (long)this.getContentLength() : (long)this.originalParseLength;
    }

    public void setSOAPEnvelope(SOAPEnvelope env) {
        this.setCurrentContent(env, 4);
        this.originalContent = null;
    }

    public int getSize() {
        return this.getContentLength();
    }

    public Object getCurrentMessage() {
        return this.getCurrentContent();
    }

    public Object getCurrentContent() {
        return this.currentContent;
    }

    private void setCurrentContent(Object content, int form) {
        this._clearCache();
        this.setCurrentForm(content, form);
    }

    private void setCurrentForm(Object content, int form) {
        if (log.isDebugEnabled()) {
            String msgStr = content instanceof String ? (String)content : content.getClass().getName();
            log.debug(Messages.getMessage("setMsgForm", formNames[form], "" + msgStr));
        }
        if (this.isFormMutable(form)) {
            this._clearCache();
        }
        this.currentContent = content;
        this.currentForm = form;
        switch (this.currentForm) {
            case 4: {
                this._setCacheSOAPEnvelope((SOAPEnvelope)this.currentContent);
                break;
            }
            case 3: {
                this._setCacheWebServicesFault((WebServicesFault)this.currentContent);
                break;
            }
            case 2: {
                this._setCacheSOAPFaultException((SOAPFaultException)this.currentContent);
                break;
            }
            case 1: {
                WebServicesInputSource wsis;
                if (this.currentContent instanceof String) {
                    wsis = WebServicesInputSource.create((String)this.currentContent);
                } else if (this.currentContent instanceof InputStream) {
                    wsis = WebServicesInputSource.create((InputStream)this.currentContent);
                } else if (this.currentContent instanceof byte[]) {
                    wsis = WebServicesInputSource.create((byte[])this.currentContent);
                } else if (this.currentContent instanceof WebServicesInputSource) {
                    wsis = (WebServicesInputSource)this.currentContent;
                } else if (this.currentContent instanceof InputSource) {
                    wsis = WebServicesInputSource.create((InputSource)this.currentContent);
                } else if (this.currentContent instanceof Source) {
                    wsis = WebServicesInputSource.create((Source)this.currentContent);
                } else {
                    throw new InternalException(Messages.getMessage("unsupportedContent", this.currentContent == null ? "null" : this.currentContent.getClass().toString()));
                }
                if (this.getMessage() != null && wsis.getEncoding() == null) {
                    wsis.setEncoding(this.getMessage().getCharacterEncoding());
                }
                this.currentContent = wsis;
                this._setCacheWebServicesInputSource(wsis);
            }
        }
    }

    public byte[] getAsBytes() throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart::getAsBytes");
        }
        WebServicesInputSource wsis = this.getAsWebServicesInputSource();
        byte[] bytes = wsis.getBytes();
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPPart::getAsBytes()");
        }
        return bytes;
    }

    public String getAsString() throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart::getAsString");
        }
        WebServicesInputSource wsis = this.getAsWebServicesInputSource();
        String string = wsis.getString();
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPPart::getAsString()");
        }
        return string;
    }

    public String getString() throws WebServicesFault {
        WebServicesInputSource wsis = this._getWebServicesInputSource();
        return wsis.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServicesInputSource getAsWebServicesInputSource() throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart::getAsWebServicesInputSource");
        }
        try {
            this.targetForm = 1;
            WebServicesInputSource wsis = this._getWebServicesInputSource();
            if (wsis != this.getCurrentMessage()) {
                this.setCurrentForm(wsis, this.targetForm);
            }
            WebServicesInputSource webServicesInputSource = wsis;
            Object var4_3 = null;
            this.targetForm = 0;
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::getWebServicesInputSource()");
            }
            return webServicesInputSource;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                this.targetForm = 0;
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exit: SOAPPart::getWebServicesInputSource()");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPEnvelope getAsSOAPEnvelope() throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart::getAsSOAPEnvelope()");
            log.debug(Messages.getMessage("currForm", formNames[this.currentForm]));
        }
        try {
            this.targetForm = 4;
            SOAPEnvelope envelope = this._getSOAPEnvelope();
            if (envelope != this.getCurrentMessage()) {
                this.setCurrentForm(envelope, 4);
            }
            SOAPEnvelope sOAPEnvelope = envelope;
            Object var4_3 = null;
            this.targetForm = 0;
            this._clearCache();
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::getAsSOAPEnvelope");
            }
            return sOAPEnvelope;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                this.targetForm = 0;
                this._clearCache();
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exit: SOAPPart::getAsSOAPEnvelope");
            }
            throw throwable;
        }
    }

    public javax.xml.soap.SOAPEnvelope getEnvelope() throws SOAPException {
        try {
            return this.getAsSOAPEnvelope();
        }
        catch (WebServicesFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.webservices.engine.SOAPPart.getEnvelope", "1122", this);
            if (log.isDebugEnabled()) {
                log.debug("Caught Exception, wrapping in SOAPException: ", af);
            }
            throw new SOAPException((Throwable)af);
        }
    }

    public Document getDocument() {
        try {
            return this.getAsSOAPEnvelope().getOwnerDocument();
        }
        catch (WebServicesFault wsf) {
            throw new DOMException(15, wsf.getMessage());
        }
    }

    public SOAPDocument getSOAPDocument() {
        return (SOAPDocument)this.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServicesFault getFault() throws SOAPException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart::getFault()");
            log.debug("getMessageContext().isHighFidelity() == " + (this.getMessage() != null && this.getMessage().getMessageContext() != null && this.getMessage().getMessageContext().isHighFidelity() ? "true" : "false"));
        }
        WebServicesFault fault = null;
        try {
            if (this._getCachedWebServicesFault() != null) {
                fault = this._getCachedWebServicesFault();
            } else if (this.currentForm == 3) {
                fault = (WebServicesFault)this.getCurrentMessage();
            } else if (this._getCachedSOAPFaultException() != null) {
                SOAPFaultException exception = this._getCachedSOAPFaultException();
                if (exception != null) {
                    fault = WebServicesFault.makeFault(exception);
                }
            } else if (this.currentForm == 2) {
                fault = WebServicesFault.makeFault((WebServicesFault)this.getCurrentMessage());
            } else {
                boolean possibly = false;
                possibly = this.currentForm == 1 ? ((WebServicesInputSource)this.currentContent).isPossiblyFault() : true;
                if (possibly) {
                    Object rep;
                    SOAPEnvelope resEnv = this._getSOAPEnvelope();
                    SOAPBody sb = (SOAPBody)resEnv.getBody();
                    Object object = rep = sb == null ? null : sb.getAlternateContent();
                    if (sb == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("no body");
                        }
                    } else if (rep instanceof RequestResponse) {
                        if (log.isDebugEnabled()) {
                            log.debug("getSOAPEnvelope().getBody().getAlternateContent() instanceof RequestResponse");
                        }
                    } else {
                        if (rep instanceof InputStream) {
                            WebServicesInputSource wsis = WebServicesInputSource.create((InputStream)rep);
                            String encoding = this.getMessage().getCharacterEncoding();
                            wsis.setEncoding(encoding);
                            sb.setAlternateContent(null);
                            sb.setAlternateContent(XMLInputSourceAlternateContent.createContentOnly(wsis));
                            rep = wsis;
                        }
                        if (rep instanceof WebServicesInputSource) {
                            if (log.isDebugEnabled()) {
                                log.debug("getSOAPEnvelope().getBody().getAlternateContent() instanceof WebServicesInputSource");
                            }
                            if (((WebServicesInputSource)rep).isPossiblyFault()) {
                                fault = SOAPPart.getFault(sb);
                            }
                        } else {
                            fault = SOAPPart.getFault(sb);
                        }
                    }
                }
            }
            if (fault != null) {
                fault.setSOAPPartFault(true);
            }
            if (this.isCurrentFormMutable()) {
                this._clearCache();
            } else {
                this._setCacheWebServicesFault(fault);
            }
            Object var9_9 = null;
            if (log.isDebugEnabled()) {
                log.debug("Exit: Message::getFault() == " + (fault == null ? "null" : "non-null"));
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (log.isDebugEnabled()) {
                log.debug("Exit: Message::getFault() == " + (fault == null ? "null" : "non-null"));
            }
            throw throwable;
        }
        return fault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTo(OutputStream os, String encoding) throws IOException {
        if (this.currentForm == 1 || this._getCachedWebServicesInputSource() != null) {
            WebServicesInputSource wsis = this._getWebServicesInputSource();
            wsis.writeTo(os, encoding);
            return;
        }
        os = new LowFlushFilter(os);
        Writer writer = null;
        writer = encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os);
        writer = new BufferedWriter(writer, os, encoding);
        try {
            this.writeTo(writer);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            writer.flush();
            if (!this.isCurrentFormMutable()) throw throwable;
            this._clearCache();
            throw throwable;
        }
        writer.flush();
        if (!this.isCurrentFormMutable()) return;
        this._clearCache();
    }

    private void writeTo(Writer writer) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart writeTo:" + writer.getClass());
        }
        switch (this.currentForm) {
            case 3: {
                WebServicesFault env = (WebServicesFault)this.getCurrentMessage();
                try {
                    SerializationContextImpl context = new SerializationContextImpl(writer, this.getMessage().getMessageContext(), this.getMessage().shouldWriteXMLDecl(), this.getMessage().getCharacterEncoding());
                    env.output(context);
                    break;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.SOAPPart.writeTo", "298", this);
                    log.error(Messages.getMessage("exception00"), e);
                    throw env;
                }
            }
            case 2: {
                SOAPFaultException env = (SOAPFaultException)this.getCurrentMessage();
                try {
                    SOAPFactory sf = new SOAPFactory();
                    SOAPEnvelope envelope = sf.createSOAPEnvelope(true);
                    SOAPFault fault = sf.createSOAPFault();
                    fault.setFault(env);
                    envelope.getBody().addChildElement((SOAPElement)fault);
                    SerializationContextImpl context = new SerializationContextImpl(writer, this.getMessage().getMessageContext(), this.getMessage().shouldWriteXMLDecl(), this.getMessage().getCharacterEncoding());
                    envelope.output(context);
                    break;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.SOAPPart.writeTo", "327", this);
                    log.error(Messages.getMessage("exception00"), e);
                    throw env;
                }
            }
            case 4: {
                SOAPEnvelope env = (SOAPEnvelope)this.getCurrentMessage();
                try {
                    SerializationContextImpl context = new SerializationContextImpl(writer, this.getMessage().getMessageContext(), this.getMessage().shouldWriteXMLDecl(), this.getMessage().getCharacterEncoding());
                    env.output(context);
                    break;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.SOAPPart.writeTo", "347", this);
                    throw WebServicesFault.makeFault(e);
                }
            }
            default: {
                WebServicesInputSource wsis = this._getWebServicesInputSource();
                wsis.writeTo(writer);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPPart writeTo " + formNames[this.currentForm]);
        }
    }

    /*
     * Loose catch block
     */
    private WebServicesInputSource _getWebServicesInputSource() throws WebServicesFault {
        WebServicesInputSource wsis;
        block8: {
            block11: {
                block10: {
                    block9: {
                        wsis = this._getCachedWebServicesInputSource();
                        if (wsis != null) break block8;
                        if (this.currentForm != 1) break block9;
                        wsis = (WebServicesInputSource)this.getCurrentContent();
                        break block8;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Converting " + formNames[this.currentForm] + " to " + formNames[1]);
                    }
                    if (this.currentForm != 3 && this.currentForm != 2 && this.currentForm != 4) break block10;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos = new ByteArrayOutputStream();
                    this.writeTo(baos, this.getMessage().getCharacterEncoding());
                    byte[] bytes = baos.toByteArray();
                    wsis = WebServicesInputSource.create(bytes);
                    wsis.setEncoding(this.getMessage().getCharacterEncoding());
                    Object var5_5 = null;
                    try {
                        baos.close();
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.SOAPPart.getString", "777", this);
                        log.warn(Messages.getMessage("exception00"), e);
                    }
                    break block11;
                    {
                        catch (IOException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.SOAPPart.getString", "770", this);
                            log.error(Messages.getMessage("exception00"), e);
                            throw WebServicesFault.makeFault(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        try {
                            baos.close();
                        }
                        catch (IOException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.SOAPPart.getString", "777", this);
                            log.warn(Messages.getMessage("exception00"), e);
                        }
                        throw throwable;
                    }
                }
                throw new InternalException(Messages.getMessage("unsupportedContent", "null"));
            }
            this._setCacheWebServicesInputSource(wsis);
        }
        return wsis;
    }

    private SOAPEnvelope _getSOAPEnvelope() throws WebServicesFault {
        SOAPEnvelope soapEnvelope = this._getCachedSOAPEnvelope();
        if (soapEnvelope == null) {
            if (this.currentForm == 4) {
                soapEnvelope = (SOAPEnvelope)this.getCurrentMessage();
            } else {
                String encoding;
                MessageContext mc;
                if (log.isDebugEnabled()) {
                    log.debug("Converting " + formNames[this.currentForm] + " to " + formNames[4]);
                }
                if ((mc = this.getMessage().getMessageContext()) != null) {
                    if (mc.isHighFidelity()) {
                        if (this.originalContent == null) {
                            this.originalContent = this._getCachedWebServicesInputSource();
                        }
                    } else {
                        this.originalContent = null;
                    }
                }
                WebServicesInputSource wsis = this._getWebServicesInputSource();
                if (log.isDebugEnabled()) {
                    log.debug("Parsing inputSource " + wsis.dumpStats());
                }
                if ((encoding = this.getMessage().getCharacterEncoding()) != null) {
                    wsis.setEncoding(encoding);
                }
                DeserializationContextImpl dser = new DeserializationContextImpl(wsis, this.getMessage().getMessageContext(), this.getMessage().getMessageType(), this.getMessage().getSOAPConstants(), Utils._isSAAJ13Enabled());
                try {
                    dser.parse();
                }
                catch (SAXException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.SOAPPart.getSOAPEnvelope", "964", this);
                    Exception real = e.getException();
                    wsis.reset();
                    if (real instanceof WebServicesFault) {
                        throw (WebServicesFault)real;
                    }
                    if (this.originalContent == null) {
                        this.originalContent = wsis;
                    }
                    if (this.originalContent == null) {
                        throw WebServicesFault.makeFault("To see the message containing the parsing error in the log, either enable web service engine tracing or set MessageContext.setHighFidelity(true).", real != null ? real : e);
                    }
                    throw WebServicesFault.makeFault("Message being parsed: " + this.originalContent.getString(), real != null ? real : e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Done parsing inputSource.");
                }
                this.originalParseLength = wsis.getContentLength();
                soapEnvelope = dser.getEnvelope();
                this.setCurrentForm(soapEnvelope, 4);
                String messageProtocol = this.getMessage().getSOAPConstants().getSOAPProtocol();
                String factoryProtocol = soapEnvelope.getSOAPFactory().getSOAPConstants().getSOAPProtocol();
                String envelopeProtocol = "SOAP 1.1 Protocol";
                String ns = soapEnvelope.getNamespaceURI();
                if (soapEnvelope.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    envelopeProtocol = "SOAP 1.2 Protocol";
                }
                if (messageProtocol.equals("Dynamic Protocol")) {
                    this.getMessage().setSOAPConstants(soapEnvelope.getSOAPFactory().getSOAPConstants());
                    messageProtocol = this.getMessage().getSOAPConstants().getSOAPProtocol();
                }
                if (envelopeProtocol.equals(factoryProtocol) && factoryProtocol.equals(messageProtocol)) {
                    if (log.isDebugEnabled()) {
                        log.debug("The protocol is: " + envelopeProtocol);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("The SOAPEnvelope protocol is: " + envelopeProtocol);
                    log.debug("The SOAPFactory protocol is: " + factoryProtocol);
                    log.debug("The SOAPMessage protocol is: " + messageProtocol);
                }
            }
        }
        return soapEnvelope;
    }

    private static WebServicesFault getFault(SOAPBody sb) {
        SOAPBodyElement bodyEl;
        if (sb.getNumChildren() > 0 && (bodyEl = (SOAPBodyElement)sb.getChildElement(0)) instanceof SOAPFault) {
            if (log.isDebugEnabled()) {
                log.debug("getSOAPEnvelope().getBody().getChildElement(0) instanceof SOAPFault");
            }
            return ((SOAPFault)bodyEl).getFault();
        }
        if (log.isDebugEnabled()) {
            log.debug("getSOAPEnvelope().getBody().getChildElement(0) NOT instanceof SOAPFault");
        }
        return null;
    }

    private void _setCacheWebServicesInputSource(WebServicesInputSource wsis) {
        if (log.isDebugEnabled()) {
            log.debug("Caching " + formNames[1]);
        }
        this.cacheWebServicesInputSource = wsis;
    }

    private WebServicesInputSource _getCachedWebServicesInputSource() {
        if (log.isDebugEnabled() && this.cacheWebServicesInputSource != null) {
            log.debug("Using Cached " + formNames[1]);
        }
        return this.cacheWebServicesInputSource;
    }

    private void _setCacheSOAPEnvelope(SOAPEnvelope envelope) {
        if (log.isDebugEnabled()) {
            log.debug("Caching " + formNames[4]);
        }
        if (this.getMessage() != null && !envelope.getSOAPFactory().getSOAPConstants().getSOAPProtocol().equals(this.getMessage().getSOAPConstants().getSOAPProtocol())) {
            throw new IllegalArgumentException(Messages.getMessage("internalSOAPPartErr", envelope.getSOAPFactory().getSOAPConstants().getSOAPProtocol(), this.getMessage().getSOAPConstants().getSOAPProtocol()));
        }
        this.cacheSOAPEnvelope = envelope;
    }

    private SOAPEnvelope _getCachedSOAPEnvelope() {
        if (log.isDebugEnabled() && this.cacheSOAPEnvelope != null) {
            log.debug("Using Cached " + formNames[4]);
        }
        return this.cacheSOAPEnvelope;
    }

    private void _setCacheSOAPFaultException(SOAPFaultException soapFault) {
        if (log.isDebugEnabled()) {
            log.debug("Caching " + formNames[2]);
        }
        this.cacheSOAPFaultException = soapFault;
    }

    private SOAPFaultException _getCachedSOAPFaultException() {
        if (log.isDebugEnabled() && this.cacheSOAPFaultException != null) {
            log.debug("Using Cached " + formNames[2]);
        }
        return this.cacheSOAPFaultException;
    }

    private void _setCacheWebServicesFault(WebServicesFault webServicesFault) {
        if (log.isDebugEnabled()) {
            log.debug("Caching " + formNames[3]);
        }
        this.cacheWebServicesFault = webServicesFault;
    }

    private WebServicesFault _getCachedWebServicesFault() {
        if (log.isDebugEnabled() && this.cacheWebServicesFault != null) {
            log.debug("Using Cached " + formNames[3]);
        }
        return this.cacheWebServicesFault;
    }

    private void _clearCache() {
        if (log.isDebugEnabled()) {
            log.debug("Clear SOAPPart Cache");
        }
        this.cacheWebServicesInputSource = null;
        this.cacheSOAPEnvelope = null;
        this.cacheSOAPFaultException = null;
        this.cacheWebServicesFault = null;
    }

    private boolean isCurrentFormMutable() {
        return this.isFormMutable(this.currentForm);
    }

    private boolean isFormMutable(int form) {
        return form >= 3;
    }

    public static String convertBytesToString(byte[] bytes, String encoding) {
        return JavaUtils.convertBytesToString(bytes, encoding);
    }

    public static byte[] convertStringToBytes(String string, String encoding) {
        return JavaUtils.convertStringToBytes(string, encoding);
    }

    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.addHeader(header, value);
    }

    private String getFirstMimeHeader(String header) {
        String[] values = this.mimeHeaders.getHeader(header);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String loc) {
        this.setMimeHeader("Content-Location", loc);
    }

    public void setContentId(String newCid) {
        this.setMimeHeader("Content-Id", newCid);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    public Iterator getMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getMatchingHeaders(match);
    }

    public Iterator getNonMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getNonMatchingHeaders(match);
    }

    public Source getContent() throws SOAPException {
        try {
            WebServicesInputSource wsis = this.getAsWebServicesInputSource();
            return wsis.createTransformSource();
        }
        catch (WebServicesFault wsf) {
            FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.SOAPPart.getContent", "1242", this);
            throw new SOAPException((Throwable)wsf);
        }
    }

    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.originalContent = null;
        this._clearCache();
        WebServicesInputSource wsis = WebServicesInputSource.create(source);
        String encoding = wsis.getEncoding();
        if (encoding != null) {
            this.msg.setCharacterEncoding(encoding);
            this.setCurrentContent(wsis, 1);
        } else {
            wsis.setEncoding(this.msg.getCharacterEncoding());
            this.setCurrentContent(wsis, 1);
            try {
                this.getAsSOAPEnvelope();
            }
            catch (Exception ex) {
                this.setCurrentContent(wsis, 1);
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.SOAPPart.setContent", "1165", this);
            }
        }
    }

    public void setContent(String newMessage) throws SOAPException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart::setContent");
        }
        if (newMessage == null || newMessage.length() == 0) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.originalContent = null;
        WebServicesInputSource wsis = WebServicesInputSource.create(newMessage);
        this.setCurrentContent(wsis, 1);
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPPart::setContent: " + this.getCurrentMessage());
        }
    }

    public void setContent(byte[] newMessage) throws SOAPException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart::setContent(byte[])");
        }
        if (newMessage == null || newMessage.length == 0) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.originalContent = null;
        WebServicesInputSource wsis = WebServicesInputSource.create(newMessage);
        this.setCurrentContent(wsis, 1);
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPPart::setContent(byte[]): " + this.getCurrentMessage());
        }
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }
}

