/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.enabler;

import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.enabler.resources.Messages;
import java.util.Vector;

public class ClientTraceEnabler {
    private static boolean trace = false;
    private static String traceString = "com.ibm.ws.webservices.*=all=enabled";
    private static String traceOutput = "named file";
    private static String tracefile = "ws5eeEnabler.log";
    private static String traceMode = "ManagerAdmin.BASIC";
    private static String CCPrefix = "-CC";
    private static int CCPrefixLength = CCPrefix.length();

    protected static String[] parseTraceOptions(String[] argv) throws Exception {
        Vector<String> v = new Vector<String>();
        if (!trace && argv.length > 0) {
            for (int i = 0; i < argv.length; ++i) {
                String token = argv[i].trim();
                if (token.equalsIgnoreCase("-CChelp")) {
                    ClientTraceEnabler.printHelp();
                    continue;
                }
                if (token.startsWith(CCPrefix)) {
                    String arg = token.substring(CCPrefixLength);
                    int index = arg.indexOf(61);
                    if (index < 0) continue;
                    String argName = arg.substring(0, index);
                    String argValue = arg.substring(index + 1);
                    if (argValue == null && argValue.trim().length() == 0) continue;
                    if (argName.equalsIgnoreCase("trace")) {
                        try {
                            trace = true;
                            ManagerAdmin.checkTraceString(argValue);
                            traceString = argValue;
                        }
                        catch (MalformedTraceStringException e) {
                            FFDCFilter.processException(e, "com.ibm.ws.webservices.enabler.ClientTraceEnabler.parseTraceOptions", "110");
                        }
                        continue;
                    }
                    if (argName.equalsIgnoreCase("tracefile")) {
                        tracefile = argValue;
                        continue;
                    }
                    if (!argName.equalsIgnoreCase("traceOutput")) continue;
                    traceOutput = "stdout";
                    tracefile = null;
                    continue;
                }
                v.addElement(token);
            }
        }
        Object[] newArray = new String[v.size()];
        v.copyInto(newArray);
        if (trace) {
            ManagerAdmin.configureClientTrace(traceString, "named file", tracefile, false, traceMode, false);
            Object[] inserts = new String[]{traceString};
            System.out.println(Messages.getFormattedMessage((String)"clienttrace.trace_enabled", (Object[])inserts, (String)"Trace has been enabled for the following components: {0}"));
            if (traceOutput.equals("named file")) {
                Object[] inserts2 = new String[]{tracefile};
                System.out.println(Messages.getFormattedMessage((String)"clienttrace.trace_to_file", (Object[])inserts2, (String)"Trace data will be logged in file: {0}"));
            } else {
                System.out.println(Messages.getString((String)"clienttrace.trace_to_stdout", (String)"Trace data will be displayed on stdout."));
            }
        }
        return newArray;
    }

    public static void printHelp() throws Exception {
        String traceOptions = Messages.getMessage((String)"clienttrace.trace_options", (String)"");
        Object[] inserts = new String[]{traceOptions};
        System.out.println();
        System.out.println(Messages.getFormattedMessage((String)"clienttrace.trace_help", (Object[])inserts, (String)""));
        throw new Exception("");
    }
}

