/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.combined.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.environment.common.ClassPath;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.environment.console.ConsoleEnvironment;
import com.ibm.etools.environment.resource.ResourceManagerFactory;
import com.ibm.etools.environment.resource.ResourceManagerFactoryImpl;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import com.ibm.etools.webservice.deploy.core.DeployWebService;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.enabler.EndpointEnabler;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class WSDeployTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(WSDeployTask.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    public static final String ENABLE_ENDPOINT_OPTION = "enableEndpoint";
    public static final String ENABLE_HTTP_ROUTER_SECURITY_OPTION = "enableHttpRouterSecurity";
    public static final String ENABLE_ENDPOINT_PROPS = "endpointEnableProps";
    private static final String WEBSERVICES_BUNDLE_NAME = "com.ibm.ws.runtime";
    private static final String CURRENT_DEV_J2EE_JAR = File.separator + "dev" + File.separator + "JavaEE" + File.separator + "j2ee.jar";

    public WSDeployTask() {
        this.appTaskName = "WSDeployTask";
        this.bundle = ResourceBundle.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages");
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        InstallScheduler scheduler = (InstallScheduler)this.scheduler;
        EARFile earFile = scheduler.getEarFile(false, true);
        Hashtable appOptions = scheduler.getProperties();
        Object deploywsOption = appOptions.get("deployws");
        Boolean enableEndpointOption = (Boolean)appOptions.get(ENABLE_ENDPOINT_OPTION);
        Boolean enableHttpRouterSecurityOption = (Boolean)appOptions.get(ENABLE_HTTP_ROUTER_SECURITY_OPTION);
        String endpointEnablerPropsFile = (String)appOptions.get(ENABLE_ENDPOINT_PROPS);
        boolean wsSecEnabled = DeployUtils.isWebServicesSecurityEnabled((EARFile)earFile);
        if (deploywsOption != null && ((Boolean)deploywsOption).booleanValue()) {
            String waslib;
            String tmpDir = AppUtils.getAppTempDeployDir((Scheduler)scheduler);
            String deplEarName = tmpDir + File.separator + "ws" + File.separator + AppUtils.getAppDeployFileName((String)scheduler.getAppName()) + ".ear";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "temp deployment ear name", deplEarName);
            }
            Hashtable tbl = (Hashtable)appOptions.get("deployws.options");
            String classpath = (String)tbl.get("deployws.classpath");
            String jardirs = (String)tbl.get("deployws.jardirs");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "{classpath, jardirs}", new Object[]{classpath, jardirs});
            }
            DeployModel model = new DeployModel();
            model.setInputFile(scheduler.getEarPath());
            model.setOutputFile(deplEarName);
            model.setCodeGenOnly(false);
            model.setGenDebug(false);
            model.setKeepFiles(false);
            model.setIgnoreErrors_(false);
            ClassPath path = new ClassPath();
            if (classpath != null && (classpath = classpath.trim()).length() > 0) {
                path.appendPath(classpath);
            }
            if (jardirs != null && (jardirs = jardirs.trim()).length() > 0) {
                StringTokenizer st = new StringTokenizer(jardirs, ";");
                String[] classDirs = new String[st.countTokens()];
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    ClassPath newPath = new ClassPath();
                    newPath.appendDir(token);
                    path.appendPath(newPath);
                }
            }
            if ((waslib = this.getWASLibDir()) != null) {
                ClassPath cp = new ClassPath();
                cp.appendDir(waslib);
                path.appendPath(cp);
                String webServicesJarPath = this.getWebServicesJarPath();
                path.appendPath(webServicesJarPath);
                path.appendPath(this.getJ2eeJarPath(CURRENT_DEV_J2EE_JAR));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can not obtain the WAS lib directory");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "class path: ", path);
            }
            model.setClassPath(path);
            ConsoleEnvironment environment = new ConsoleEnvironment();
            environment.setProgressMonitor(new ProgressMonitor(){

                public void report(String progress) {
                }

                public ProgressMonitor getChildProgressMonitor() {
                    return null;
                }
            });
            ResourceManagerFactory rmFactory = ResourceManagerFactoryImpl.getInstance();
            rmFactory.register("file", environment.getResourceManager());
            DeployWebService webservice = new DeployWebService();
            webservice.setDeployModel(model);
            Status status = webservice.execute((Environment)environment);
            int severity = status.getSeverity();
            String msg = status.getMessage();
            Throwable throwable = this.findThrowable(status);
            switch (severity) {
                case 4: {
                    Tr.error(tc, "WSWS0038E", msg);
                    this.iterateError(status);
                    scheduler.propagateTaskEvent(this.createNotification("Failed", "WSWS0038E", new String[]{msg}));
                    if (throwable != null) {
                        throw new AdminException(throwable, msg);
                    }
                    throw new AdminException(msg);
                }
                case 2: {
                    Tr.warning(tc, "WSWS0039W", msg);
                    scheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0039W", new String[]{msg}));
                    break;
                }
                case 1: {
                    Tr.info(tc, "WSWS0040I", msg);
                    scheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0040I", new String[]{msg}));
                    break;
                }
                case 0: {
                    Tr.audit(tc, "WSWS0041I");
                    scheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0041I", null));
                }
            }
            scheduler.setEarPath(deplEarName);
        }
        if (enableEndpointOption != null && enableEndpointOption.booleanValue()) {
            try {
                earFile = scheduler.getEarFile();
                EndpointEnabler endptEnabler = new EndpointEnabler();
                Properties props = new Properties();
                if (enableHttpRouterSecurityOption != null && enableHttpRouterSecurityOption.booleanValue()) {
                    props.setProperty("http.enableRouterSecurity", "true");
                }
                if (endpointEnablerPropsFile != null && !"".equals(endpointEnablerPropsFile)) {
                    props.setProperty("propsFileLocation", endpointEnablerPropsFile);
                }
                endptEnabler.enableEarFile(earFile, props);
                if (endptEnabler.isModified()) {
                    CopyWSDLFilesToRouterWAR copier = new CopyWSDLFilesToRouterWAR(earFile, this.getResourceBundle());
                    copier.copyFiles();
                    scheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0048I", null));
                    earFile.save();
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.WSDeployTask.performTask", "286", (Object)this);
                throw new AdminException(ex);
            }
        }
        if (wsSecEnabled) {
            ResourceBundle res = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
            String msg = null;
            if (res != null) {
                msg = res.getString("security.wssecurity.appinstall.warning");
            }
            if (msg == null) {
                msg = "WSEC0106W: Your application may have Web Services Security enabled. If it does, you must go to the Enterprise Application Management panels to configure the binding information for Web Services Security. The binding information for Web Services Security is not collected during application deployment. If it is not properly configured, your application may not start or be usable.";
            }
            scheduler.propagateTaskEvent(this.createTranslatedNotification("InProgress", msg, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private String getWASLibDir() {
        String dir = System.getProperty("was.install.root");
        if (dir == null) {
            dir = System.getProperty("user.install.root");
        }
        if (dir != null) {
            dir = dir + "/lib";
        }
        return dir;
    }

    private String getWebServicesJarPath() {
        String dir = System.getProperty("was.install.root");
        if (dir == null) {
            dir = System.getProperty("user.install.root");
        }
        if (dir != null) {
            dir = dir + "/plugins/com.ibm.ws.runtime.jar";
        }
        return dir;
    }

    private String getJ2eeJarPath(String J2EEJarPath) {
        String dir = System.getProperty("was.install.root");
        if (dir == null) {
            dir = System.getProperty("user.install.root");
        }
        if (dir != null) {
            dir = dir + J2EEJarPath;
        }
        return dir;
    }

    private void iterateError(Status status) {
        Status[] children = status.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Status child = children[i];
            if (child == null) continue;
            String msg = child.getMessage();
            Tr.error(tc, "WSWS0038E", msg);
            this.iterateError(child);
        }
    }

    private Throwable findThrowable(Status status) {
        Throwable throwable = status.getThrowable();
        if (throwable != null) {
            return throwable;
        }
        Status[] children = status.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Status child = children[i];
            if (child == null) continue;
            return this.findThrowable(child);
        }
        return null;
    }
}

