/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.combined.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.DefaultMapping;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.WscbndFactory;
import com.ibm.etools.webservice.wscbnd.WscbndPackage;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.ClientBindPreferredPort;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import com.ibm.ws.webservices.modutils.ClientBndUtil;
import com.ibm.ws.webservices.modutils.PreferredPortDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class ClientBindPreferredPortTaskHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(ClientBindPreferredPortTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private AppDeploymentTask task = null;
    private AppDeploymentInfo appDeploymentInfo = null;
    private String noneValue = "none";

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        return new ClientBindPreferredPort(appController);
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        String[][] newTaskData;
        this.appDeploymentInfo = appDeploymentInfo;
        this.task = task;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (task.getTaskData() != null) {
            return;
        }
        Vector<String> dataForTwoDimensionalArray = new Vector<String>();
        String[] columnNames = task.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            dataForTwoDimensionalArray.addElement(columnNames[i]);
        }
        Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
        Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
        Vector combined = new Vector();
        combined.addAll(ejbJars);
        combined.addAll(wars);
        boolean webServiceEnabled = false;
        boolean firstRowFilled = false;
        for (EObject refObject : combined) {
            String moduleURI = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
            WSDeploymentDescriptorAccessor ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task);
            if (ddAccessor.isModuleWebServiceEnabledClient()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask: module " + moduleURI + " is Web Service enabled");
                }
                webServiceEnabled = true;
                WSBindingsFileAccessor bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo);
                ClientBinding clientBinding = bindingAccessor.getClientBinding();
                if (clientBinding == null) continue;
                String ejbName = null;
                if (bindingAccessor.isWebType(null)) {
                    EList services = clientBinding.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    firstRowFilled = this.fillServicesRows(dataForTwoDimensionalArray, refObject, clientBinding, ejbName, services);
                    continue;
                }
                EList scopedComponents = clientBinding.getComponentScopedRefs();
                if (scopedComponents == null || scopedComponents.isEmpty()) continue;
                int sc_size = scopedComponents.size();
                for (int i = 0; i < sc_size; ++i) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)scopedComponents.get(i);
                    ejbName = csr.getComponentNameLink();
                    EList services = csr.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    firstRowFilled = this.fillServicesRows(dataForTwoDimensionalArray, refObject, clientBinding, ejbName, services);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "prepareTask: module " + moduleURI + " is NOT Web Service enabled");
        }
        if (webServiceEnabled) {
            if (!firstRowFilled) {
                for (int i = 0; i < columnNames.length; ++i) {
                    dataForTwoDimensionalArray.addElement("");
                }
            }
            newTaskData = util.buildTaskData(dataForTwoDimensionalArray, (int)columnNames.length);
            task.setTaskData(newTaskData);
        } else {
            newTaskData = null;
            task.setTaskData(newTaskData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private boolean fillServicesRows(Vector dataForTwoDimensionalArray, EObject moduleObject, ClientBinding clientBinding, String ejbName, EList services) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillServicesRows");
        }
        int size = services.size();
        boolean rowsFilled = false;
        String moduleURI = util.formUriString((AppDeploymentInfo)this.appDeploymentInfo, (EObject)moduleObject);
        String[] pieces = util.separateUriString((String)moduleURI);
        String moduleName = pieces[0];
        ModuleFile mfile = this.appDeploymentInfo.getModuleFileForDD(moduleObject);
        for (int i = 0; i < size; ++i) {
            ServiceRef sr = (ServiceRef)services.get(i);
            String serviceName = sr.getServiceRefLink();
            HashMap preferredPortMapping = this.generatePreferredPortMapping(mfile, clientBinding, serviceName, ejbName);
            if (preferredPortMapping.isEmpty()) {
                Object[] fillins = new Object[]{moduleName, serviceName};
                String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.task, (String)"WSWS0052E"), fillins);
                if (tc.isEntryEnabled()) {
                    Tr.error(tc, "WSWS0052E", fillins);
                }
            }
            EList defaultMappings = sr.getDefaultMappings();
            Iterator dmIterator = defaultMappings.iterator();
            for (String portTypeQString : preferredPortMapping.keySet()) {
                PreferredPortDescriptor ppd = (PreferredPortDescriptor)preferredPortMapping.get(portTypeQString);
                String portPreferredQString = ppd.getPortPreferred();
                if (portPreferredQString == null) {
                    portPreferredQString = "";
                }
                dataForTwoDimensionalArray.addElement(moduleName);
                if (ejbName == null) {
                    dataForTwoDimensionalArray.addElement("");
                } else {
                    dataForTwoDimensionalArray.addElement(ejbName);
                }
                dataForTwoDimensionalArray.addElement(serviceName);
                dataForTwoDimensionalArray.addElement(portTypeQString);
                dataForTwoDimensionalArray.addElement(portPreferredQString);
                rowsFilled = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillServicesRows");
        }
        return rowsFilled;
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        this.task = task;
        this.appDeploymentInfo = appDeploymentInfo;
        if (!task.isTaskEmpty() && !task.isTaskDisabled()) {
            Hashtable appOptions = appDeploymentInfo.getAppOptions();
            String[][] taskData = task.getTaskData();
            Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector combined = new Vector();
            combined.addAll(ejbJars);
            combined.addAll(wars);
            for (EObject refObject : combined) {
                WSDeploymentDescriptorAccessor ddAccessor;
                String moduleURI = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
                String[] pieces = util.separateUriString((String)moduleURI);
                String moduleName = pieces[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: working on module " + moduleURI);
                }
                if (!(ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabledClient()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: module " + moduleURI + " is Web Service enabled");
                }
                WSBindingsFileAccessor bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo);
                ClientBinding clientBinding = bindingAccessor.getClientBinding();
                ModuleFile mFile = appDeploymentInfo.getModuleFileForDD(refObject);
                if (clientBinding == null) continue;
                String ejbName = "";
                if (bindingAccessor.isWebType(null)) {
                    EList services = clientBinding.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.searchServicesAndSetPreferredPort(moduleName, mFile, clientBinding, ejbName, services, taskData);
                    continue;
                }
                EList scopedComponents = clientBinding.getComponentScopedRefs();
                if (scopedComponents == null || scopedComponents.isEmpty()) continue;
                int sc_size = scopedComponents.size();
                for (int i = 0; i < sc_size; ++i) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)scopedComponents.get(i);
                    ejbName = csr.getComponentNameLink();
                    EList services = csr.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.searchServicesAndSetPreferredPort(moduleName, mFile, clientBinding, ejbName, services, taskData);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void searchServicesAndSetPreferredPort(String moduleMatch, ModuleFile mFile, ClientBinding clientBinding, String ejbMatch, EList services, String[][] taskData) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchServicesAndSetPreferredPort for module " + moduleMatch);
        }
        int size = services.size();
        for (int i = 0; i < size; ++i) {
            ServiceRef sr = (ServiceRef)services.get(i);
            String serviceName = sr.getServiceRefLink();
            HashMap preferredPortMapping = new HashMap();
            for (int j = 1; j < taskData.length; ++j) {
                String[] taskRow = taskData[j];
                if (!moduleMatch.equals(taskRow[0]) || !ejbMatch.equals(taskRow[1]) || !serviceName.equals(taskRow[2])) continue;
                boolean rowFound = false;
                String portType = taskRow[3];
                String newPort = taskRow[4];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating QName, QName.valueOf(" + newPort + ");");
                }
                if (newPort == null || newPort.equals("")) continue;
                QName newPortQName = QName.valueOf(newPort);
                EList defaultMappings = sr.getDefaultMappings();
                Iterator dmIterator = defaultMappings.iterator();
                if (dmIterator != null) {
                    while (dmIterator.hasNext()) {
                        DefaultMapping dm = (DefaultMapping)dmIterator.next();
                        String typeLocal = dm.getPortTypeLocalName();
                        String typeSpace = dm.getPortTypeNamespace();
                        QName aPortTypeQName = new QName(typeSpace, typeLocal);
                        if (!aPortTypeQName.toString().equals(portType)) continue;
                        if (newPort.equals(" ")) {
                            defaultMappings.remove(dm);
                        } else {
                            if (preferredPortMapping.isEmpty()) {
                                preferredPortMapping = this.generatePreferredPortMapping(mFile, clientBinding, serviceName, ejbMatch);
                            }
                            if (ClientBindPreferredPortTaskHelper.validPreferredPort(preferredPortMapping, portType, newPort)) {
                                dm.setPortNamespace(newPortQName.getNamespaceURI());
                                dm.setPortLocalName(newPortQName.getLocalPart());
                            } else {
                                String ejbMsg = "";
                                if (!ejbMatch.equals("")) {
                                    ejbMsg = ", ejb " + ejbMatch;
                                }
                                Object[] fillins = new Object[]{newPort, portType, serviceName, moduleMatch, ejbMsg};
                                String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.task, (String)"WSWS0053E"), fillins);
                                if (tc.isEntryEnabled()) {
                                    Tr.error(tc, "WSWS0053E", fillins);
                                }
                                throw new AppDeploymentException(message, null);
                            }
                        }
                        rowFound = true;
                        break;
                    }
                }
                if (rowFound || newPort.equals(" ")) continue;
                String uri = "http://www.ibm.com/websphere/appserver/schemas/5.0.2/wscbnd.xmi";
                WscbndPackage pkg = (WscbndPackage)EPackage.Registry.INSTANCE.getEPackage(uri);
                WscbndFactory factory = pkg.getWscbndFactory();
                DefaultMapping dm = factory.createDefaultMapping();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating QName, QName.valueOf(" + portType + ");");
                }
                QName newPortTypeQName = QName.valueOf(portType);
                dm.setPortTypeNamespace(newPortTypeQName.getNamespaceURI());
                dm.setPortTypeLocalName(newPortTypeQName.getLocalPart());
                dm.setPortNamespace(newPortQName.getNamespaceURI());
                dm.setPortLocalName(newPortQName.getLocalPart());
                if (defaultMappings.isEmpty()) {
                    defaultMappings.add(dm);
                    continue;
                }
                defaultMappings.set(0, dm);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchServicesAndSetPreferredPort");
        }
    }

    private HashMap generatePreferredPortMapping(ModuleFile mFile, ClientBinding clientBinding, String serviceRefName, String ejbName) throws AppDeploymentException {
        ClientBndUtil clientBndUtil;
        HashMap preferredPortMappings = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generatePreferredPortMapping for " + serviceRefName);
        }
        if ((clientBndUtil = new ClientBndUtil(clientBinding)) != null) {
            preferredPortMappings = this.getPreferredPortMap(mFile, serviceRefName);
            clientBndUtil.setupPreferredPortMappings(preferredPortMappings, serviceRefName, ejbName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generatePreferredPortMapping");
        }
        return preferredPortMappings;
    }

    public HashMap getPreferredPortMap(ModuleFile mFile, String serviceRefName) {
        WSModuleDescriptor wsModDesc;
        Iterator refsIter;
        HashMap<String, PreferredPortDescriptor> preferredPortMappings = new HashMap<String, PreferredPortDescriptor>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferredPortMap for " + serviceRefName);
        }
        String serviceNorm = ClientBndUtil.normalizeServiceName((String)serviceRefName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking for JAX-RPC service refs in " + serviceNorm);
        }
        if ((refsIter = (wsModDesc = WSDescriptionBuilderFactory.getBuilder().getModuleDescriptor(mFile)).getServiceRefs()) != null) {
            while (refsIter.hasNext()) {
                Iterator endpointIter;
                WSClientServiceDescriptor wsClientSvc = (WSClientServiceDescriptor)refsIter.next();
                QName serviceQName = new QName(wsClientSvc.getQName().getNamespaceURI(), serviceNorm);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for service with QName " + serviceQName);
                }
                if (!WSClientType.JAX_RPC.equals((Object)wsClientSvc.getClientType()) || !serviceQName.equals(wsClientSvc.getQName())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found JAX-RPC client with service QName: " + serviceQName.toString());
                }
                if ((endpointIter = wsClientSvc.getEndpoints()) == null) continue;
                while (endpointIter.hasNext()) {
                    WSClientEndpointDescriptor wsClientEndpoint = (WSClientEndpointDescriptor)endpointIter.next();
                    QName pTQName = wsClientEndpoint.getPortTypeQName();
                    QName portQName = new QName(serviceQName.getNamespaceURI(), wsClientEndpoint.getName());
                    if (pTQName != null) {
                        String portTypeKey;
                        PreferredPortDescriptor ppd;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found PortType QName: " + pTQName + "    port QName " + portQName);
                        }
                        if ((ppd = (PreferredPortDescriptor)preferredPortMappings.get(portTypeKey = pTQName.toString())) == null) {
                            ppd = new PreferredPortDescriptor();
                            ppd.addSupportedPort(this.noneValue);
                        }
                        ppd.addSupportedPort(portQName.toString());
                        preferredPortMappings.put(portTypeKey, ppd);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "PreferredPortDescriptor.getEjbName() " + ppd.getEjbName());
                        Tr.debug(tc, "PreferredPortDescriptor.getPortPreferred() " + ppd.getPortPreferred());
                        Tr.debug(tc, "PreferredPortDescriptor.getSupportedPorts() " + ppd.getSupportedPorts().toString());
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found PortType QName is null, skipping endpoint. ");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreferredPortMap");
        }
        return preferredPortMappings;
    }

    static boolean validPreferredPort(HashMap preferredPortMap, String portType, String port) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validPreferredPort", new Object[]{portType, port});
        }
        boolean isValid = false;
        QName checkPortQName = QName.valueOf(port);
        if (checkPortQName.getNamespaceURI() == null || checkPortQName.getNamespaceURI().equals("")) {
            QName portTypeQName = QName.valueOf(portType);
            QName adjustedPortQName = new QName(portTypeQName.getNamespaceURI(), port);
            port = adjustedPortQName.toString();
        }
        PreferredPortDescriptor ppd = (PreferredPortDescriptor)preferredPortMap.get(portType);
        ArrayList ports = ppd.getSupportedPorts();
        isValid = ports.contains(port);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validPreferredPort", new Boolean(isValid));
        }
        return isValid;
    }

    public void setNoneValue(String val) {
        if (val != null) {
            this.noneValue = val;
        }
    }
}

