/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import com.ibm.wsspi.webservices.admin.ServicesAdminConstants;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class EndpointStatusUtils
implements ServicesAdminConstants,
ServiceIndexConstants {
    private static final TraceComponent _tc = Tr.register(EndpointStatusUtils.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.commands.EndpointStatusUtils";
    public static final String MBEAN_DOMAIN = "WebSphere:";
    private static final String MBEAN_CELL = "cell=";
    private static final String MBEAN_NODE = "node=";
    private static final String MBEAN_PROCESS = "process=";
    private static final String MBEAN_APPLICATION = "ApplicationName=";
    private static final String MBEAN_MODULE = "ModuleName=";
    private static final String MBEAN_ENDPOINT_MGR_TYPE = "type=EndpointManager";
    private static final byte LISTENER_STARTED = 8;
    private static final byte LISTENER_STOPPED = 4;
    private static final byte LISTENER_STOPPED_NOT_STARTABLE = 2;
    private static final byte LISTENER_NOT_APPLICABLE = 1;
    private static final byte LISTENER_UNKNOWN = 0;
    public static final String ERROR_NULL_PARAM = "The parameter is null";
    public static final String ERROR_NO_APP_NAME = "The application name is missing in the parameter";
    public static final String ERROR_NO_MODULE_NAME = "The module name is missing in the parameter";
    public static final String ERROR_NO_SERVICE_NAME = "The service name is missing in the parmeter";
    public static final String ERROR_NO_ENDPOINT_NAME = "The logicalEndpoint name is missing in the parmeter";
    public static final String ERROR_NO_NODE_NAME = "The node name is missing in the parmeter";
    public static final String ERROR_NO_SERVER_CLUSTER_NAME = "The server or cluster name is missing in the parmeter";
    public static final String[] VALID_PROPERTIES_FOR_SERVER_TARGET = new String[]{"cell", "node", "server"};
    public static final String[] VALID_PROPERTIES_FOR_CLUSTER_TARGET = new String[]{"cell", "cluster"};
    public static final String[] VALID_PROPERTIES_FOR_RESOURCE = new String[]{"application", "module", "service", "logicalEndpoint"};
    private static final String FFDC_ID_1 = "FFDC-1";
    private static AppManagement _appmgmt = null;
    private static ResourceBundle _resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());

    public static String getStatusInString(int status) {
        if (status == 3) {
            return "Stopped";
        }
        if (status == 2) {
            return "Started";
        }
        if (status == 0) {
            return "Partially started";
        }
        if (status == 1) {
            return "Partially started";
        }
        return "Unavailable";
    }

    public static String createEndpointManagerQueryString(String cellName, String nodeName, String serverName, String appName, String moduleName) {
        StringBuffer nameBuff = new StringBuffer(MBEAN_DOMAIN);
        nameBuff.append(MBEAN_ENDPOINT_MGR_TYPE);
        if (cellName != null) {
            nameBuff.append(",");
            nameBuff.append(MBEAN_CELL);
            nameBuff.append(cellName);
        }
        if (nodeName != null) {
            nameBuff.append(",");
            nameBuff.append(MBEAN_NODE);
            nameBuff.append(nodeName);
        }
        if (serverName != null) {
            nameBuff.append(",");
            nameBuff.append(MBEAN_PROCESS);
            nameBuff.append(serverName);
        }
        if (appName != null) {
            nameBuff.append(",");
            nameBuff.append(MBEAN_APPLICATION);
            nameBuff.append(appName);
        }
        if (moduleName != null) {
            nameBuff.append(",");
            nameBuff.append(MBEAN_MODULE);
            nameBuff.append(moduleName);
        }
        nameBuff.append(",*");
        return nameBuff.toString();
    }

    public static String getAggregatedStatus(List statusList, boolean wsfepTargetOnly) {
        int statusFlags = 0;
        String statusStr = null;
        String aggregatedStatus = null;
        boolean unknownFound = false;
        for (int i = 0; i < statusList.size(); ++i) {
            statusStr = (String)statusList.get(i);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "EndpointStatusUtils.getAggregatedStatus, index " + i + ": statusStr=" + statusStr);
            }
            if (statusStr.equals("Started")) {
                statusFlags = (byte)(statusFlags | 8);
                continue;
            }
            if (statusStr.equals("Partially started")) {
                statusFlags = (byte)(statusFlags | 0xC);
                continue;
            }
            if (statusStr.equals("Stopped") || statusStr.equals("Partially Stopped")) {
                statusFlags = (byte)(statusFlags | 4);
                continue;
            }
            if (statusStr.equals("Stopped and not startable")) {
                statusFlags = (byte)(statusFlags | 2);
                continue;
            }
            if (statusStr.equals("Not applicable")) {
                statusFlags = (byte)(statusFlags | 1);
                continue;
            }
            statusFlags = (byte)(statusFlags | 0);
            unknownFound = true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getAggregatedStatus, statusFlag=" + statusFlags);
        }
        aggregatedStatus = statusFlags == 8 && !unknownFound ? (wsfepTargetOnly ? "Asset started" : "Started") : (statusFlags > 8 || statusFlags == 8 && unknownFound ? (wsfepTargetOnly ? "Asset partially started" : "Partially started") : (statusFlags >= 4 ? (wsfepTargetOnly ? "Asset stopped" : "Stopped") : (statusFlags >= 2 ? (wsfepTargetOnly ? "Asset stopped" : "Stopped and not startable") : (statusFlags == 1 ? "Not applicable" : "Unavailable"))));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getAggregatedStatus returns " + aggregatedStatus);
        }
        return aggregatedStatus;
    }

    public static void verifyModuleExists(Properties queryProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "verifyModuleExists", new Object[]{"queryProps=" + queryProps});
        }
        if (_appmgmt == null) {
            _appmgmt = AppManagementProxy.getJMXProxyForServer();
        }
        Vector v = _appmgmt.getModuleInfo(queryProps.getProperty("application"), new Hashtable(), queryProps.getProperty("module"), null);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "verifyModuleExists");
        }
    }

    public static String appStatusToEndpointListenerStatus(String appStatus) {
        String endpointStatus = "Unavailable";
        if ("ExecutionState.STARTED".equals(appStatus)) {
            endpointStatus = "Started";
        } else if ("ExecutionState.STOPPED".equals(appStatus)) {
            endpointStatus = "Stopped and not startable";
        } else if ("ExecutionState.PARTIAL_START".equals(appStatus)) {
            endpointStatus = "Partially started";
        } else if ("ExecutionState.PARTIAL_STOP".equals(appStatus)) {
            endpointStatus = "Stopped and not startable";
        } else if ("ExecutionState.UNKNOWN".equals(appStatus)) {
            endpointStatus = "Unavailable";
        } else if ("ExecutionState.UNAVAILABLE".equals(appStatus)) {
            endpointStatus = "Unavailable";
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "appStatusToEndpointListenerStatus: appStatus is unreconized: " + appStatus);
            }
            endpointStatus = "Unavailable";
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "appStatusToEndpointListenerStatus, appStatus=" + appStatus + ", endpointStatus=" + endpointStatus);
        }
        return endpointStatus;
    }

    public static boolean isMatchedTarget(String requestedTarget, ObjectName targetOName) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "EndpointStatusUtils.isMatchedTarget", new Object[]{requestedTarget, targetOName});
        }
        if (requestedTarget == null || requestedTarget.equals("*")) {
            return true;
        }
        try {
            if (requestedTarget.indexOf(58) < 0) {
                requestedTarget = MBEAN_DOMAIN + requestedTarget;
            }
            ObjectName requestOName = new ObjectName(requestedTarget);
            String cell = requestOName.getKeyProperty("cell");
            String node = requestOName.getKeyProperty("node");
            String server = requestOName.getKeyProperty("server");
            String cluster = requestOName.getKeyProperty("cluster");
            String cell2 = targetOName.getKeyProperty("cell");
            String node2 = targetOName.getKeyProperty("node");
            String server2 = targetOName.getKeyProperty("server");
            String cluster2 = targetOName.getKeyProperty("cluster");
            if (cell != null && !cell.equals(cell2)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "isMatchedTarget, the target is not matched because cell name is not matched", new Object[]{cell, cell2});
                }
                return false;
            }
            if (server != null) {
                if (!server.equals(server2)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "isMatchedTarget, the target is not matched because server name is not matched", new Object[]{server, server2});
                    }
                    return false;
                }
                if (node == null || !node.equals(node2)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "isMatchedTarget, the target is not matched because node name is not matched", new Object[]{node, node2});
                    }
                    return false;
                }
            } else if (cluster != null) {
                if (!cluster.equals(cluster2)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "isMatchedTarget, the target is not matched because cluster name is not matched", new Object[]{cluster, cluster2});
                    }
                    return false;
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "isMatchedTarget, the target is not matched because the requested target is not in valid format", new Object[]{requestedTarget});
                }
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.webservices.admin.commands.EndpointStatusUtils.isMatchedTarget", FFDC_ID_1);
            if (_tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public static void validateParameters(Properties queryProps, String target, String operation) throws IllegalArgumentException, MalformedObjectNameException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "EndpointStatusUtils.validateParameters", new Object[]{queryProps, target, operation});
        }
        if (queryProps == null) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0023E", new Object[0], ERROR_NULL_PARAM));
        }
        String appName = queryProps.getProperty("application");
        String moduleName = queryProps.getProperty("module");
        String serviceName = queryProps.getProperty("service");
        String endpoint = queryProps.getProperty("logicalEndpoint");
        if (appName == null) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0024E", new Object[0], ERROR_NO_APP_NAME));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0025E", new Object[0], ERROR_NO_MODULE_NAME));
        }
        if (serviceName == null && !operation.equals("getServiceNames")) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0026E", new Object[0], ERROR_NO_SERVICE_NAME));
        }
        if (endpoint == null && operation.equals("getEndpointType")) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0022E", new Object[0], ERROR_NO_ENDPOINT_NAME));
        }
        String[] validTargetProps = new String[]{};
        ObjectName oName = null;
        if (target != null && !target.equals("*")) {
            if (!target.startsWith(MBEAN_DOMAIN)) {
                target = MBEAN_DOMAIN + target;
            }
            oName = new ObjectName(target);
            String node = oName.getKeyProperty("node");
            String server = oName.getKeyProperty("server");
            String cluster = oName.getKeyProperty("cluster");
            if (server != null && cluster != null) {
                throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0070E", new Object[0], "The target parameter contains both server name and cluster name."));
            }
            if (server == null && cluster == null) {
                throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0035E", new Object[0], ERROR_NO_SERVER_CLUSTER_NAME));
            }
            if (server != null) {
                if (node == null) {
                    throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0034E", new Object[0], ERROR_NO_NODE_NAME));
                }
                validTargetProps = VALID_PROPERTIES_FOR_SERVER_TARGET;
            } else {
                validTargetProps = VALID_PROPERTIES_FOR_CLUSTER_TARGET;
            }
        }
        ArrayList<String> parameterPropList = new ArrayList<String>();
        StringBuffer invalidProps = new StringBuffer();
        Enumeration<Object> e = queryProps.propertyNames();
        while (e.hasMoreElements()) {
            parameterPropList.add((String)e.nextElement());
        }
        if (oName != null) {
            e = oName.getKeyPropertyList().keys();
            while (e.hasMoreElements()) {
                parameterPropList.add((String)e.nextElement());
            }
        }
        boolean found = false;
        String name = null;
        for (int i = 0; i < parameterPropList.size(); ++i) {
            name = (String)parameterPropList.get(i);
            found = false;
            for (int j = 0; j < VALID_PROPERTIES_FOR_RESOURCE.length; ++j) {
                if (!VALID_PROPERTIES_FOR_RESOURCE[j].equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            for (int k = 0; k < validTargetProps.length; ++k) {
                if (!validTargetProps[k].equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            invalidProps.append(name).append(" ");
        }
        if (invalidProps.length() > 0) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0019E", new Object[]{invalidProps.toString()}, "Invalid property names: " + invalidProps.toString()));
        }
    }
}

