/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUpdate;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.webservices.admin.deploy.DeploymentValidation;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexReader;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import com.ibm.ws.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;

public class CommonUtils {
    private static WSDescriptionBuilder builder = WSDescriptionBuilderFactory.getBuilder();
    private static TraceComponent tc = Tr.register(CommonUtils.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.commands.CommonUtils";

    public static String getFormattedMessage(ResourceBundle bundle, String key, Object[] args, String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonUtils.getFormattedMessage()", new Object[]{key, msg});
        }
        String formattedMsg = null;
        try {
            String result = bundle.getString(key);
            formattedMsg = result == null ? msg : MessageFormat.format(result, args);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.admin.commands.CommonUtils.getFormattedMessage", FFDC_ID_1);
            formattedMsg = msg;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonUtils.getFormattedMessage()", new Object[]{formattedMsg});
        }
        return formattedMsg;
    }

    public static boolean hasJAXWSWebServices(ModuleFile mf) {
        return CommonUtils.hasJAXWSWebServices(mf, false);
    }

    public static boolean hasJAXWSWebServices(ModuleFile mf, boolean onlyCheckServices) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonUtils.hasJAXWSWebServices(ModuleFile)", new Object[]{mf.getName()});
        }
        boolean result = CommonUtils.hasWebServices(WSClientType.JAX_WS, mf, onlyCheckServices);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonUtils.hasJAXWSWebServices(ModuleFile)", new Object[]{result, mf.getName()});
        }
        return result;
    }

    private static boolean hasJAXWSWebServices(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonUtils.hasJAXWSWebServices(Map)");
        }
        boolean result = false;
        for (String key : map.keySet()) {
            WebServiceBean wsBean = (WebServiceBean)map.get(key);
            if (!"JAX-WS".equals(wsBean.getType())) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonUtils.hasJAXWSWebServices(Map)", new Object[]{result});
        }
        return result;
    }

    public static boolean hasJAXWSWebServices(ModuleFile mf, Scheduler scheduler) {
        boolean result;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CommonUtils.hasJAXWSWebServices(ModuleFile, scheduler)", new Object[]{mf.getName()});
            }
            result = false;
            if (scheduler instanceof EditSchedulerImpl) {
                String filename = "WEB-INF/servicesIndex.xml";
                try {
                    File file;
                    InputStream is;
                    boolean servicesIndexFileExists = mf.getLoadStrategy().getContainer().containsFile(filename);
                    if (servicesIndexFileExists && (is = (file = mf.getFile(filename)).getInputStream()) != null) {
                        ServiceIndexReader reader = new ServiceIndexReader(is);
                        Map[] maps = reader.read(true);
                        is.close();
                        HashMap serviceMap = new HashMap();
                        HashMap clientServiceMap = new HashMap();
                        if (maps != null && maps[0] != null) {
                            serviceMap.putAll(maps[0]);
                        }
                        if (maps != null && maps[1] != null) {
                            clientServiceMap.putAll(maps[1]);
                        }
                        result = CommonUtils.hasJAXWSWebServices(serviceMap) || CommonUtils.hasJAXWSWebServices(clientServiceMap);
                    }
                    break block9;
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Receiving exception in hasJAXWSWebServices(ModuleFile), " + ex);
                    }
                    break block9;
                }
            }
            result = CommonUtils.hasWebServices(WSClientType.JAX_WS, mf, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonUtils.hasJAXWSWebServices(ModuleFile, scheduler)", new Object[]{result, mf.getName()});
        }
        return result;
    }

    public static boolean hasJAXRPCWebServices(ModuleFile mf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonUtils.hasJAXRPCWebServices(ModuleFile)", new Object[]{mf.getName()});
        }
        boolean result = false;
        result = CommonUtils.hasWebServices(WSClientType.JAX_RPC, mf, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonUtils.hasJAXRPCWebServices(ModuleFile)", new Object[]{result, mf.getName()});
        }
        return result;
    }

    public static boolean hasJAXRPCWebServices(ModuleFile mf, Scheduler scheduler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonUtils.hasJAXRPCWebServices(ModuleFile, Scheduler)", new Object[]{mf.getName()});
        }
        boolean result = false;
        result = CommonUtils.hasWebServices(WSClientType.JAX_RPC, mf, false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, mf.getName() + " contains JAX-RPC web services? " + result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonUtils.hasJAXRPCWebServices(ModuleFile, Scheduler)", new Object[]{result, mf.getName()});
        }
        return result;
    }

    private static boolean hasWebServices(WSClientType moduleType, ModuleFile mf) {
        return CommonUtils.hasWebServices(moduleType, mf, false);
    }

    private static boolean hasWebServices(WSClientType moduleType, ModuleFile mf, boolean checkServicesOnly) {
        boolean containsWSClient;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonUtils.hasWebServices(WSClientType, ModuleFile)", new Object[]{mf.getName(), moduleType});
        }
        boolean result = false;
        WSModuleDescriptor moduleDesc = builder.getModuleDescriptor(mf);
        if (moduleType.equals((Object)WSClientType.JAX_WS)) {
            result = moduleDesc.containsJAXWSWebServices();
        } else if (moduleType.equals((Object)WSClientType.JAX_RPC)) {
            result = moduleDesc.containsJAXRPCWebServices();
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CommonUtils.hasWebServices(WSClientType, ModuleFile) - wrong service type", new Object[]{result, mf.getName(), moduleType});
            }
            return false;
        }
        if (!result && !checkServicesOnly && (containsWSClient = moduleDesc.containsWebServiceClients())) {
            Iterator itor = moduleDesc.getServiceRefs();
            while (itor.hasNext() && !result) {
                WSClientServiceDescriptor clientDesc = (WSClientServiceDescriptor)itor.next();
                WSClientType type = clientDesc.getClientType();
                if (!type.equals((Object)moduleType)) continue;
                result = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonUtils.hasWebServices(WSClientType, ModuleFile)", new Object[]{result, mf.getName(), moduleType});
        }
        return result;
    }

    public static EARFile getEar(Scheduler scheduler, ResourceBundle rb) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTask.getEar()");
        }
        EARFile ear = null;
        if (scheduler instanceof InstallScheduler) {
            ear = ((InstallScheduler)scheduler).getEarFile(false, true);
            EList mRefs = ear.getModuleRefs();
            boolean rar = false;
            for (int i = 0; i < mRefs.size(); ++i) {
                ModuleRef mref = (ModuleRef)mRefs.get(i);
                if (!mref.isConnector()) continue;
                rar = true;
                break;
            }
            if (rar) {
                ear = ((InstallScheduler)scheduler).getEarFile(true, true);
                mRefs = ear.getModuleRefs();
            }
        } else if (scheduler instanceof UpdateScheduler) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
            ApplicationDeployment appdelp = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc);
            if (!appdelp.isZeroBinaryCopy() && !appdelp.isZeroEarCopy()) {
                ear = ConfigRepoHelper.getEarFileFromBinaries((RepositoryContext)rc, (WorkSpace)scheduler.getWorkSpace(), (ResourceBundle)rb, (boolean)true);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "zero bin copy so get ear from source");
                }
                ear = ConfigRepoHelper.getEarFileForApp((WorkSpace)scheduler.getWorkSpace(), (RepositoryContext)rc, (ResourceBundle)rb, (boolean)true);
            }
        } else if (scheduler instanceof EditSchedulerImpl) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
            ear = ConfigRepoHelper.getEarFileFromDeployment((WorkSpace)scheduler.getWorkSpace(), (RepositoryContext)rc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexServerTask.getEar()");
        }
        return ear;
    }

    public static EARFile getMergeEar(UpdateScheduler upsch, EARFile ear, RepositoryContext rc, ResourceBundle rb, String[] _tempDirToBeRemoved, String[] _updateDirToBeRemoved, String taskName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonUtils.getMergeEar", new Object[]{taskName});
        }
        Session session = new Session(upsch.getWorkSpace().getUserName(), true);
        String mergeRoot = AppUtils.getAppTempMergeDir((Scheduler)upsch);
        String tempDir = AppUtils.getAppTempExtractDir((Scheduler)upsch);
        String appName = upsch.getAppName();
        String updateDir = "temp" + java.io.File.separatorChar + taskName + java.io.File.separatorChar + appName + "_" + session;
        String wstemp = "wstemp";
        int indx = mergeRoot.indexOf(wstemp);
        String subString = mergeRoot.substring(0, indx + 7);
        String tempDirToBeRemoved = subString + "temp" + java.io.File.separatorChar + taskName + java.io.File.separatorChar + "exp" + java.io.File.separatorChar + appName + "_" + session;
        String updateDirToBeRemoved = subString + "temp" + java.io.File.separatorChar + taskName + java.io.File.separatorChar + appName + "_" + session;
        String newMergeRoot = subString + updateDir;
        java.io.File newDir = new java.io.File(newMergeRoot);
        newDir.mkdirs();
        if (taskName.equals(DeploymentValidation.taskName)) {
            tempDir = subString + "temp" + java.io.File.separatorChar + taskName + java.io.File.separatorChar + "exp" + java.io.File.separatorChar + appName + "_" + session;
            if (upsch.getContentType().equals("partialapp")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expanding partial ear to: " + tempDir);
                }
                CommonUtils.extractZip(upsch.getContentPath(), tempDir);
            } else if (upsch.getContentType().equals("file") && !upsch.getOperation().equals("delete")) {
                String contentURI = upsch.getContentURI();
                String nContentURI = contentURI.replace("/", java.io.File.separator);
                AppUtils.copyFile((java.io.File)new java.io.File(upsch.getContentPath()), (String)(tempDir + java.io.File.separator + nContentURI));
            }
        }
        ear.extractTo(newMergeRoot, 0);
        CommonUtils.closeEar(ear, (Scheduler)upsch);
        ArrayList deleted = new ArrayList();
        upsch.getProperties().put("DeltaDataTask.DelFiles", deleted);
        ArrayList added = new ArrayList();
        upsch.getProperties().put("DeltaDataTask.AddFiles", added);
        ArrayList updated = new ArrayList();
        upsch.getProperties().put("DeltaDataTask.UpdateFiles", updated);
        AppUpdateHelper aHelper = new AppUpdateHelper(rc, tempDir, upsch.getOperation(), upsch.getContentType(), upsch.getContentURI());
        aHelper.setLists(deleted, added, updated);
        aHelper.mergeFiles(upsch.getContentType().equals("partialapp") ? "addupdate" : upsch.getOperation(), tempDir, newMergeRoot);
        ear = AppInstallHelper.getEarFile((String)newMergeRoot, (boolean)true, (boolean)true, (ResourceBundle)rb);
        if (taskName.equals(DeploymentValidation.taskName)) {
            _tempDirToBeRemoved[0] = tempDirToBeRemoved;
        }
        _updateDirToBeRemoved[0] = updateDirToBeRemoved;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonUtils.getMergeEar", new Object[]{taskName, tempDirToBeRemoved, updateDirToBeRemoved});
        }
        return ear;
    }

    public static void closeEar(EARFile ear, Scheduler scheduler) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTask.closeEar()");
        }
        if (scheduler instanceof UpdateScheduler) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc).isZeroBinaryCopy() && !ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc).isZeroEarCopy()) {
                ear.close();
            }
        } else if (scheduler instanceof EditSchedulerImpl) {
            ear.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexServerTask.closeEar()");
        }
    }

    public static String getExceptionStack(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Vector extractZip(String zipName, String dirName) throws IOException {
        FileInputStream fIn = new FileInputStream(zipName);
        Vector v = CommonUtils.extractZip(fIn, dirName);
        fIn.close();
        return v;
    }

    private static Vector extractZip(InputStream istream, String dstDir) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractZip");
        }
        FileOutputStream outStream = null;
        ZipInputStream zipStream = new ZipInputStream(istream);
        java.io.File memberFile = null;
        java.io.File memberParentDir = null;
        Vector<String> memberPathList = new Vector<String>();
        byte[] ba = null;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                String memberURI = zipEntry.getName();
                String memberFilePath = (dstDir + java.io.File.separator + memberURI).replace('/', java.io.File.separatorChar);
                memberFile = new java.io.File(memberFilePath);
                memberParentDir = new java.io.File(memberFile.getParent());
                if (!memberParentDir.exists()) {
                    memberParentDir.mkdirs();
                }
                if (zipEntry.isDirectory()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extracted: " + memberURI);
                }
                memberPathList.addElement(memberURI);
                outStream = new FileOutputStream(memberFile);
                BufferedInputStream inStream = new BufferedInputStream(zipStream);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                int bytesRead = inStream.read();
                while (bytesRead != -1) {
                    outStream.write(bytesRead);
                    byteStream.write(bytesRead);
                    bytesRead = inStream.read();
                }
                if (outStream != null) {
                    outStream.close();
                }
                if (byteStream == null) continue;
                ba = byteStream.toByteArray();
                byteStream.close();
            }
        }
        catch (IOException e) {
            if (zipStream != null) {
                zipStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractZip");
        }
        return memberPathList;
    }

    private static class AppUpdateHelper
    extends AppUpdate {
        private RepositoryContext _rc;
        private String _tempDir = null;
        private String _operation = null;
        private String _contentType = null;
        private String _contentURI = null;
        List _modURIs;

        public AppUpdateHelper(RepositoryContext ctx, String dir, String oper, String type, String cUri) throws Exception {
            this._rc = ctx;
            this._tempDir = dir;
            this._operation = oper;
            this._contentType = type;
            this._contentURI = cUri;
            this._modURIs = new ArrayList();
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)this._rc);
            EList l = appDepl.getModules();
            for (int i = 0; i < l.size(); ++i) {
                this._modURIs.add(((ModuleDeployment)l.get(i)).getUri());
            }
        }

        public List getURIs() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getURIs");
            }
            List l = AppUtils.getURIs((String)this._tempDir);
            if ("delete".equals(this._operation) && "file".equals(this._contentType)) {
                l.add(this._contentURI);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getURIs");
            }
            return l;
        }

        public List getURIsNoDelete() {
            if ("delete".equals(this._operation) && "file".equals(this._contentType)) {
                return new ArrayList();
            }
            List l = this.getURIs();
            ArrayList remove = new ArrayList();
            for (int i = 0; i < l.size(); ++i) {
                if (!((String)l.get(i)).endsWith("META-INF/ibm-partialapp-delete.props")) continue;
                remove.add(l.get(i));
            }
            l.removeAll(remove);
            return l;
        }

        public InputStream getContentAsInputStream(String uri) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getContentAsInputStream: " + uri);
            }
            FileInputStream fIn = null;
            try {
                java.io.File s = new java.io.File(this._tempDir + "/" + uri);
                fIn = new FileInputStream(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getContentAsInputStream");
            }
            return fIn;
        }

        protected boolean addToCollapse(String archiveURI) throws Exception {
            return !this._modURIs.contains(archiveURI);
        }
    }
}

