/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexWorkSpaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ApplicationWorkSpaceHelper
implements ServiceIndexWorkSpaceHelper,
ServiceIndexConstants {
    public static final String METADATA_TYPE = "deployments";
    public static final String MODULE_METADATA_DIR = "META-INF";
    public static final String SYSTEM_APP_FILE = "ibm-application-sa2.props";
    private static TraceComponent tc = Tr.register(ApplicationWorkSpaceHelper.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public List listServiceIndexFiles(Session session, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFiles", new Object[]{props});
        }
        WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        String appName = null;
        String moduleName = null;
        Boolean systemApp = Boolean.FALSE;
        if (props != null) {
            appName = props.getProperty("application");
            moduleName = props.getProperty("module");
            systemApp = new Boolean(props.getProperty("systemApp"));
        }
        List retList = null;
        retList = appName == null || appName.equals("*") ? this.listServiceIndexFilesInCell(workspace, moduleName, systemApp) : (moduleName == null ? this.listServiceIndexFilesInApp(this.getAppRepositoryContext(workspace, appName), appName) : this.listServiceIndexFilesInModule(this.getAppRepositoryContext(workspace, appName), appName, moduleName));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFiles");
        }
        return retList;
    }

    public List listServiceIndexFiles(Session session, String appName, String moduleName) throws Exception {
        Properties p = new Properties();
        if (appName != null) {
            p.setProperty("application", appName);
        }
        if (moduleName != null) {
            p.setProperty("module", moduleName);
        }
        return this.listServiceIndexFiles(session, p);
    }

    private RepositoryContext getAppRepositoryContext(WorkSpace workspace, String appName) throws WorkSpaceException {
        Collection col = workspace.getRootContext().findContext(METADATA_TYPE, appName);
        Iterator contextIt = col.iterator();
        if (contextIt.hasNext()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAppRepositoryContext, get deployment RepositoryContext for app " + appName);
            }
            return (RepositoryContext)contextIt.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAppRepositoryContext, cannot get deployment RepositoryContext for app " + appName);
        }
        return null;
    }

    private List listServiceIndexFilesInCell(WorkSpace workspace, String specifiedModuleName, boolean sysApp) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFilesInCell");
        }
        RepositoryMetaData metaData = workspace.getMetaData();
        RepositoryContextType contextType = metaData.getContextType(METADATA_TYPE);
        Collection col = workspace.findContext(contextType);
        Iterator contextIt = col.iterator();
        RepositoryContext repContext = null;
        List retList = new ArrayList();
        List oneList = null;
        Properties p = null;
        while (contextIt.hasNext()) {
            repContext = (RepositoryContext)contextIt.next();
            String appName = this.getApplicationName(repContext);
            if (sysApp && !this.isSystemApp(repContext) || !sysApp && this.isSystemApp(repContext)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "listServiceIndexFilesInCell, skip application=" + appName + ", systemApp=" + sysApp);
                continue;
            }
            if (specifiedModuleName == null) {
                oneList = this.listServiceIndexFilesInApp(repContext, appName);
            } else {
                oneList = this.listServiceIndexFilesInModule(repContext, appName, specifiedModuleName);
                if (oneList.isEmpty()) {
                    p = new Properties();
                    p.setProperty("module", specifiedModuleName);
                    oneList.add(p);
                }
            }
            if (sysApp) {
                for (int i = 0; i < oneList.size(); ++i) {
                    p = (Properties)oneList.get(i);
                    p.setProperty("systemApp", "true");
                }
            }
            retList.addAll(oneList);
        }
        if (specifiedModuleName != null) {
            retList = ApplicationWorkSpaceHelper.processResult(retList, specifiedModuleName, "module");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexInCell");
        }
        return retList;
    }

    private List listServiceIndexFilesInApp(RepositoryContext repContext, String appName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFilesInApp", new Object[]{repContext, appName});
        }
        ArrayList<Properties> retList = new ArrayList<Properties>(1);
        if (repContext == null) {
            Properties p = new Properties();
            p.setProperty("application", "PackageNotExist");
            retList.add(p);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listServiceIndexFilesInApp - app not found");
            }
            return retList;
        }
        Iterator it = repContext.getFiles().iterator();
        String fileName = null;
        while (it.hasNext()) {
            fileName = (String)it.next();
            if (!fileName.endsWith("servicesIndex.xml")) continue;
            if (!repContext.isExtracted(fileName)) {
                repContext.extract(fileName, false);
            }
            StringBuffer strBuf = new StringBuffer(repContext.getPath());
            strBuf.append(File.separatorChar).append(fileName);
            Properties p = new Properties();
            p.setProperty("application", appName);
            p.setProperty("module", this.getModuleName(fileName));
            p.setProperty("file", strBuf.toString());
            retList.add(p);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "listServiceIndexFilesInApp : find file=" + strBuf.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFilesInApp");
        }
        return retList;
    }

    private List listServiceIndexFilesInModule(RepositoryContext repContext, String appName, String moduleName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFilesInModule", new Object[]{repContext, appName, moduleName});
        }
        ArrayList<Properties> retList = new ArrayList<Properties>(1);
        if (repContext == null) {
            Properties p = new Properties();
            p.setProperty("application", "PackageNotExist");
            retList.add(p);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listServiceIndexFilesInModule - app not found");
            }
            return retList;
        }
        Iterator it = repContext.getFiles().iterator();
        String fileName = null;
        boolean moduleFound = false;
        String moduleDir = moduleName + '/';
        while (it.hasNext()) {
            fileName = (String)it.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listServiceIndexFilesInModule, fileName is " + fileName);
            }
            if (!fileName.startsWith(moduleDir)) continue;
            moduleFound = true;
            if (!fileName.endsWith("servicesIndex.xml")) continue;
            if (!repContext.isExtracted(fileName)) {
                repContext.extract(fileName, false);
            }
            StringBuffer strBuf = new StringBuffer(repContext.getPath());
            strBuf.append(File.separatorChar).append(fileName);
            Properties p = new Properties();
            p.setProperty("application", appName);
            p.setProperty("module", moduleName);
            p.setProperty("file", strBuf.toString());
            retList.add(p);
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "listServiceIndexFilesInModule, find the services index file " + strBuf.toString());
            break;
        }
        if (!moduleFound) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listServiceIndexFilesInModule, cannot found module: application=" + appName + "module=" + moduleName);
            }
            Properties p = new Properties();
            p.setProperty("application", appName);
            p.setProperty("module", "PackageNotExist");
            retList.add(p);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listServiceIndexFilesInModule, find module: application=" + appName + "module=" + moduleName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFilesInModule");
        }
        return retList;
    }

    private String getApplicationName(RepositoryContext repContext) {
        String path = repContext.getPath();
        int index = path.lastIndexOf(File.separatorChar);
        if (index < 0) {
            index = path.lastIndexOf(47);
        }
        String appName = path.substring(index + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getApplicationName, path is " + path + ", appName=" + appName);
        }
        return appName;
    }

    private String getModuleName(String fileName) {
        int index = fileName.indexOf(File.separatorChar);
        if (index < 0) {
            index = fileName.indexOf(47);
        }
        String moduleName = fileName.substring(0, index);
        return moduleName;
    }

    protected static List processResult(List rawList, String specifiedName, String propName) {
        if (specifiedName == null) {
            return rawList;
        }
        ArrayList<Properties> retList = new ArrayList<Properties>();
        Properties p = null;
        boolean found = false;
        for (int i = 0; i < rawList.size(); ++i) {
            p = (Properties)rawList.get(i);
            if (!specifiedName.equals(p.getProperty(propName))) continue;
            found = true;
            if (p.getProperty("file") == null) continue;
            retList.add(p);
        }
        if (!found) {
            p = new Properties();
            p.setProperty(propName, "PackageNotExist");
            retList.add(p);
        }
        return retList;
    }

    private boolean isSystemApp(RepositoryContext repContext) {
        Iterator it = repContext.getFiles().iterator();
        String fileName = null;
        while (it.hasNext()) {
            fileName = (String)it.next();
            if (!fileName.endsWith(SYSTEM_APP_FILE)) continue;
            return true;
        }
        return false;
    }
}

