/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.wsspi.webservices.admin.ServicesAdminConstants;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppMgmtUtils
implements ServicesAdminConstants,
ServiceIndexConstants {
    public static final String WSMG_BUNDLE_NAME = "com.ibm.ws.webservices.admin.resources.websvcsAdmin";
    public static final String TRACE_GROUP = "webservices.admin";
    private static final TraceComponent _tc = Tr.register(AppMgmtUtils.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.commands.AppMgmtUtils";
    private static AppManagement _appmgmtLocal = null;
    private static AppManagement _appmgmtServer = null;
    private static ConfigService _cs = null;
    private static ResourceBundle _resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";

    public static List<ObjectName> getModuleTargetsLocalMode(Properties queryProps) throws Exception {
        return AppMgmtUtils.getModuleTargetsLocalMode(queryProps, null);
    }

    public static List<ObjectName> getModuleTargetsLocalMode(Properties queryProps, Session session) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleTargetsLocalMode", new Object[]{"queryProps=" + queryProps});
        }
        if (_appmgmtLocal == null) {
            _appmgmtLocal = AppManagementProxy.getLocalProxy();
        }
        return AppMgmtUtils.getModuleTargets(_appmgmtLocal, queryProps, session);
    }

    public static List<ObjectName> getModuleTargetsServerMode(Properties queryProps) throws Exception {
        return AppMgmtUtils.getModuleTargetsServerMode(queryProps, null);
    }

    public static List<ObjectName> getModuleTargetsServerMode(Properties queryProps, Session session) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleTargetsServerMode", new Object[]{"queryProps=" + queryProps});
        }
        if (_appmgmtServer == null) {
            _appmgmtServer = AppManagementProxy.getJMXProxyForServer();
        }
        return AppMgmtUtils.getModuleTargets(_appmgmtServer, queryProps, session);
    }

    public static String getModuleTargetVersion(ObjectName target) throws Exception {
        String node = target.getKeyProperty("node");
        ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
        SortedMap productMap = helper.getNodeProductVersions(node);
        String baseVersion = helper.getNodeBaseProductVersion(node);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getModuleTargetVersion node=" + node + ", baseVersion=" + baseVersion);
        }
        return baseVersion;
    }

    private static List<ObjectName> getAllModulesTargets(AppManagement appmgmt, Properties queryProps, Session session) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAllModulesTargets", new Object[]{"queryProps=" + queryProps + ", session=" + session.toString()});
        }
        String sessionID = session.getSessionId();
        String userID = session.getUserName();
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(userID);
        String workSpaceID = workSpace.getUserName();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "sessionID=" + sessionID + ", userID=" + userID + ", workSpaceID=" + workSpaceID);
        }
        AppDeploymentTask deplTask = (AppDeploymentTask)appmgmt.listModules(queryProps.getProperty("application"), new Hashtable(), workSpaceID);
        boolean trDebug = _tc.isDebugEnabled();
        if (trDebug) {
            Tr.debug(_tc, "getModuleTargets, _appmgmt.listModules returns");
        }
        String[][] moduleTargets = deplTask.getTaskData();
        int uriColumn = -1;
        int serverColumn = -1;
        for (int k = 0; k < moduleTargets[0].length; ++k) {
            if (trDebug) {
                Tr.debug(_tc, "getModuleTargets, column " + k + ": " + moduleTargets[0][k]);
            }
            if (moduleTargets[0][k].equals("uri")) {
                uriColumn = k;
                continue;
            }
            if (!moduleTargets[0][k].equals("server")) continue;
            serverColumn = k;
        }
        ArrayList<ObjectName> retList = new ArrayList<ObjectName>();
        String oneTarget = null;
        for (int i = 1; i < moduleTargets.length; ++i) {
            if (trDebug) {
                Tr.debug(_tc, "getModuleTargets, row " + i + ": uri " + moduleTargets[i][uriColumn] + ", server " + moduleTargets[i][serverColumn]);
            }
            StringTokenizer tokens = new StringTokenizer(moduleTargets[i][serverColumn], "+");
            while (tokens.hasMoreTokens()) {
                oneTarget = tokens.nextToken();
                if (trDebug) {
                    Tr.debug(_tc, "getModuleTargets, add target " + oneTarget + " for module " + moduleTargets[i][uriColumn]);
                }
                if (oneTarget.indexOf("cluster=") < 0) {
                    retList.add(new ObjectName(oneTarget));
                    continue;
                }
                retList.addAll(AppMgmtUtils.getClusterMembers(oneTarget, session));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAllModulesTargets", new Object[]{"number of targets found:" + retList.size()});
        }
        return retList;
    }

    private static List<ObjectName> getModuleTargets(AppManagement appmgmt, Properties queryProps, Session session) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleTargets", new Object[]{"queryProps=" + queryProps});
        }
        AppDeploymentTask deplTask = (AppDeploymentTask)appmgmt.listModules(queryProps.getProperty("application"), new Hashtable(), null);
        boolean trDebug = _tc.isDebugEnabled();
        if (trDebug) {
            Tr.debug(_tc, "getModuleTargets, _appmgmt.listModules returns");
        }
        String[][] moduleTargets = deplTask.getTaskData();
        int uriColumn = -1;
        int serverColumn = -1;
        boolean moduleFound = false;
        for (int k = 0; k < moduleTargets[0].length; ++k) {
            if (trDebug) {
                Tr.debug(_tc, "getModuleTargets, column " + k + ": " + moduleTargets[0][k]);
            }
            if (moduleTargets[0][k].equals("uri")) {
                uriColumn = k;
                continue;
            }
            if (!moduleTargets[0][k].equals("server")) continue;
            serverColumn = k;
        }
        ArrayList<ObjectName> retList = new ArrayList<ObjectName>();
        String oneTarget = null;
        String moduleName = queryProps.getProperty("module");
        for (int i = 1; i < moduleTargets.length; ++i) {
            if (trDebug) {
                Tr.debug(_tc, "getModuleTargets, row " + i + ": uri " + moduleTargets[i][uriColumn] + ", server " + moduleTargets[i][serverColumn]);
            }
            if (!moduleTargets[i][uriColumn].startsWith(moduleName)) continue;
            moduleFound = true;
            StringTokenizer tokens = new StringTokenizer(moduleTargets[i][serverColumn], "+");
            while (tokens.hasMoreTokens()) {
                oneTarget = tokens.nextToken();
                if (trDebug) {
                    Tr.debug(_tc, "getModuleTargets, add target " + oneTarget);
                }
                if (oneTarget.indexOf("cluster=") < 0) {
                    retList.add(new ObjectName(oneTarget));
                    continue;
                }
                retList.addAll(AppMgmtUtils.getClusterMembers(oneTarget, session));
            }
            break;
        }
        if (!moduleFound) {
            throw new IllegalArgumentException(AppMgmtUtils.getFormattedMessage(_resourceBundle, "CWSAD0038E", new Object[]{moduleName}, "Cannot find the module: " + moduleName));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getModuleTargets", new Object[]{"number of targets found:" + retList.size()});
        }
        return retList;
    }

    public static List<ObjectName> getClusterMembers(String clusterTarget) throws Exception {
        return AppMgmtUtils.getClusterMembers(clusterTarget, null);
    }

    public static List<ObjectName> getClusterMembers(String clusterTarget, Session session) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getClusterMembers", new Object[]{"clusterTarget=" + clusterTarget});
        }
        if (_cs == null) {
            _cs = ConfigServiceFactory.getConfigService();
        }
        ArrayList<ObjectName> retList = new ArrayList<ObjectName>();
        ObjectName clusterON = new ObjectName(clusterTarget);
        String clusterName = clusterON.getKeyProperty("cluster");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getClusterMembers: clusterName=" + clusterName);
        }
        boolean createNewSession = false;
        if (session == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getClusterMembers: create new session.");
            }
            session = new Session();
            createNewSession = true;
        }
        ObjectName typeON = ConfigServiceHelper.createObjectName(null, "ServerCluster", null);
        ObjectName[] clusterList = _cs.queryConfigObjects(session, null, typeON, null);
        String thisCluster = null;
        List members = null;
        for (int i = 0; i < clusterList.length; ++i) {
            thisCluster = ConfigServiceHelper.getDisplayName(clusterList[i]);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getClusterMembers: find cluster=" + thisCluster);
            }
            if (!clusterName.equals(thisCluster)) continue;
            members = (List)_cs.getAttribute(session, clusterList[i], "members");
            for (int k = 0; k < members.size(); ++k) {
                retList.add(AppMgmtUtils.getTargetFromClusterMemberAttributes((AttributeList)members.get(k), clusterON, clusterName));
            }
        }
        if (createNewSession) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getClusterMembers: discard session.");
            }
            _cs.discard(session);
        }
        return retList;
    }

    private static ObjectName getTargetFromClusterMemberAttributes(AttributeList attrList, ObjectName clusterON, String clusterName) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTargetFromClusterMemberAttributes", new Object[]{"attrList=" + attrList.toString(), "clusterON=" + clusterON, "clusterName=" + clusterName});
        }
        StringBuffer buf = new StringBuffer();
        buf.append("WebSphere:cell=").append(clusterON.getKeyProperty("cell"));
        buf.append(",cluster=").append(clusterName);
        Attribute attr = null;
        for (int i = 0; i < attrList.size(); ++i) {
            attr = (Attribute)attrList.get(i);
            if (attr.getName().equals("nodeName")) {
                buf.append(",node=").append((String)attr.getValue());
                continue;
            }
            if (!attr.getName().equals("memberName")) continue;
            buf.append(",server=").append((String)attr.getValue());
        }
        if (_tc.isDebugEnabled()) {
            Tr.exit(_tc, "getTargetFromClusterMemberAttributes", new Object[]{"cluster member target=" + buf.toString()});
        }
        return new ObjectName(buf.toString());
    }

    public static String getFormattedMessage(ResourceBundle bundle, String key, Object[] args, String msg) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getFormattedMessage()", new Object[]{key, msg});
        }
        String formattedMsg = null;
        try {
            String result = bundle.getString(key);
            formattedMsg = result == null ? msg : MessageFormat.format(result, args);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.admin.commands.AppMgmtUtils.getFormattedMessage", FFDC_ID_1);
            formattedMsg = msg;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getFormattedMessage()", new Object[]{formattedMsg});
        }
        return formattedMsg;
    }

    public static String getMinNodeVersionForApp(Session session, String appName, boolean localMode) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMinNodeVersionForApp", new Object[]{appName, localMode});
        }
        AppManagement appmgmt = null;
        String version = null;
        String minVersion = null;
        if (localMode) {
            if (_appmgmtLocal == null) {
                _appmgmtLocal = AppManagementProxy.getLocalProxy();
            }
            appmgmt = _appmgmtLocal;
        } else {
            if (_appmgmtServer == null) {
                _appmgmtServer = AppManagementProxy.getJMXProxyForServer();
            }
            appmgmt = _appmgmtServer;
        }
        if (appmgmt != null) {
            Properties queryProps = new Properties();
            queryProps.put("application", appName);
            List<ObjectName> modulesTargets = AppMgmtUtils.getAllModulesTargets(appmgmt, queryProps, session);
            for (ObjectName obj : modulesTargets) {
                version = AppMgmtUtils.getModuleTargetVersion(obj);
                if (minVersion == null) {
                    minVersion = version;
                } else if (Utils.compareVersions((String)version, (String)minVersion) < 0) {
                    minVersion = version;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "minVersion = " + minVersion + " for ObjectName " + obj.toString());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "cannot obtain an AppManagement instance.");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getMinNodeVersionForApp", new Object[]{minVersion});
        }
        return minVersion;
    }
}

