/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.status.AbstractStatusReport;
import com.ibm.ws.management.status.StatusCacheClient;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.status.StatusReportExtInternal;
import com.ibm.ws.management.status.StatusReportExtendedData;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.status.AppTargetCache;
import com.ibm.ws.webservices.admin.status.EndpointStatusDataAccessor;
import com.ibm.ws.webservices.admin.utils.EndpointStatusUtils;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.wsspi.webservices.admin.ServicesAdminConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EndpointStatusReportExtendedData
implements StatusReportExtendedData,
ServicesAdminConstants,
ServiceIndexConstants {
    public static final String KEY = "com.ibm.ws.webservices.admin.EndpointExtendedStatusReportData";
    private static TraceComponent _tc = Tr.register(EndpointStatusReportExtendedData.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private String _cacheType;
    private Target _target;
    private Map _downstreamReports;
    private AbstractStatusReport _baseReport = null;
    private Map _endpointStatusMap = new HashMap();

    public EndpointStatusReportExtendedData(String cacheType, String nodeName, String serverName, String clusterName, Map downstreamReports) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointStatusReportExtendedData", new Object[]{"cacheType=" + cacheType, "nodeName=" + nodeName, "serverName=" + serverName, "clusterName=" + clusterName});
        }
        this._cacheType = cacheType;
        this._target = new Target(nodeName, serverName, clusterName);
        this._downstreamReports = downstreamReports;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "EndpointStatusReportExtendedData");
        }
    }

    public void setBaseReport(AbstractStatusReport baseReport) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "EndpointStatusReportExtendedData.setBaseReport", new Object[]{"baseReport=" + baseReport});
        }
        this._baseReport = baseReport;
    }

    public void setDownstreamReports(Map downstreamReports) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setDownstreamReports", new Object[]{"cacheType=" + this._cacheType, "target=" + this._target});
        }
        this._downstreamReports = downstreamReports;
    }

    public String getKey() {
        return KEY;
    }

    public String getCacheType() {
        return this._cacheType;
    }

    public String getNodeName() {
        return this._target.getNodeName();
    }

    public String getServerName() {
        return this._target.getServerName();
    }

    public String getClusterName() {
        return this._target.getClusterName();
    }

    public Object getExtendedDataAccessor() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getExtendedDataAccessor", new Object[]{"cacheType=" + this._cacheType, "target=" + this._target});
        }
        EndpointStatusDataAccessor retObj = new EndpointStatusDataAccessor(this);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getExtendedDataAccessor", retObj);
        }
        return retObj;
    }

    public void setStatus(Endpoint endpoint) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setStatus", new Object[]{endpoint});
        }
        String endpointKey = this.getEndpointKey(endpoint);
        this._endpointStatusMap.put(endpointKey, EndpointStatusUtils.getStatusInString(endpoint.getState()));
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setStatus", new Object[]{"endpointKey=" + endpointKey, "status=" + EndpointStatusUtils.getStatusInString(endpoint.getState())});
        }
    }

    public String getStatus(Properties props) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getStatus", new Object[]{"props=" + props + ", cacheType=" + this._cacheType, ", target=" + this._target});
        }
        EndpointStatusUtils.validateParameters(props, "*", "getStatus");
        boolean isEndpoint = props.getProperty("logicalEndpoint") != null;
        String requestedKey = this.getEndpointKey(props);
        ArrayList statusList = new ArrayList();
        this.consolidateEndpointStatus(statusList, requestedKey, isEndpoint);
        boolean allWSFEPTargets = this.updateEndpointStatusForAllTargets(statusList, props, isEndpoint);
        String status = EndpointStatusUtils.getAggregatedStatus(statusList, allWSFEPTargets);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getStatus", new Object[]{"requestedKey=" + requestedKey, "status=" + status});
        }
        return status;
    }

    private void consolidateEndpointStatus(List statusList, String requestedKey, boolean isEndpoint) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "consolidateEndpointStatus", new Object[]{"requestedKey=" + requestedKey, "isEndpoint=" + isEndpoint, "cacheType=" + this._cacheType, "target=" + this._target});
        }
        this.addConsolidatedEntriesFromThisReport(statusList, requestedKey, isEndpoint);
        if (this._cacheType.equals("server") || this._downstreamReports == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "consolidateEndpointStatus", "This report is an app server report.  No downstream reports to consolidate.");
            }
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "consolidateEndpointStatus", "find downstream entries: " + this._downstreamReports.size());
        }
        for (Map.Entry entry : this._downstreamReports.entrySet()) {
            Object o;
            Object downstreamReportKey = entry.getKey();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing downstream report.  Key=" + downstreamReportKey);
            }
            if ((o = entry.getValue()) instanceof StatusReportExtInternal) {
                StatusReportExtInternal downstreamRpt = (StatusReportExtInternal)o;
                StatusReportExtendedData downstreamExtData = downstreamRpt.getExtendedData(KEY);
                if (downstreamExtData instanceof EndpointStatusReportExtendedData) {
                    EndpointStatusReportExtendedData endpointData = (EndpointStatusReportExtendedData)downstreamExtData;
                    endpointData.consolidateEndpointStatus(statusList, requestedKey, isEndpoint);
                    continue;
                }
                if (downstreamExtData != null) {
                    Tr.warning(_tc, "CWSAD0039W", new Object[]{downstreamExtData.getKey(), downstreamExtData.getClass().getName()});
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Extended status report data is null");
                continue;
            }
            if (!_tc.isEventEnabled()) continue;
            Tr.event(_tc, "Status report is not an extended report: " + o.getClass().getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "consolidateEndpointStatus, statusList size=" + statusList.size());
        }
    }

    private void addConsolidatedEntriesFromThisReport(List statusList, String requestedKey, boolean isEndpoint) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addConsolidatedEntriesFromThisReport", new Object[]{"requestedKey=" + requestedKey, "isEndpoint=" + isEndpoint, "cacheType=" + this._cacheType, "target=" + this._target});
        }
        for (Map.Entry endpointEntry : this._endpointStatusMap.entrySet()) {
            String endpointKey = (String)endpointEntry.getKey();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "addConsolidatedEntriesFromThisReport, Current endpointKey=" + endpointKey);
            }
            if (!this.isQualifiedEntry(requestedKey, endpointKey, isEndpoint)) continue;
            statusList.add(endpointEntry.getValue());
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "addConsolidatedEntriesFromThisReport, endpoint qualifies.  Added entry", new Object[]{"requestedKey=" + requestedKey, "endpointKey=" + endpointKey, "status=" + (String)endpointEntry.getValue()});
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addConsolidatedEntriesFromThisReport");
        }
    }

    public String print() {
        return this.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("EndpointStatusReportExtendedData ");
        buf.append(this._target.toString());
        buf.append(", cacheType=").append(this._cacheType);
        buf.append(", endpointStatusMap={").append(this._endpointStatusMap).append("}");
        return buf.toString();
    }

    private String getEndpointKey(Endpoint endpoint) {
        StringBuffer buf = new StringBuffer();
        buf.append(endpoint.getApplicationName());
        buf.append(",").append(endpoint.getModuleName());
        buf.append(",").append(endpoint.getServiceName());
        buf.append(",").append(endpoint.getPortName());
        return buf.toString();
    }

    private boolean updateEndpointStatusForAllTargets(List statusList, Properties props, boolean isEndpoint) throws Exception {
        Object statusReport;
        if (_tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < statusList.size(); ++i) {
                buf.append((String)statusList.get(i)).append(",");
            }
            Tr.entry(_tc, "updateEndpointStatusForAllTargets, statusList size=" + statusList.size() + ", status=" + buf.toString());
        }
        if ((statusReport = this._baseReport) == null) {
            StatusCacheClient _statusCacheClient = StatusCacheFactory.getStatusCacheClient((boolean)false);
            statusReport = _statusCacheClient.getReport();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateEndpointStatusForAllTargets, base report is null, so get StatusReport from StatusCacheClient");
            }
        }
        String appStatus = statusReport.getApplicationState(props.getProperty("application"));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "updateEndpointStatusForAllTargets, appStatus=" + appStatus);
        }
        if (!appStatus.equals("ExecutionState.STARTED")) {
            if (appStatus.equals("ExecutionState.STOPPED")) {
                statusList.clear();
                statusList.add("Stopped and not startable");
            } else if (appStatus.equals("ExecutionState.PARTIAL_START")) {
                statusList.add("Stopped and not startable");
            } else {
                statusList.add(EndpointStatusUtils.appStatusToEndpointListenerStatus(appStatus));
            }
        }
        boolean allWSFEPServers = false;
        AppTargetCache.ModuleTargetInfo targetInfo = AppTargetCache.getModuleTargetInfo(props);
        allWSFEPServers = targetInfo != null ? targetInfo.isWSFEPTargetOnly() : AppTargetCache.setModuleTargetInfo(props);
        if (allWSFEPServers && appStatus.equals("ExecutionState.STARTED")) {
            statusList.add("Started");
        }
        if (_tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < statusList.size(); ++i) {
                buf.append((String)statusList.get(i)).append(",");
            }
            Tr.exit(_tc, "updateEndpointStatusForAllTargets, statusList size=" + statusList.size() + ", status=" + buf.toString() + ", allWSFEPServers=" + allWSFEPServers);
        }
        return allWSFEPServers;
    }

    private String getEndpointKey(Properties props) {
        StringBuffer buf = new StringBuffer();
        buf.append(props.getProperty("application")).append(",");
        buf.append(props.getProperty("module")).append(",");
        buf.append(props.getProperty("service")).append(",");
        if (props.getProperty("logicalEndpoint") != null) {
            buf.append(props.getProperty("logicalEndpoint"));
        }
        return buf.toString();
    }

    private boolean isQualifiedEntry(String requestedKey, String endpointKey, boolean isEndpointKey) {
        boolean matched = false;
        matched = isEndpointKey ? requestedKey.equals(endpointKey) : endpointKey.startsWith(requestedKey);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isQualifiedEntry", new Object[]{"requestedKey=" + requestedKey, "endpointKey=" + endpointKey, "isEndpointKey=" + isEndpointKey, "matched=" + matched});
        }
        return matched;
    }

    private static class Target
    implements Serializable {
        private String _serverName;
        private String _nodeName;
        private String _clusterName;

        public Target(String nodeName, String serverName, String clusterName) {
            this._nodeName = nodeName;
            this._serverName = serverName;
            this._clusterName = clusterName;
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public String getServerName() {
            return this._serverName;
        }

        public String getClusterName() {
            return this._clusterName;
        }

        public boolean equals(Object thatObj) {
            if (!(thatObj instanceof Target)) {
                return false;
            }
            Target thatTarget = (Target)thatObj;
            return thatTarget._serverName.equals(this._serverName) && thatTarget._nodeName.equals(this._nodeName);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Target: {");
            if (this._clusterName != null) {
                sb.append("cluster=");
                sb.append(this._clusterName);
            } else {
                sb.append("node=");
                sb.append(this._nodeName);
                sb.append(", server=");
                sb.append(this._serverName);
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

