/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.utils.AppMgmtUtils;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import com.ibm.ws.webservices.admin.utils.EndpointStatusUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class AppTargetCache
implements ServiceIndexConstants {
    private static TraceComponent _tc = Tr.register(AppTargetCache.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String CLASS_NAME = "com.ibm.ws.webservices.admin.status.AppTargetCache";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static ResourceBundle _resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());
    private static HashMap<String, List> _targetMap = new HashMap();

    public static List getAppTargetInfo(Properties props) {
        return _targetMap.get(props.getProperty("application"));
    }

    public static ModuleTargetInfo getModuleTargetInfo(Properties props) {
        List list = _targetMap.get(props.getProperty("application"));
        String moduleName = props.getProperty("module");
        if (list != null) {
            ModuleTargetInfo targetInfo = null;
            for (int i = 0; i < list.size(); ++i) {
                targetInfo = (ModuleTargetInfo)list.get(i);
                if (!targetInfo.getModuleName().equals(moduleName)) continue;
                return targetInfo;
            }
        }
        return null;
    }

    public static synchronized boolean setModuleTargetInfo(Properties props) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setTargetInfo", new Object[]{props});
        }
        List<ObjectName> targetList = AppMgmtUtils.getModuleTargetsServerMode(props);
        ModuleTargetInfo targetInfo = new ModuleTargetInfo(props.getProperty("module"));
        targetInfo.setTargetList(targetList);
        ObjectName thisTarget = null;
        String baseVersion = null;
        boolean wsfepTargetOnly = true;
        boolean trDebug = _tc.isDebugEnabled();
        for (int i = 0; i < targetList.size(); ++i) {
            try {
                thisTarget = targetList.get(i);
                baseVersion = AppMgmtUtils.getModuleTargetVersion(thisTarget);
                if (trDebug) {
                    Tr.debug(_tc, "setTargetInfo", new Object[]{"thisTarget=" + thisTarget, "baseVersion=" + baseVersion});
                }
                if (Utils.compareVersions((String)baseVersion, (String)"7.0") < 0) continue;
                wsfepTargetOnly = false;
                break;
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.webservices.admin.status.AppTargetCache.setTargetInfo", FFDC_ID_1);
                if (_tc.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                wsfepTargetOnly = false;
            }
        }
        targetInfo.setWSFEPTargetOnly(wsfepTargetOnly);
        ArrayList<ModuleTargetInfo> list = _targetMap.get(props.getProperty("application"));
        if (list != null) {
            list.add(targetInfo);
        } else {
            if (trDebug) {
                Tr.debug(_tc, "setTargetInfo, do not find the application entry in _targetMap");
            }
            list = new ArrayList<ModuleTargetInfo>();
            list.add(targetInfo);
            _targetMap.put(props.getProperty("application"), list);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setTargetInfo, wsfepTargetOnly=" + wsfepTargetOnly);
        }
        return wsfepTargetOnly;
    }

    public static synchronized void clearCacheForApp(String appName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "clearCacheForApp, appName=" + appName);
        }
        _targetMap.remove(appName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "clearCacheForApp, appName=" + appName);
        }
    }

    public static synchronized void clearCacheForClusterTarget(String clusterName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "clearCacheForClusterTarget, clusterName=" + clusterName);
        }
        ArrayList<String> appList = new ArrayList<String>();
        Iterator<Map.Entry<String, List>> iter = _targetMap.entrySet().iterator();
        List targetList = null;
        ModuleTargetInfo targetInfo = null;
        boolean found = false;
        boolean trDebug = _tc.isDebugEnabled();
        block0: while (iter.hasNext()) {
            Map.Entry<String, List> entry = iter.next();
            targetList = entry.getValue();
            found = false;
            for (int i = 0; i < targetList.size(); ++i) {
                targetInfo = (ModuleTargetInfo)targetList.get(i);
                if (!targetInfo.isTargettedToCluster(clusterName)) continue;
                if (trDebug) {
                    Tr.debug(_tc, "clearCacheForTargerCluster, find matching, cluster=" + clusterName + ", targetInfo=" + targetInfo.toString());
                }
                appList.add(entry.getKey());
                continue block0;
            }
        }
        for (int i = 0; i < appList.size(); ++i) {
            _targetMap.remove(appList.get(i));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "clearCacheForClusterTarget, clusterName=" + clusterName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModuleTargetInfo {
        private String _moduleName;
        private List<ObjectName> _targets;
        private boolean _wsfepTargetOnly;

        public ModuleTargetInfo(String moduleName) {
            this._moduleName = moduleName;
            this._targets = new ArrayList<ObjectName>();
            this._wsfepTargetOnly = true;
        }

        public void addTarget(ObjectName target) {
            this._targets.add(target);
        }

        public void setTargetList(List<ObjectName> targetList) {
            this._targets = targetList;
        }

        public void setWSFEPTargetOnly(boolean wsfepTargetOnly) {
            this._wsfepTargetOnly = wsfepTargetOnly;
        }

        public String getModuleName() {
            return this._moduleName;
        }

        public List<ObjectName> getMatchedTargets(String requestedTarget) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ModuleTargetInfo.getMatchedTargets, requestedTarget=" + requestedTarget);
            }
            if (requestedTarget == null || requestedTarget.equals("*")) {
                return this._targets;
            }
            ArrayList<ObjectName> retList = new ArrayList<ObjectName>();
            ObjectName oneTarget = null;
            for (int i = 0; i < this._targets.size(); ++i) {
                oneTarget = this._targets.get(i);
                if (!EndpointStatusUtils.isMatchedTarget(requestedTarget, oneTarget)) continue;
                retList.add(oneTarget);
            }
            if (retList.isEmpty()) {
                throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0036E", new Object[]{requestedTarget}, "The application is not installed on the target: " + requestedTarget));
            }
            return retList;
        }

        public boolean isTargettedToCluster(String clusterName) {
            ObjectName target = null;
            String matchStr = "cluster=" + clusterName + ",";
            for (int i = 0; i < this._targets.size(); ++i) {
                target = this._targets.get(i);
                if (target.toString().indexOf(matchStr) <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean isWSFEPTargetOnly() {
            return this._wsfepTargetOnly;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("ModuleTargetInfo: ");
            sb.append("module=").append(this._moduleName);
            sb.append(",wsfepTargetOnly=").append(this._wsfepTargetOnly);
            sb.append(",targets={");
            for (int i = 0; i < this._targets.size(); ++i) {
                sb.append("[").append(this._targets.get(i)).append("] ");
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

