/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.AbstractStatusReport;
import com.ibm.ws.management.status.StatusCacheExtension;
import com.ibm.ws.management.status.StatusReportExtendedData;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.status.EndpointStatusReportExtendedData;
import com.ibm.ws.webservices.admin.utils.ConfigRepositoryUtils;
import com.ibm.ws.webservices.admin.utils.EndpointStatusUtils;
import com.ibm.ws.webservices.management.Endpoint;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class AbstractStatusCacheExtension
implements StatusCacheExtension,
ServiceIndexConstants {
    private static TraceComponent _tc = Tr.register(AbstractStatusCacheExtension.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String CLASS_NAME = "com.ibm.ws.webservices.admin.status.AbstractStatusCacheExtension";
    protected static final String ENDPOINT_APP_SERVER_LISTENER = "Web Service Endpoint App Server Listener";
    private static final String ENDPOINT_MANAGER_NOTIFICATION_TYPE = "websphere.webservices.change";
    protected boolean _disabled = false;
    protected String _cacheType;
    protected String _serverName;
    protected String _nodeName;
    protected String _clusterName;
    protected EndpointStatusReportExtendedData _statusData;
    protected Map _downstreamReports;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";

    public AbstractStatusCacheExtension(String cacheType) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, CLASS_NAME, new Object[]{"cacheType=" + cacheType});
        }
        try {
            this._cacheType = cacheType;
            this._serverName = ConfigRepositoryUtils.getThisServerName();
            this._nodeName = ConfigRepositoryUtils.getThisNodeName();
            this._clusterName = ConfigRepositoryUtils.getThisClusterName();
            this._downstreamReports = null;
            this._statusData = new EndpointStatusReportExtendedData(this._cacheType, this._nodeName, this._serverName, this._clusterName, this._downstreamReports);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.admin.status.AbstractStatusCacheExtension.registerEvents", FFDC_ID_1, this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Init error.", e);
            }
            this._disabled = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, CLASS_NAME);
        }
    }

    public void registerEvents(NotificationListener notificationListener) {
        block4: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "registerEvents for websphere.webservices.change");
            }
            try {
                ObjectName endpointMgr = new ObjectName(EndpointStatusUtils.createEndpointManagerQueryString(null, this._nodeName, this._serverName, null, null));
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType(ENDPOINT_MANAGER_NOTIFICATION_TYPE);
                AdminService adminService = AdminServiceFactory.getAdminService();
                adminService.addNotificationListenerExtended(endpointMgr, notificationListener, filter, ENDPOINT_APP_SERVER_LISTENER);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.admin.status.AbstractStatusCacheExtension.registerEvents", FFDC_ID_2, this);
                if (!_tc.isEventEnabled()) break block4;
                Tr.event(_tc, "Call to addNotificationListenerExtended failed.", e);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerEvents");
        }
    }

    public boolean handleNotification(Notification notification, Object handback) {
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "handleNotification", new Object[]{"notification=" + notification, "handback=" + handback});
            }
            if (handback == null || !handback.equals(ENDPOINT_APP_SERVER_LISTENER)) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "handleNotification, return false");
                }
                return false;
            }
            String notificationType = notification.getType();
            if (notificationType != ENDPOINT_MANAGER_NOTIFICATION_TYPE) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "handleNotification, notificationType=" + notificationType);
                }
                return false;
            }
            try {
                List endpointList = (List)notification.getUserData();
                for (int i = 0; i < endpointList.size(); ++i) {
                    this._statusData.setStatus((Endpoint)endpointList.get(i));
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.admin.status.AbstractStatusCacheExtension.handleNotification", FFDC_ID_3, this);
                if (!_tc.isDebugEnabled()) break block9;
                e.printStackTrace();
                Tr.event(_tc, "Error handling notification.", e);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "handleNotification, return true");
        }
        return true;
    }

    public StatusReportExtendedData getExtendedData(AbstractStatusReport baseStatusReport) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getExtendedData for webservices", this._statusData);
        }
        this._statusData.setBaseReport(baseStatusReport);
        return this._statusData;
    }

    public void setDownstreamReports(Map downstreamReports) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setDownstreamReports for web services", downstreamReports.keySet());
        }
        this._downstreamReports = downstreamReports;
        this._statusData.setDownstreamReports(downstreamReports);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setDownstreamReports");
        }
    }
}

