/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.admin.serviceindex.Endpoint;
import com.ibm.ws.webservices.admin.serviceindex.WebService;
import com.ibm.ws.webservices.admin.serviceindex.impl.EndpointBean;
import java.util.ArrayList;
import java.util.List;

public class WebServiceBean
implements WebService {
    public static int NUM_ATTRIBUTES = 4;
    protected static final String SEPARATOR = ",";
    private String serviceName = null;
    private String type = null;
    private boolean client = false;
    private ArrayList endpoints = new ArrayList();
    private static TraceComponent tc = Tr.register(WebServiceBean.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public WebServiceBean() {
    }

    public WebServiceBean(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceNameLocalPart() {
        if (this.serviceName == null) {
            return null;
        }
        int index = this.serviceName.indexOf(125);
        return this.serviceName.substring(index + 1);
    }

    public String getType() {
        return this.type;
    }

    public boolean isClient() {
        return this.client;
    }

    public List listEndpoints() {
        return this.endpoints;
    }

    public Endpoint getEndpoint(String endpointName) {
        if (this.endpoints.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This service does not have any endpoint, service name is " + this.serviceName);
            }
            return null;
        }
        if (endpointName == null) {
            return null;
        }
        EndpointBean enpt = null;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            enpt = (EndpointBean)this.endpoints.get(i);
            if (!endpointName.equals(enpt.getName())) continue;
            return enpt;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEndpoint, cannot find endpoint", new Object[]{this.serviceName, endpointName});
        }
        return null;
    }

    public boolean contains(String endpointName) {
        return this.getEndpoint(endpointName) != null;
    }

    public boolean hasEndpoint() {
        return this.endpoints.size() > 0;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setType(String serviceType) {
        this.type = serviceType;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public void addEndpoint(Endpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        this.endpoints.add(endpoint);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("serviceName=").append(this.serviceName);
        buffer.append(SEPARATOR).append("type=").append(this.type);
        buffer.append("\n");
        for (int i = 0; i < this.endpoints.size(); ++i) {
            buffer.append(((EndpointBean)this.endpoints.get(i)).toString());
        }
        return buffer.toString();
    }

    public String toXML(String indent) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = indent + "    ";
        buffer.append(indent);
        if (this.client) {
            buffer.append("<webserviceClient name=\"");
        } else {
            buffer.append("<webservice name=\"");
        }
        buffer.append(this.serviceName);
        buffer.append("\" type=\"").append(this.type);
        buffer.append("\">\n");
        for (int i = 0; i < this.endpoints.size(); ++i) {
            buffer.append(((EndpointBean)this.endpoints.get(i)).toXML(newIndent));
        }
        if (this.client) {
            buffer.append(indent).append("</webserviceClient>\n");
        } else {
            buffer.append(indent).append("</webservice>\n");
        }
        return buffer.toString();
    }

    public int validate(boolean fullValidate) {
        if (this.type == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate, no service type is found: " + this.serviceName);
            }
            return -6;
        }
        if (fullValidate && this.endpoints.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate, no endpoint exists in service : " + this.serviceName);
            }
            return -4;
        }
        if (fullValidate) {
            int code = 0;
            for (int i = 0; i < this.endpoints.size(); ++i) {
                code = ((EndpointBean)this.endpoints.get(i)).validate();
                if (code >= 0) continue;
                return code;
            }
        }
        return 0;
    }
}

