/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;

public class ServiceIndexWriter {
    public static final String INDENT_SPACE = "    ";
    private static TraceComponent tc = Tr.register(ServiceIndexWriter.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.serviceindex.impl.ServerIndexWriter";
    private static final String FFDC_ID_1 = "FFDC-1";

    public static int write(OutputStream ostream, Map serviceProviderMap) throws IOException {
        return ServiceIndexWriter.write(ostream, serviceProviderMap, null);
    }

    public static int write(OutputStream ostream, Map serviceProviderMap, Map serviceClientMap) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write, web services, serviceProviderMap=" + serviceProviderMap + ", serviceClientMap=" + serviceClientMap);
        }
        int retCode = 0;
        try {
            OutputStreamWriter writer = new OutputStreamWriter(ostream);
            writer.write("<?xml version=\"1.0\" ?>\n");
            writer.write("<services>\n");
            int errCode = 0;
            if (serviceProviderMap != null) {
                for (WebServiceBean service : serviceProviderMap.values()) {
                    errCode = ServiceIndexWriter.writeWebService(writer, service);
                    if (errCode >= 0) continue;
                    retCode = errCode;
                }
            }
            if (serviceClientMap != null) {
                for (WebServiceBean service : serviceClientMap.values()) {
                    errCode = ServiceIndexWriter.writeWebService(writer, service);
                    if (errCode >= 0) continue;
                    retCode = errCode;
                }
            }
            writer.write("</services>\n");
            writer.flush();
        }
        catch (IOException ioex) {
            FFDCFilter.processException(ioex, "com.ibm.ws.webservices.admin.serviceindex.impl.ServerIndexWriter.write", FFDC_ID_1);
            Tr.error(tc, "CWSAD0002E", ioex);
            throw ioex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write, return code is " + retCode);
        }
        return retCode;
    }

    private static int writeWebService(OutputStreamWriter writer, WebServiceBean service) throws IOException {
        int errCode = service.validate(true);
        String xml = service.toXML(INDENT_SPACE);
        writer.write(xml);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeWebService, web service " + service.getServiceName() + " xml string: " + xml);
        }
        return errCode;
    }
}

