/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.admin.WebServiceAdminConstants;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.Endpoint;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import com.ibm.ws.webservices.admin.serviceindex.WebService;
import com.ibm.ws.webservices.admin.serviceindex.impl.EndpointBean;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexReader;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexWriter;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.xml.sax.SAXException;

public class ServiceIndexHelperImpl
implements ServiceIndexHelper,
WebServiceAdminConstants {
    public static int SERVICE_PROVIDER_INDEX = 0;
    public static int SERVICE_CLIENT_INDEX = 1;
    private Map wsProviderMap = new HashMap();
    private Map wsClientMap = new HashMap();
    private InputStream instream = null;
    private String fileName = null;
    private Properties packageProps = null;
    private String appName = null;
    private String moduleName = null;
    private boolean fileLoaded = false;
    private static TraceComponent tc = Tr.register(ServiceIndexHelperImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());

    public ServiceIndexHelperImpl(Properties p) {
        this.fileName = p.getProperty("file");
        this.packageProps = new Properties();
        this.packageProps.putAll((Map<?, ?>)p);
        this.packageProps.remove("file");
        this.appName = this.packageProps.getProperty("application");
        this.moduleName = this.packageProps.getProperty("module");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "p is " + p + ", packageProps is " + this.packageProps);
        }
    }

    public ServiceIndexHelperImpl(Properties p, InputStream istream) {
        this.instream = istream;
        this.packageProps = new Properties();
        this.packageProps.putAll((Map<?, ?>)p);
        this.appName = this.packageProps.getProperty("application");
        this.moduleName = this.packageProps.getProperty("module");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "p is " + p + ", packageProps is " + this.packageProps);
        }
    }

    private synchronized void loadData(InputStream istream, boolean readAll) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData");
        }
        if (istream == null) {
            istream = this.instream;
        }
        boolean created = false;
        if (istream == null && this.fileName != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData: new FileInputStream for fileName=" + this.fileName);
            }
            istream = new FileInputStream(this.fileName);
            created = true;
        }
        if (istream == null) {
            throw new IOException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0001E", new Object[]{"InputStream is null, fileName=" + this.fileName}, "InputStream is null"));
        }
        ServiceIndexReader reader = new ServiceIndexReader(istream);
        Map[] wsMaps = reader.read(true);
        this.wsProviderMap = wsMaps[SERVICE_PROVIDER_INDEX];
        this.wsClientMap = wsMaps[SERVICE_CLIENT_INDEX];
        if (created) {
            istream.close();
            istream = null;
        }
        this.fileLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData");
        }
    }

    public int saveData() throws FileNotFoundException, IOException, NoItemFoundException {
        return this.saveData(null);
    }

    public int saveData(OutputStream ostream) throws FileNotFoundException, IOException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData");
        }
        if (this.wsProviderMap.isEmpty() && this.wsClientMap.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData, no web service provider or client exists in ServiceIndexHelper");
            }
            return -3;
        }
        boolean created = false;
        if (ostream == null && this.fileName != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData: new FileOutputStream for fileName=" + this.fileName);
            }
            ostream = new FileOutputStream(new File(this.fileName));
            created = true;
        }
        if (ostream == null) {
            throw new IOException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0002E", new Object[]{"OutputStream is null"}, "OutputStream is null"));
        }
        int errCode = ServiceIndexWriter.write(ostream, this.wsProviderMap, this.wsClientMap);
        if (created) {
            ostream.close();
            ostream = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData");
        }
        return errCode;
    }

    public boolean contains(String serviceName, String endpointName, String operationName, boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contains ", new Object[]{serviceName, endpointName, operationName});
        }
        if (serviceName == null) {
            return false;
        }
        WebService service = this.getWebServiceObject2(serviceName, client);
        if (service == null) {
            return false;
        }
        if (endpointName == null) {
            return true;
        }
        if (service.contains(endpointName)) {
            if (operationName == null) {
                return true;
            }
            Endpoint endpoint = service.getEndpoint(endpointName);
            return endpoint.contains(operationName);
        }
        return false;
    }

    public boolean contains(String serviceName, String endpointName, String operationName) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.contains(serviceName, endpointName, operationName, false);
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public List listWebServiceObjects() throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.listWebServiceObjects(false);
    }

    public List listWebServiceObjects(boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (!this.fileLoaded) {
            this.loadData(null, true);
        }
        Map wsMap = null;
        wsMap = client ? this.wsClientMap : this.wsProviderMap;
        if (wsMap == null || wsMap.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listWebServices, no web services is found for " + (client ? "service client" : "serviceProvider"));
            }
            return new ArrayList();
        }
        ArrayList retList = new ArrayList(wsMap.size());
        Iterator values = wsMap.values().iterator();
        while (values.hasNext()) {
            retList.add(values.next());
        }
        return retList;
    }

    public List listWebServices(boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        List websvcObjs = this.listWebServiceObjects(client);
        ArrayList<AttributeList> retList = new ArrayList<AttributeList>(websvcObjs.size());
        Attribute appAttr = new Attribute("application", this.appName);
        Attribute modAttr = new Attribute("module", this.moduleName);
        WebService service = null;
        for (int i = 0; i < websvcObjs.size(); ++i) {
            service = (WebService)websvcObjs.get(i);
            retList.add(this.getAttributesFromService(appAttr, modAttr, service));
        }
        return retList;
    }

    public List listServices(Properties queryProps, String expandResource) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServices", new Object[]{queryProps, expandResource});
        }
        ArrayList<Properties> retList = new ArrayList<Properties>();
        List websvcObjs = null;
        Boolean client = Boolean.FALSE;
        if (queryProps != null) {
            client = new Boolean(queryProps.getProperty("client"));
        }
        websvcObjs = client != false ? this.listWebServiceObjects(true) : this.listWebServiceObjects(false);
        WebService service = null;
        Properties p = null;
        for (int i = 0; i < websvcObjs.size(); ++i) {
            service = (WebService)websvcObjs.get(i);
            if (!this.matchProperties(service, queryProps)) continue;
            p = new Properties();
            p.putAll((Map<?, ?>)this.packageProps);
            p.setProperty("service", service.getServiceName());
            p.setProperty("serviceType", service.getType());
            p.setProperty("client", client.toString());
            retList.add(p);
            if (!"logicalEndpoint".equals(expandResource) && !"operation".equals(expandResource)) continue;
            List epList = service.listEndpoints();
            Endpoint endpoint = null;
            Properties epProps = null;
            Properties opProps = null;
            for (int epCnt = 0; epCnt < epList.size(); ++epCnt) {
                epProps = new Properties();
                epProps.putAll((Map<?, ?>)p);
                endpoint = (Endpoint)epList.get(epCnt);
                epProps.setProperty("logicalEndpoint", endpoint.getName());
                retList.add(epProps);
                if (!"operation".equals(expandResource)) continue;
                List opList = endpoint.listOperations();
                for (int opCnt = 0; opCnt < opList.size(); ++opCnt) {
                    opProps = new Properties();
                    opProps.putAll((Map<?, ?>)epProps);
                    opProps.setProperty("operation", (String)opList.get(opCnt));
                    retList.add(opProps);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServices");
        }
        return retList;
    }

    private boolean matchProperties(WebService service, Properties queryProps) {
        if (queryProps == null) {
            return true;
        }
        String tmpStr = null;
        tmpStr = queryProps.getProperty("service");
        if (tmpStr != null && !tmpStr.equals(service.getServiceName())) {
            return false;
        }
        tmpStr = queryProps.getProperty("type");
        if (tmpStr != null && !tmpStr.equals(service.getType())) {
            return false;
        }
        tmpStr = queryProps.getProperty("serviceType");
        return tmpStr == null || tmpStr.equals(service.getType());
    }

    public AttributeList getWebService(String serviceName, boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        WebService service = this.getWebServiceObject(serviceName, client);
        return this.getAttributesFromService(service);
    }

    public AttributeList getWebService(String serviceName) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.getWebService(serviceName, false);
    }

    public WebService getWebServiceObject(String serviceName, boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        WebService obj = this.getWebServiceObject2(serviceName, client);
        if (obj == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getWebServiceObject, cannot find service ", new Object[]{this.appName, this.moduleName, serviceName});
            }
            throw new NoItemFoundException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0005E", new Object[]{serviceName}, "No web service is found: "));
        }
        return obj;
    }

    private WebService getWebServiceObject2(String serviceName, boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (!this.fileLoaded) {
            this.loadData(null, true);
        }
        Map wsMap = null;
        wsMap = client ? this.wsClientMap : this.wsProviderMap;
        if (wsMap == null || wsMap.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getWebServiceObject, no web services is found for " + (client ? "service client" : "serviceProvider"));
            }
            return null;
        }
        Object obj = wsMap.get(serviceName);
        return (WebService)obj;
    }

    public List listEndpoints(String serviceName, boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        WebService service = this.getWebServiceObject(serviceName, client);
        List endpointList = service.listEndpoints();
        if (endpointList == null || endpointList.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listEndpoints, no endpoint is found for service " + serviceName);
            }
            return new ArrayList(0);
        }
        ArrayList<AttributeList> retList = new ArrayList<AttributeList>(endpointList.size());
        for (int i = 0; i < endpointList.size(); ++i) {
            retList.add(this.getAttributesFromEndpoint((Endpoint)endpointList.get(i)));
        }
        return retList;
    }

    public AttributeList getEndpoint(String serviceName, String endpointName, boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        Endpoint endpoint = this.getEndpointObject(serviceName, endpointName, client);
        return this.getAttributesFromEndpoint(endpoint);
    }

    public AttributeList getEndpoint(String serviceName, String endpointName) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.getEndpoint(serviceName, endpointName, false);
    }

    public Endpoint getEndpointObject(String serviceName, String endpointName, boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        WebService service = this.getWebServiceObject(serviceName, client);
        if (service == null) {
            return null;
        }
        Endpoint endpoint = service.getEndpoint(endpointName);
        if (endpoint == null) {
            throw new NoItemFoundException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0006E", new Object[]{endpointName}, "No endpoint is found: "));
        }
        return endpoint;
    }

    public List listOperations(String serviceName, String endpointName, boolean client) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (serviceName == null || endpointName == null) {
            return new ArrayList(0);
        }
        Endpoint endpoint = this.getEndpointObject(serviceName, endpointName, client);
        List opList = endpoint.listOperations();
        if (opList == null || opList.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listOperations, no operation is found for logical endpoint (port name) " + endpointName);
            }
            return new ArrayList(0);
        }
        ArrayList<AttributeList> retList = new ArrayList<AttributeList>(opList.size());
        Attribute opAttr = null;
        AttributeList opAttrList = null;
        for (int i = 0; i < opList.size(); ++i) {
            opAttr = new Attribute("operation", opList.get(i));
            opAttrList = new AttributeList(1);
            opAttrList.add(opAttr);
            retList.add(opAttrList);
        }
        return retList;
    }

    public List listOperations(String serviceName, String endpointName) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.listOperations(serviceName, endpointName, false);
    }

    public synchronized boolean addWebService(WebService wsInfo) {
        if (wsInfo == null || wsInfo.getServiceName() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addWebService, wsInfo is null or wsInfo.getServiceName is null");
            }
            return false;
        }
        if (wsInfo.isClient()) {
            this.wsClientMap.put(wsInfo.getServiceName(), wsInfo);
        } else {
            this.wsProviderMap.put(wsInfo.getServiceName(), wsInfo);
        }
        return true;
    }

    public boolean addWebService(WebService wsInfo, boolean replace) {
        return this.addWebService(wsInfo);
    }

    public int validate(boolean fullValidate) throws NoItemFoundException {
        if (this.wsProviderMap.isEmpty() && this.wsClientMap.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate, no service provider or client exists in module " + this.getFullyQualifiedModuleName());
            }
            return -3;
        }
        Iterator it = this.wsProviderMap.values().iterator();
        int retCode = 0;
        while (it.hasNext()) {
            retCode = ((WebServiceBean)it.next()).validate(fullValidate);
            if (retCode >= 0) continue;
            return retCode;
        }
        it = this.wsClientMap.values().iterator();
        while (it.hasNext()) {
            retCode = ((WebServiceBean)it.next()).validate(fullValidate);
            if (retCode >= 0) continue;
            return retCode;
        }
        return 0;
    }

    private String getFullyQualifiedModuleName() {
        if (this.appName == null || this.moduleName == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("/application:").append(this.appName).append("/module:").append(this.moduleName);
        return buf.toString();
    }

    private String getFullyQualifiedServiceName(String serviceName) {
        if (this.appName == null || this.moduleName == null) {
            return serviceName;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("/application:").append(this.appName).append("/module:").append(this.moduleName).append("/service:").append(serviceName);
        return buf.toString();
    }

    private AttributeList getAttributesFromService(Attribute appAttr, Attribute moduleAttr, WebService service) {
        AttributeList attrList = new AttributeList();
        if (service == null) {
            return attrList;
        }
        attrList.add(appAttr);
        attrList.add(moduleAttr);
        attrList.add(new Attribute("service", service.getServiceName()));
        attrList.add(new Attribute("client", service.isClient()));
        if (!service.isClient()) {
            attrList.add(new Attribute("type", service.getType()));
        }
        return attrList;
    }

    private AttributeList getAttributesFromService(WebService service) {
        AttributeList attrList = new AttributeList();
        if (service == null) {
            return attrList;
        }
        attrList.add(new Attribute("service", service.getServiceName()));
        attrList.add(new Attribute("client", service.isClient()));
        if (!service.isClient()) {
            attrList.add(new Attribute("type", service.getType()));
        }
        return attrList;
    }

    private AttributeList getAttributesFromEndpoint(Endpoint endpoint) {
        AttributeList attrList = new AttributeList();
        if (endpoint == null) {
            return attrList;
        }
        attrList.add(new Attribute("logicalEndpoint", endpoint.getName()));
        return attrList;
    }

    public static void main(String[] args) {
        ServiceIndexHelperImpl.unit_test_create_indexfile(args);
    }

    private static void unit_test1(String[] args) {
        try {
            System.out.println("\n\n Start unit test 1");
            ServiceIndexHelper helper = ServiceIndexHelperFactory.createHelper(null, null, args[2]);
            WebService wsInfo = null;
            AttributeList wsAttrList = null;
            Object endpointList = null;
            Object endpoint = null;
            HashMap<String, WebService> newWsMap = new HashMap<String, WebService>();
            Attribute attr = null;
            System.out.println("test listWebServices and create a new HashMap:");
            List objList = helper.listWebServiceObjects(false);
            for (int i = 0; i < objList.size(); ++i) {
                WebService svc = (WebService)objList.get(i);
                System.out.println("get WebService " + i + ": " + svc.toXML(""));
            }
            List list = helper.listWebServices(true);
            System.out.println("listWebServices returns " + list);
            for (int i = 0; i < list.size(); ++i) {
                wsAttrList = (AttributeList)list.get(i);
                attr = (Attribute)wsAttrList.get(0);
                System.out.println("\napp: name=" + attr.getName() + " value=" + attr.getValue());
                attr = (Attribute)wsAttrList.get(1);
                System.out.println("module: name=" + attr.getName() + " value=" + attr.getValue());
                attr = (Attribute)wsAttrList.get(2);
                System.out.println("service: name=" + attr.getName() + " value=" + attr.getValue());
                attr = (Attribute)wsAttrList.get(4);
                System.out.println("type: name=" + attr.getName() + " value=" + attr.getValue());
                attr = (Attribute)wsAttrList.get(2);
                String serviceName = (String)attr.getValue();
                wsInfo = ((ServiceIndexHelperImpl)helper).getWebServiceObject(serviceName, false);
                newWsMap.put(serviceName, wsInfo);
            }
            WebServiceBean newService = new WebServiceBean(args[3]);
            EndpointBean newEndpoint1 = new EndpointBean(args[4]);
            EndpointBean newEndpoint2 = new EndpointBean("myEndpoint2");
            newService.setType("JAX-WS");
            newService.addEndpoint(newEndpoint1);
            newService.addEndpoint(newEndpoint2);
            newEndpoint1.addOperation("operation11");
            newEndpoint1.addOperation("operation12");
            newEndpoint2.addOperation("operation2");
            if (!newWsMap.containsKey(newService.getServiceName())) {
                newWsMap.put(newService.getServiceName(), newService);
            }
            System.out.println("call helper.saveData");
            int errCode = ServiceIndexWriter.write(new FileOutputStream(args[2]), newWsMap, null);
            if (errCode < 0) {
                System.out.println("Something is wrong: saveData return errCode=" + errCode);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void unit_test2(String[] args) {
        try {
            System.out.println("\n\n Start unit test 2");
            ServiceIndexHelper helper = ServiceIndexHelperFactory.createHelper(args[0], args[1], new FileInputStream(args[2]));
            String svcname = args[3];
            String enptname = args[4];
            String opname = args[5];
            if (enptname.equals("no")) {
                enptname = null;
            }
            if (opname.equals("no")) {
                opname = null;
            }
            System.out.println("contains returns " + helper.contains(svcname, enptname, opname, false));
            AttributeList wsAttrList = null;
            List endpointList = null;
            AttributeList endpointAttrList = null;
            HashMap newWsMap = new HashMap();
            String serviceName = args[3];
            wsAttrList = helper.getWebService(serviceName, false);
            if (wsAttrList == null) {
                System.out.println("Cannot find the service " + serviceName);
                return;
            }
            System.out.println("fina service " + serviceName);
            Attribute attr = (Attribute)wsAttrList.get(2);
            System.out.println("\n\ngetWebService return attrbuteList: type=" + attr.getName() + ", value=" + (String)attr.getValue() + ", size=" + wsAttrList.size());
            System.out.println("\n\n ----- test listEndpoints");
            endpointList = helper.listEndpoints(serviceName, false);
            for (int i = 0; i < endpointList.size(); ++i) {
                endpointAttrList = (AttributeList)endpointList.get(i);
                attr = (Attribute)endpointAttrList.get(0);
                System.out.println("endpoint: name=" + attr.getName() + " value=" + attr.getValue() + ", sizing=" + endpointAttrList.size());
            }
            System.out.println("\n\n ----- test listOperations");
            List opList = helper.listOperations(serviceName, args[4], false);
            AttributeList opAttrList = null;
            if (opList != null) {
                for (int i = 0; i < opList.size(); ++i) {
                    opAttrList = (AttributeList)opList.get(i);
                    attr = (Attribute)opAttrList.get(0);
                    System.out.println("operation: name=" + attr.getName() + " value=" + attr.getValue() + ", size=" + opAttrList.size());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void unit_test3(String[] args) {
        try {
            System.out.println("\n\n Start unit test 3 - test listWebServices");
            ServiceIndexHelper helper = ServiceIndexHelperFactory.createHelper(args[0], args[1], new FileInputStream(args[2]));
            AttributeList wsAttrList = null;
            Attribute attr = null;
            List list = helper.listWebServices(false);
            System.out.println("listWebServices returns " + list);
            for (int i = 0; i < list.size(); ++i) {
                wsAttrList = (AttributeList)list.get(i);
                System.out.println("\n\n");
                attr = (Attribute)wsAttrList.get(0);
                System.out.println("app: name=" + attr.getName() + " value=" + attr.getValue());
                attr = (Attribute)wsAttrList.get(1);
                System.out.println("module: name=" + attr.getName() + " value=" + attr.getValue());
                attr = (Attribute)wsAttrList.get(2);
                System.out.println("service: name=" + attr.getName() + " value=" + attr.getValue());
                attr = (Attribute)wsAttrList.get(4);
                System.out.println("type: name=" + attr.getName() + " value=" + attr.getValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void unit_test_create_indexfile(String[] args) {
        try {
            System.out.println("\n\n Start unit test create_indexfile");
            ServiceIndexHelper helper = ServiceIndexHelperFactory.createHelper(null, null, args[2]);
            WebService service1 = ServiceIndexHelperFactory.createWebService("{namespaceURI1}service1");
            service1.setType("JAX-WS");
            Endpoint endpoint1 = ServiceIndexHelperFactory.createEndpoint("endpointA");
            endpoint1.addOperation("opA1");
            endpoint1.addOperation("opA2");
            Endpoint endpoint2 = ServiceIndexHelperFactory.createEndpoint("endpointB");
            endpoint2.addOperation("opB1");
            service1.addEndpoint(endpoint1);
            service1.addEndpoint(endpoint2);
            WebService service2 = ServiceIndexHelperFactory.createWebService("{namespaceURI2}service2");
            service2.setType("JAX-WS");
            service2.setClient(true);
            endpoint1 = ServiceIndexHelperFactory.createEndpoint("endpointC");
            endpoint1.addOperation("opC1");
            service2.addEndpoint(endpoint1);
            helper.addWebService(service1);
            helper.addWebService(service2);
            helper.saveData(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

