/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.admin.serviceindex.Endpoint;
import java.util.ArrayList;
import java.util.List;

public class EndpointBean
implements Endpoint {
    protected static final String SEPARATOR = ",";
    private String name = null;
    private ArrayList operations = new ArrayList(0);
    private static TraceComponent tc = Tr.register(EndpointBean.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public EndpointBean() {
    }

    public EndpointBean(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List listOperations() {
        return this.operations;
    }

    public boolean contains(String operationName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contains, endpoint=" + this.name + ", operationName=" + operationName);
        }
        if (operationName == null) {
            return false;
        }
        for (int i = 0; i < this.operations.size(); ++i) {
            if (!operationName.equals((String)this.operations.get(i))) continue;
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contains, cannot find operation", new Object[]{this.name, operationName});
        }
        return false;
    }

    public void setName(String portName) {
        this.name = portName;
    }

    public boolean addOperation(String op) {
        if (op == null) {
            return false;
        }
        if (this.operations == null) {
            this.operations = new ArrayList();
        }
        this.operations.add(op);
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("endpointName=").append(this.name);
        buffer.append(SEPARATOR).append("operations={");
        for (int i = 0; i < this.operations.size(); ++i) {
            buffer.append((String)this.operations.get(i)).append(" ");
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    public String toXML(String indent) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = indent + "    ";
        buffer.append(indent).append("<endpoint name=\"");
        buffer.append(this.name).append("\">\n");
        for (int i = 0; i < this.operations.size(); ++i) {
            buffer.append(newIndent).append("<operation name=\"").append((String)this.operations.get(i)).append("\"/>\n");
        }
        buffer.append(indent).append("</endpoint>\n");
        return buffer.toString();
    }

    public int validate() {
        if (this.operations == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "validate, no operation exists in endpoint " + this.name);
        }
        return 0;
    }
}

