/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import com.ibm.wsspi.webservices.models.WSModels;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public class VerifyEJBandItsRoutersTaskImpl {
    private static TraceComponent tc = Tr.register(VerifyEJBandItsRoutersTaskImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private ResourceBundle _resourceBundle = null;
    private RepositoryContext _deployContext = null;
    private int _operation = 0;
    private Map _existingIndex = new Hashtable();
    private Locale _locale = null;
    private static String FFDC_1 = "FFDC-1";

    ResourceBundle getResourceBundle() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.getResourceBundle()");
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.getResourceBundle()");
        }
        return this._resourceBundle;
    }

    void setResourceBundle(ResourceBundle resourceBundle) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.setResourceBundle()");
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.setResourceBundle()");
        }
        this._resourceBundle = resourceBundle;
    }

    void setDeployContext(RepositoryContext deployContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.setDeployContext()");
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.setDeployContext()");
        }
        this._deployContext = deployContext;
    }

    void setOperation(int operation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.setOperation()");
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.setOperatoin()");
        }
        this._operation = operation;
    }

    void setExistingIndex(Map existing) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.setExistingIndex()");
        }
        this._existingIndex = existing == null ? new Hashtable() : existing;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.setExistingIndex()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyInstallOrEdit(Scheduler scheduler, EARFile earFile, Locale locale, String taskName) throws AdminException {
        block25: {
            block26: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.verifyInstallOrEdit", new Object[]{this, scheduler.getClass().getName()});
                }
                try {
                    try {
                        if (!(scheduler instanceof InstallScheduler) && !(scheduler instanceof EditSchedulerImpl)) break block25;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "VerifyEJBandItsRoutersTaskImpl.verifyInstallOrEdit, install scheduler or edit scheduler");
                        }
                        Hashtable _table = null;
                        _table = scheduler instanceof InstallScheduler ? (Hashtable)((InstallScheduler)scheduler).getProperties().get("moduleToServer") : (Hashtable)((EditSchedulerImpl)scheduler).getProperties().get("moduleToServer");
                        if (_table == null || _table.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyInstallOrEdit, target hashtable is empty, do nothing");
                            }
                            Object var24_7 = null;
                            if (!tc.isDebugEnabled()) return;
                            break block26;
                        }
                        List ejbJars = earFile.getEJBJarFiles();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "VerifyEJBandItsRoutersTaskImpl.verifyInstallOrEdit, ejbJars size=" + ejbJars.size());
                        }
                        for (EJBJarFile ejbJar : ejbJars) {
                            WSBinding wsb = WSModels.getWSBinding(ejbJar.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                            if (!CommonUtils.hasJAXWSWebServices((ModuleFile)ejbJar, scheduler) && !CommonUtils.hasJAXRPCWebServices(ejbJar, scheduler) && wsb == null) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "This EJB jar module is a jms router module; skip processing it and continue to find a true EJB jar module");
                                continue;
                            }
                            if (!CommonUtils.hasJAXWSWebServices((ModuleFile)ejbJar, scheduler) && !CommonUtils.hasJAXRPCWebServices(ejbJar, scheduler)) continue;
                            String ejbName = ejbJar.getURI();
                            String ejbKey = this.getTableKey(_table, ejbName);
                            String serverStringOfEJBJAR = null;
                            if (ejbKey != null) {
                                serverStringOfEJBJAR = (String)_table.get(ejbKey);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "verifyInstallOrEdit, ejbKey=" + ejbKey + ", serverString=" + serverStringOfEJBJAR);
                                }
                            } else {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "The hashtable does not contain the key for EJB module " + ejbName + ". Skip validating it.");
                                continue;
                            }
                            if (serverStringOfEJBJAR == null) {
                                Object[] arg = new Object[]{ejbName};
                                String msg = this.getResourceBundle().getString("CWSAD0052E");
                                String error = MessageFormat.format(msg, arg);
                                throw new AdminException(error);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "serverStringofEJBJAR is " + serverStringOfEJBJAR);
                            }
                            if (wsb == null) continue;
                            EList routerModulesList = wsb.getRouterModules();
                            Iterator routerModulesIter = routerModulesList.iterator();
                            String serverStringOfHttpRouterWAR = null;
                            String serverStringOfJmsRouterJAR = null;
                            while (routerModulesIter.hasNext()) {
                                String routerKey;
                                RouterModule routerModule = (RouterModule)routerModulesIter.next();
                                String routerName = routerModule.getName();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Router module name is " + routerName);
                                }
                                if ((routerKey = this.getTableKey(_table, routerName)) == null) {
                                    Object[] arg = new Object[]{routerName};
                                    String msg = this.getResourceBundle().getString("CWSAD0053E");
                                    String error = MessageFormat.format(msg, arg);
                                    throw new AdminException(error);
                                }
                                if ("http".equals(routerModule.getTransport())) {
                                    serverStringOfHttpRouterWAR = (String)_table.get(routerKey);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Table contains server string of , " + serverStringOfHttpRouterWAR + ", for http router war module, " + routerName);
                                    }
                                    if (routerName == null) continue;
                                    if (serverStringOfHttpRouterWAR == null) {
                                        Object[] arg = new Object[]{routerKey};
                                        String msg = this.getResourceBundle().getString("CWSAD0054E");
                                        String error = MessageFormat.format(msg, arg);
                                        throw new AdminException(error);
                                    }
                                    if (this.isTargetTheSame(serverStringOfEJBJAR.trim(), serverStringOfHttpRouterWAR.trim())) continue;
                                    Object[] arg = new Object[]{serverStringOfEJBJAR, serverStringOfHttpRouterWAR};
                                    String msg = this.getResourceBundle().getString("CWSAD0055E");
                                    String error = MessageFormat.format(msg, arg);
                                    throw new AdminException(error);
                                }
                                if (!"jms".equals(routerModule.getTransport())) continue;
                                serverStringOfJmsRouterJAR = (String)_table.get(routerKey);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Table contains server string of , " + serverStringOfHttpRouterWAR + ", for jms router jar module, " + routerName);
                                }
                                if (routerName == null) continue;
                                if (serverStringOfJmsRouterJAR == null) {
                                    Object[] arg = new Object[]{routerKey};
                                    String msg = this.getResourceBundle().getString("CWSAD0056E");
                                    String error = MessageFormat.format(msg, arg);
                                    throw new AdminException(error);
                                }
                                if (this.isTargetTheSame(serverStringOfEJBJAR.trim(), serverStringOfJmsRouterJAR.trim())) continue;
                                Object[] arg = new Object[]{serverStringOfEJBJAR, serverStringOfJmsRouterJAR};
                                String msg = this.getResourceBundle().getString("CWSAD0057E");
                                String error = MessageFormat.format(msg, arg);
                                throw new AdminException(error);
                            }
                        }
                        break block25;
                    }
                    catch (Throwable th) {
                        FFDCFilter.processException(th, "com.ibm.ws.webservices.admin.deploy.VerifyEJBandItsRoutersTaskImpl.verifyInstallOrEdit", "232", this);
                        if (!(th instanceof AdminException)) throw new AdminException(th);
                        throw (AdminException)th;
                    }
                }
                catch (Throwable throwable) {
                    Object var24_9 = null;
                    if (!tc.isDebugEnabled()) throw throwable;
                    Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyInstallOrEdit", this);
                    throw throwable;
                }
            }
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyInstallOrEdit", this);
            return;
        }
        Object var24_8 = null;
        if (!tc.isDebugEnabled()) return;
        Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyInstallOrEdit", this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyModuleUpdate(ModuleFile updatedModuleFile, Scheduler scheduler, EARFile deployedEarFile, Locale locale, String taskName) throws AdminException {
        block39: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.verifyModuleUpdate", new Object[]{((UpdateScheduler)scheduler).getContentURI(), taskName});
            }
            try {
                block40: {
                    try {
                        WSBinding wsb_for_updated_webModule;
                        String key;
                        Hashtable _table = (Hashtable)((UpdateScheduler)scheduler).getProperties().get("moduleToServer");
                        if (_table == null || _table.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyModuleUpdate, target hashtable is empty, do nothing");
                            }
                            Object var35_8 = null;
                            if (!tc.isDebugEnabled()) return;
                            break block39;
                        }
                        String updatedModuleName = ((UpdateScheduler)scheduler).getContentURI();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "updatedModule name is " + updatedModuleName);
                        }
                        if ((key = this.getTableKey(_table, updatedModuleName)) == null || key.equals("")) break block40;
                        String serverStringOfUpdatedModule = (String)_table.get(key);
                        RepositoryContext rc = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
                        ApplicationDeployment appDeploy = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc);
                        EList targetMappings_from_deployedModule = null;
                        ModuleDeployment moduleD = null;
                        if ("add".equals(((UpdateScheduler)scheduler).getOperation())) {
                            if (updatedModuleFile.isEJBJarFile()) {
                                WSBinding wsb = WSModels.getWSBinding(updatedModuleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                                if (!CommonUtils.hasJAXWSWebServices(updatedModuleFile, scheduler) && !CommonUtils.hasJAXRPCWebServices(updatedModuleFile, scheduler) && wsb == null) {
                                    this.verifyRouterModule(updatedModuleName, serverStringOfUpdatedModule, scheduler, appDeploy, deployedEarFile, rc.getParent().getParent().getName());
                                    break block40;
                                }
                                if ((CommonUtils.hasJAXWSWebServices(updatedModuleFile, scheduler) || CommonUtils.hasJAXRPCWebServices(updatedModuleFile, scheduler)) && wsb != null && wsb != null) {
                                    EList routerModulesList = wsb.getRouterModules();
                                    for (RouterModule routerModule : routerModulesList) {
                                        String routerName = routerModule.getName();
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Router module name within update webservices EJB jar is " + routerName);
                                        }
                                        this.verifyRouterModule2(routerName, routerModule.getTransport(), serverStringOfUpdatedModule, scheduler, taskName, appDeploy, deployedEarFile, rc.getParent().getParent().getName());
                                    }
                                }
                                break block40;
                            }
                            WSBinding wsb = WSModels.getWSBinding(updatedModuleFile.getLoadStrategy(), "WEB-INF/ibm-webservices-bnd.xmi");
                            if (!CommonUtils.hasJAXWSWebServices(updatedModuleFile, scheduler) && !CommonUtils.hasJAXRPCWebServices(updatedModuleFile, scheduler) && wsb == null) {
                                this.verifyRouterModule(updatedModuleName, serverStringOfUpdatedModule, scheduler, appDeploy, deployedEarFile, rc.getParent().getParent().getName());
                            }
                            break block40;
                        }
                        boolean found_module_on_server = false;
                        String moduleDUri = null;
                        for (int i = 0; i < appDeploy.getModules().size(); ++i) {
                            moduleD = (ModuleDeployment)appDeploy.getModules().get(i);
                            moduleDUri = moduleD.getUri();
                            if (!moduleDUri.equals(updatedModuleName)) continue;
                            found_module_on_server = true;
                            targetMappings_from_deployedModule = moduleD.getTargetMappings();
                            break;
                        }
                        if (!found_module_on_server) {
                            Object[] arg = new Object[]{updatedModuleName};
                            String msg = this.getResourceBundle().getString("CWSAD0059E");
                            String error = MessageFormat.format(msg, arg);
                            throw new AdminException(error);
                        }
                        this.compareServerTargets(scheduler, targetMappings_from_deployedModule, moduleDUri, updatedModuleName, serverStringOfUpdatedModule, rc.getParent().getParent().getName());
                        if (updatedModuleFile.isEJBJarFile()) {
                            WSBinding wsb_from_updatedModule = WSModels.getWSBinding(updatedModuleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                            if ((CommonUtils.hasJAXWSWebServices(updatedModuleFile, scheduler) || CommonUtils.hasJAXRPCWebServices(updatedModuleFile, scheduler)) && wsb_from_updatedModule != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "This updated module is an ejb jar.");
                                }
                                List deployedEjbJars = deployedEarFile.getEJBJarFiles();
                                for (EJBJarFile deployedEjbJar : deployedEjbJars) {
                                    String error;
                                    AppNotification appNotf;
                                    String warning;
                                    String msg;
                                    int i;
                                    int router_size_from_deployedModule;
                                    WSBinding wsb_from_deployedModule = WSModels.getWSBinding(deployedEjbJar.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                                    if (!CommonUtils.hasJAXWSWebServices(deployedEjbJar) && !CommonUtils.hasJAXRPCWebServices(deployedEjbJar) || wsb_from_deployedModule == null) continue;
                                    EList routerModules_from_updatedModule = wsb_from_updatedModule.getRouterModules();
                                    EList routerModules_from_deployedModule = wsb_from_deployedModule.getRouterModules();
                                    int router_size_from_updatedModule = routerModules_from_updatedModule.size();
                                    if (router_size_from_updatedModule != (router_size_from_deployedModule = routerModules_from_deployedModule.size())) {
                                        Object[] args = new Object[]{updatedModuleName, router_size_from_updatedModule, router_size_from_deployedModule};
                                        String msg2 = this.getResourceBundle().getString("CWSAD0043W");
                                        String warning2 = MessageFormat.format(msg2, args);
                                        Tr.warning(tc, warning2);
                                        AppNotification appNotf2 = this.createNotification(taskName, "Warning", warning2);
                                        continue;
                                    }
                                    String httpModuleName_from_updatedModule = null;
                                    String jmsModuleName_from_updatedModule = null;
                                    String httpModuleName_from_deployedModule = null;
                                    String jmsModuleName_from_deployedModule = null;
                                    RouterModule routerModule = null;
                                    for (i = 0; i < router_size_from_updatedModule; ++i) {
                                        routerModule = (RouterModule)routerModules_from_updatedModule.get(i);
                                        if ("http".equals(routerModule.getTransport())) {
                                            httpModuleName_from_updatedModule = routerModule.getName();
                                        } else if ("jms".equals(routerModule.getTransport())) {
                                            jmsModuleName_from_updatedModule = routerModule.getName();
                                        }
                                        this.verifyRouterModule2(routerModule.getName(), routerModule.getTransport(), serverStringOfUpdatedModule, scheduler, taskName, appDeploy, deployedEarFile, rc.getParent().getParent().getName());
                                    }
                                    for (i = 0; i < router_size_from_deployedModule; ++i) {
                                        routerModule = (RouterModule)routerModules_from_deployedModule.get(i);
                                        if ("http".equals(routerModule.getTransport())) {
                                            httpModuleName_from_deployedModule = routerModule.getName();
                                            continue;
                                        }
                                        if (!"jms".equals(routerModule.getTransport())) continue;
                                        jmsModuleName_from_deployedModule = routerModule.getName();
                                    }
                                    if (httpModuleName_from_deployedModule != null) {
                                        if (httpModuleName_from_updatedModule == null || httpModuleName_from_updatedModule.equals("")) {
                                            Object[] arg = new Object[]{updatedModuleName};
                                            msg = this.getResourceBundle().getString("CWSAD0044W");
                                            warning = MessageFormat.format(msg, arg);
                                            Tr.warning(tc, warning);
                                            appNotf = this.createNotification(taskName, "Warning", warning);
                                            scheduler.propagateTaskEvent(appNotf);
                                        } else if (!httpModuleName_from_updatedModule.equals(httpModuleName_from_deployedModule)) {
                                            Object[] args = new Object[]{updatedModuleName, httpModuleName_from_updatedModule, httpModuleName_from_deployedModule};
                                            msg = this.getResourceBundle().getString("CWSAD0045E");
                                            error = MessageFormat.format(msg, args);
                                            appNotf = this.createNotification(taskName, "Failed", error);
                                            scheduler.propagateTaskEvent(appNotf);
                                            throw new AdminException(error);
                                        }
                                    } else if (httpModuleName_from_updatedModule != null) {
                                        Object[] args = new Object[]{updatedModuleName, httpModuleName_from_updatedModule};
                                        msg = this.getResourceBundle().getString("CWSAD0046W");
                                        warning = MessageFormat.format(msg, args);
                                        Tr.warning(tc, warning);
                                        appNotf = this.createNotification(taskName, "Warning", warning);
                                        scheduler.propagateTaskEvent(appNotf);
                                    }
                                    if (jmsModuleName_from_deployedModule != null) {
                                        if (jmsModuleName_from_updatedModule == null || jmsModuleName_from_updatedModule.equals("")) {
                                            Object[] args = new Object[]{updatedModuleName};
                                            msg = this.getResourceBundle().getString("CWSAD0047W");
                                            warning = MessageFormat.format(msg, args);
                                            Tr.warning(tc, warning);
                                            appNotf = this.createNotification(taskName, "Warning", warning);
                                            scheduler.propagateTaskEvent(appNotf);
                                            continue;
                                        }
                                        if (jmsModuleName_from_updatedModule.equals(jmsModuleName_from_deployedModule)) continue;
                                        Object[] args = new Object[]{updatedModuleName};
                                        msg = this.getResourceBundle().getString("CWSAD0048E");
                                        error = MessageFormat.format(msg, args);
                                        appNotf = this.createNotification(taskName, "Failed", error);
                                        scheduler.propagateTaskEvent(appNotf);
                                        throw new AdminException(error);
                                    }
                                    if (jmsModuleName_from_updatedModule == null && jmsModuleName_from_updatedModule.equals("")) continue;
                                    Object[] args = new Object[]{updatedModuleName};
                                    msg = this.getResourceBundle().getString("CWSAD0049W");
                                    warning = MessageFormat.format(msg, args);
                                    Tr.warning(tc, warning);
                                    appNotf = this.createNotification(taskName, "Warning", warning);
                                    scheduler.propagateTaskEvent(appNotf);
                                }
                                break block40;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The updated module is JMS router jar.");
                            }
                            this.verifyRouterModule(updatedModuleName, serverStringOfUpdatedModule, scheduler, appDeploy, deployedEarFile, rc.getParent().getParent().getName());
                            break block40;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The updated module is a WAR.");
                        }
                        if ((wsb_for_updated_webModule = WSModels.getWSBinding(updatedModuleFile.getLoadStrategy(), "WEB-INF/ibm-webservices-bnd.xmi")) != null) break block40;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This WAR module is a router module.");
                        }
                        this.verifyRouterModule(updatedModuleName, serverStringOfUpdatedModule, scheduler, appDeploy, deployedEarFile, rc.getParent().getParent().getName());
                    }
                    catch (Throwable th) {
                        FFDCFilter.processException(th, "com.ibm.ws.webservices.admin.deploy.VerifyEJBandItsRoutersTaskImpl.verifyUpdatedModule", "494", this);
                        if (!(th instanceof AdminException)) throw new AdminException(th);
                        throw (AdminException)th;
                    }
                }
                Object var35_9 = null;
                if (!tc.isDebugEnabled()) return;
                Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyModuleUpdate");
                return;
            }
            catch (Throwable throwable) {
                Object var35_10 = null;
                if (!tc.isDebugEnabled()) throw throwable;
                Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyModuleUpdate");
                throw throwable;
            }
        }
        Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyModuleUpdate");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyPartialUpdate(Scheduler scheduler, String contentType, String operationType, Locale locale, EARFile earFile, RepositoryContext rc, String taskName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.verifyPartialUpdate", new Object[]{contentType, operationType, taskName});
        }
        try {
            try {
                UpdateScheduler ush = (UpdateScheduler)scheduler;
                if (rc == null) {
                    String msg = this.getResourceBundle().getString("CWSAD0075E");
                    throw new AdminException(msg);
                }
                UpdateScheduler upsch = (UpdateScheduler)scheduler;
                List jarModules = earFile.getEJBJarFiles();
                for (ModuleFile jarModule : jarModules) {
                    WSBinding wsb;
                    String jarModuleName = jarModule.getURI();
                    boolean jaxwsType = CommonUtils.hasJAXWSWebServices(jarModule, scheduler);
                    boolean jaxrpcType = false;
                    String moduleType = null;
                    if (jaxwsType) {
                        moduleType = "jaxwsType";
                    } else {
                        jaxrpcType = CommonUtils.hasJAXRPCWebServices(jarModule, scheduler);
                        if (jaxrpcType) {
                            moduleType = "jaxrpcType";
                        }
                    }
                    if (!jaxwsType && !jaxrpcType || (wsb = WSModels.getWSBinding(jarModule.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi")) == null) continue;
                    List targets = this.serverStringOfModule(rc, (Scheduler)upsch, jarModuleName);
                    String serverStringOfUpdatedEJBModule = null;
                    for (int i = 0; i < targets.size(); ++i) {
                        String sTarget;
                        if (serverStringOfUpdatedEJBModule == null || serverStringOfUpdatedEJBModule.equals("")) {
                            sTarget = VerifyEJBandItsRoutersTaskImpl._readTarget((DeploymentTargetMapping)targets.get(i), rc.getParent().getParent().getName());
                            if (sTarget == null || sTarget.equals("")) continue;
                            serverStringOfUpdatedEJBModule = sTarget;
                            continue;
                        }
                        sTarget = VerifyEJBandItsRoutersTaskImpl._readTarget((DeploymentTargetMapping)targets.get(i), rc.getParent().getParent().getName());
                        if (sTarget == null || sTarget.equals("")) continue;
                        serverStringOfUpdatedEJBModule = serverStringOfUpdatedEJBModule + "+" + sTarget;
                    }
                    if (serverStringOfUpdatedEJBModule == null || serverStringOfUpdatedEJBModule.equals("")) {
                        String msg = this.getResourceBundle().getString("CWSAD0076E");
                        throw new AdminException(msg);
                    }
                    Hashtable _table = (Hashtable)ush.getProperties().get("moduleToServer");
                    if (_table != null && _table.size() > 0) {
                        Enumeration e = _table.keys();
                        while (e.hasMoreElements()) {
                            String localKey = (String)e.nextElement();
                            String updatedModuleName = util.getModuleURIFromUniqueName((String)localKey);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Update module name for the partial update is " + updatedModuleName);
                            }
                            String serverStringOfUpdatedFile = (String)_table.get(localKey);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Map modules to servers contains " + localKey + " = " + serverStringOfUpdatedFile);
                            }
                            if (!updatedModuleName.equals(jarModuleName) || !updatedModuleName.equals(jarModuleName)) continue;
                            this.compareServerTargets(scheduler, targets, updatedModuleName, jarModuleName, serverStringOfUpdatedFile, rc.getParent().getParent().getName());
                        }
                    }
                    EList routerModules_from_deployedModule = wsb.getRouterModules();
                    String routerModuleName_from_updatedModule_binding = null;
                    RouterModule routerModule = null;
                    for (int i = 0; i < routerModules_from_deployedModule.size(); ++i) {
                        routerModule = (RouterModule)routerModules_from_deployedModule.get(i);
                        routerModuleName_from_updatedModule_binding = routerModule.getName();
                        List serverStringOfDeployedRouterMoudule = this.serverStringOfModule(rc, scheduler, routerModuleName_from_updatedModule_binding);
                        if (serverStringOfDeployedRouterMoudule == null || ((Object)serverStringOfDeployedRouterMoudule).equals("")) {
                            String msg = this.getResourceBundle().getString("CWSAD0077E");
                            throw new AdminException(msg);
                        }
                        this.compareServerTargets(scheduler, serverStringOfDeployedRouterMoudule, routerModuleName_from_updatedModule_binding, jarModule.getURI(), serverStringOfUpdatedEJBModule, rc.getParent().getParent().getName());
                    }
                }
                Object var28_32 = null;
                if (!tc.isEntryEnabled()) return;
            }
            catch (Throwable th) {
                FFDCFilter.processException(th, "com.ibm.ws.webservices.admin.deploy.VerifyEJBandItsRoutersTaskImpl.verifyPartialUpdate", "559", this);
                if (!(th instanceof AdminException)) throw new AdminException(th);
                throw (AdminException)th;
            }
        }
        catch (Throwable throwable) {
            Object var28_33 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyPartialUpdate", new Object[]{contentType, operationType});
            throw throwable;
        }
        Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyPartialUpdate", new Object[]{contentType, operationType});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyRouterModule(String updatedRouterModuleName, String serverStringOfUpdatedModule, Scheduler scheduler, ApplicationDeployment appDeploy, EARFile deployedEarFile, String cellName) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.verifyRouterModule", new Object[]{updatedRouterModuleName, serverStringOfUpdatedModule});
        }
        try {
            try {
                List deployedEjbJars = deployedEarFile.getEJBJarFiles();
                for (EJBJarFile deployedEjbJar : deployedEjbJars) {
                    WSBinding wsb_from_deployedModule = WSModels.getWSBinding(deployedEjbJar.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                    if (!CommonUtils.hasJAXWSWebServices(deployedEjbJar) && !CommonUtils.hasJAXRPCWebServices(deployedEjbJar) || wsb_from_deployedModule == null) continue;
                    EList routerModules_from_deployedModule = wsb_from_deployedModule.getRouterModules();
                    String routerModuleName_from_deployedModule = null;
                    RouterModule routerModule = null;
                    boolean found_matched_routerModule = false;
                    for (int i = 0; i < routerModules_from_deployedModule.size(); ++i) {
                        routerModule = (RouterModule)routerModules_from_deployedModule.get(i);
                        routerModuleName_from_deployedModule = routerModule.getName();
                        if (!routerModuleName_from_deployedModule.equals(updatedRouterModuleName)) continue;
                        found_matched_routerModule = true;
                        break;
                    }
                    if (!found_matched_routerModule) {
                        Object[] arg = new Object[]{updatedRouterModuleName};
                        String msg = this.getResourceBundle().getString("CWSAD0063E");
                        String error = MessageFormat.format(msg, arg);
                        throw new AdminException(error);
                    }
                    EList targetMappings_from_deployedEJBModule = null;
                    ModuleDeployment moduleD = null;
                    boolean found_module_on_server = false;
                    String moduleDUri = null;
                    for (int i = 0; i < appDeploy.getModules().size(); ++i) {
                        moduleD = (ModuleDeployment)appDeploy.getModules().get(i);
                        moduleDUri = moduleD.getUri();
                        if (!moduleDUri.equals(deployedEjbJar.getURI())) continue;
                        found_module_on_server = true;
                        targetMappings_from_deployedEJBModule = moduleD.getTargetMappings();
                        break;
                    }
                    if (!found_module_on_server) continue;
                    this.compareServerTargets(scheduler, targetMappings_from_deployedEJBModule, deployedEjbJar.getURI(), updatedRouterModuleName, serverStringOfUpdatedModule, cellName);
                }
                Object var21_24 = null;
                if (!tc.isDebugEnabled()) return;
            }
            catch (Throwable th) {
                FFDCFilter.processException(th, "com.ibm.ws.webservices.admin.deploy.VerifyEJBandItsRoutersTaskImpl.verifyRouterModule", "559", this);
                if (!(th instanceof AdminException)) throw new AdminException(th);
                throw (AdminException)th;
            }
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            if (!tc.isDebugEnabled()) throw throwable;
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyRouterModule", this);
            throw throwable;
        }
        Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyRouterModule", this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyRouterModule2(String updatedRouterModuleName, String updatedRouterModuleTransportType, String serverStringOfUpdatedModule, Scheduler scheduler, String taskName, ApplicationDeployment appDeploy, EARFile deployedEarFile, String cellName) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.verifyRouterModule2", new Object[]{updatedRouterModuleName, updatedRouterModuleTransportType, serverStringOfUpdatedModule, taskName});
        }
        try {
            block13: {
                try {
                    boolean found_matched_routerModule = false;
                    if (updatedRouterModuleTransportType.equals("http")) {
                        List deployedWARs = deployedEarFile.getWARFiles();
                        String deployedWarName = null;
                        for (WARFile deployedWar : deployedWARs) {
                            deployedWarName = deployedWar.getName();
                            if (!deployedWarName.equals(updatedRouterModuleName)) continue;
                            found_matched_routerModule = true;
                            break;
                        }
                        if (!found_matched_routerModule) {
                            Object[] args = new Object[]{updatedRouterModuleName, serverStringOfUpdatedModule};
                            String msg = this.getResourceBundle().getString("CWSAD0066E");
                            String error = MessageFormat.format(msg, args);
                            throw new AdminException(error);
                        }
                        EList targetMappings_from_deployedModule = null;
                        ModuleDeployment moduleD = null;
                        boolean found_module_on_server = false;
                        String moduleDUri = null;
                        for (int i = 0; i < appDeploy.getModules().size(); ++i) {
                            moduleD = (ModuleDeployment)appDeploy.getModules().get(i);
                            moduleDUri = moduleD.getUri();
                            if (!moduleDUri.equals(updatedRouterModuleName)) continue;
                            found_module_on_server = true;
                            targetMappings_from_deployedModule = moduleD.getTargetMappings();
                            break;
                        }
                        if (found_module_on_server) {
                            this.compareServerTargets(scheduler, targetMappings_from_deployedModule, deployedWarName, updatedRouterModuleName, serverStringOfUpdatedModule, cellName);
                        }
                        break block13;
                    }
                    List deployedEJBJars = deployedEarFile.getEJBJarFiles();
                    for (EJBJarFile deployedEjbJar : deployedEJBJars) {
                        String deployedJarName = deployedEjbJar.getName();
                        WSBinding wsb_from_deployedModule = WSModels.getWSBinding(deployedEjbJar.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                        if ((CommonUtils.hasJAXWSWebServices(deployedEjbJar) || CommonUtils.hasJAXRPCWebServices(deployedEjbJar)) && wsb_from_deployedModule != null || !deployedJarName.equals(updatedRouterModuleName)) continue;
                        found_matched_routerModule = true;
                        break;
                    }
                    if (!found_matched_routerModule) {
                        Object[] args = new Object[]{updatedRouterModuleName, serverStringOfUpdatedModule};
                        String msg = this.getResourceBundle().getString("CWSAD0066E");
                        String error = MessageFormat.format(msg, args);
                        throw new AdminException(error);
                    }
                    EList targetMappings_from_deployedModule = null;
                    ModuleDeployment moduleD = null;
                    boolean found_module_on_server = false;
                    String moduleDUri = null;
                    for (int i = 0; i < appDeploy.getModules().size(); ++i) {
                        moduleD = (ModuleDeployment)appDeploy.getModules().get(i);
                        moduleDUri = moduleD.getUri();
                        if (!moduleDUri.equals(updatedRouterModuleName)) continue;
                        found_module_on_server = true;
                        targetMappings_from_deployedModule = moduleD.getTargetMappings();
                        break;
                    }
                    if (!found_module_on_server) break block13;
                    this.compareServerTargets(scheduler, targetMappings_from_deployedModule, moduleDUri, updatedRouterModuleName, serverStringOfUpdatedModule, cellName);
                }
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.webservices.admin.deploy.VerifyEJBandItsRoutersTaskImpl.verifyRouterModule2", "985", this);
                    if (!(th instanceof AdminException)) throw new AdminException(th);
                    throw (AdminException)th;
                }
            }
            Object var18_26 = null;
            if (!tc.isDebugEnabled()) return;
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyRouterModule2");
            return;
        }
        catch (Throwable throwable) {
            Object var18_27 = null;
            if (!tc.isDebugEnabled()) throw throwable;
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.verifyRouterModule2");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compareServerTargets(Scheduler scheduler, List targetMappings_from_deployedModule, String deployedModuleName, String updatedModuleName, String serverStringOfUpdatedModule, String cellName) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.compareServerTargets", new Object[]{updatedModuleName, serverStringOfUpdatedModule});
        }
        try {
            try {
                UpdateScheduler ush = null;
                boolean _partial = false;
                boolean _file = false;
                if (scheduler instanceof UpdateScheduler) {
                    ush = (UpdateScheduler)scheduler;
                    if (ush.getContentType().equals("partialapp")) {
                        _partial = true;
                    }
                    if (ush.getContentType().equals("file")) {
                        _file = true;
                    }
                }
                serverStringOfUpdatedModule = this.normalizeServerString(serverStringOfUpdatedModule);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "normalized serverStringOfUpdatedModule is " + serverStringOfUpdatedModule);
                }
                if (targetMappings_from_deployedModule != null) {
                    boolean found_same_target = false;
                    String serverStringOfDeployedModule = null;
                    for (int i = 0; i < targetMappings_from_deployedModule.size(); ++i) {
                        String sTarget;
                        if (serverStringOfDeployedModule == null || serverStringOfDeployedModule.equals("")) {
                            sTarget = VerifyEJBandItsRoutersTaskImpl._readTarget((DeploymentTargetMapping)targetMappings_from_deployedModule.get(i), cellName);
                            if (sTarget == null || sTarget.equals("")) continue;
                            serverStringOfDeployedModule = sTarget;
                            continue;
                        }
                        sTarget = VerifyEJBandItsRoutersTaskImpl._readTarget((DeploymentTargetMapping)targetMappings_from_deployedModule.get(i), cellName);
                        if (sTarget == null || sTarget.equals("")) continue;
                        serverStringOfDeployedModule = serverStringOfDeployedModule + "+" + sTarget;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Final serverStringOfDeployedModule is " + serverStringOfDeployedModule);
                    }
                    if (serverStringOfDeployedModule != null && !serverStringOfDeployedModule.equals("") && this.isTargetTheSame(serverStringOfDeployedModule.trim(), serverStringOfUpdatedModule.trim())) {
                        found_same_target = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "At This point, the comparision of target strings from updated module and deployed module are good because they are the same.");
                        }
                    }
                    if (!found_same_target) {
                        Object[] arg = new Object[]{serverStringOfDeployedModule, deployedModuleName, serverStringOfUpdatedModule, updatedModuleName};
                        String msg = null;
                        msg = _partial || _file ? this.getResourceBundle().getString("CWSAD0072E") : this.getResourceBundle().getString("CWSAD0060E");
                        String error = MessageFormat.format(msg, arg);
                        throw new AdminException(error);
                    }
                } else {
                    Object[] arg = new Object[]{updatedModuleName};
                    String msg = null;
                    msg = _partial || _file ? this.getResourceBundle().getString("CWSAD0073E") : this.getResourceBundle().getString("CWSAD0061E");
                    String error = MessageFormat.format(msg, arg);
                    throw new AdminException(error);
                }
                Object var16_20 = null;
                if (!tc.isEntryEnabled()) return;
            }
            catch (Exception ex) {
                if (!(ex instanceof AdminException)) throw new AdminException(ex);
                throw (AdminException)ex;
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.comparteTargets");
            throw throwable;
        }
        Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.comparteTargets");
    }

    protected AppNotification createNotification(String taskName, String subStatus, String warning) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.createNotification");
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.createNotification");
        }
        return new AppNotification(taskName, this.getShortName(), "InProgress", subStatus, warning);
    }

    private String getShortName() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.getShortName");
        }
        String n = this.getClass().getName();
        String result = n.substring(n.lastIndexOf(46) + 1);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.getShortName", new Object[]{result});
        }
        return result;
    }

    private String getTableKey(Hashtable _table, String routerName) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.getTableKey", new Object[]{routerName});
        }
        String result = null;
        Enumeration e = _table.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String routerName_in_key = util.getModuleURIFromUniqueName((String)key);
            if (!routerName_in_key.equals(routerName)) continue;
            result = key;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.getTablekey", new Object[]{result});
        }
        return result;
    }

    private static String _readTarget(DeploymentTargetMapping targetMapping, String cellName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl._readTarget", new Object[]{targetMapping, cellName});
        }
        String target = null;
        DeploymentTarget dt = targetMapping.getTarget();
        if (AppUtils.isEmpty((String)cellName)) {
            cellName = AppManagementImpl.getCellName();
        }
        if (dt != null) {
            if (dt instanceof ClusteredTarget) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "a cluster");
                }
                String clusterName = dt.getName();
                target = "WebSphere:cell=" + cellName + ",cluster=" + clusterName;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "a server");
                }
                String nodeName = ((ServerTarget)dt).getNodeName();
                String serverName = ((ServerTarget)dt).getName();
                target = "WebSphere:cell=" + cellName + ",node=" + nodeName + ",server=" + serverName;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl._readTarget", new Object[]{target});
        }
        return target;
    }

    private boolean isTargetTheSame(String targetsEJBJar, String targetsRouterWar) {
        boolean isSame;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.isTargetTheSame", new Object[]{targetsEJBJar, targetsRouterWar});
            }
            isSame = true;
            if (!targetsEJBJar.equals(targetsRouterWar)) {
                String[] targetsWar;
                String[] targetsJar = targetsEJBJar.split("\\+");
                if (targetsJar.length > (targetsWar = targetsRouterWar.split("\\+")).length) {
                    isSame = false;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "!isSame, more targets in EJB");
                    }
                } else {
                    int i;
                    ArrayList<String> targetsJarInList = new ArrayList<String>();
                    for (int i2 = 0; i2 < targetsJar.length; ++i2) {
                        targetsJarInList.add(this.sortTargetOrder(targetsJar[i2]));
                    }
                    ArrayList<String> targetsWarInList = new ArrayList<String>();
                    for (i = 0; i < targetsWar.length; ++i) {
                        targetsWarInList.add(this.sortTargetOrder(targetsWar[i]));
                    }
                    for (i = 0; i < targetsJarInList.size(); ++i) {
                        if (targetsWarInList.contains(targetsJarInList.get(i))) {
                            targetsWarInList.remove(targetsJarInList.get(i));
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "removed matching target:" + targetsJarInList.get(i));
                            continue;
                        }
                        isSame = false;
                        if (!tc.isEntryEnabled()) break;
                        Tr.debug(tc, "!isSame, do not find matching target in war module:" + targetsJarInList.get(i));
                        break;
                    }
                    if (isSame && targetsWarInList.size() > 0) {
                        try {
                            ConfigService cfgService;
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "RouterWar has more targets: " + targetsWarInList.size());
                            }
                            if ((cfgService = ConfigServiceFactory.getConfigService()) == null && tc.isDebugEnabled()) {
                                Tr.debug(tc, "cfgService is null...");
                            }
                            Session session = new Session();
                            Hashtable<String, String> patternTable = new Hashtable<String, String>();
                            patternTable.put("_Websphere_Config_Data_Type", "Server");
                            Hashtable scopeTable = new Hashtable();
                            block5: for (int i3 = 0; i3 < targetsWarInList.size() && isSame; ++i3) {
                                ObjectName targetON = new ObjectName((String)targetsWarInList.get(i3));
                                if (targetON.getKeyProperty("server") == null || targetON.getKeyProperty("node") == null || targetON.getKeyProperty("cell") == null) {
                                    isSame = false;
                                    if (!tc.isEntryEnabled()) break;
                                    Tr.debug(tc, "!isSame, extra war module missing server, node or cell:" + targetsWarInList.get(i3));
                                    break;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "target in war: " + targetsWarInList.get(i3));
                                }
                                patternTable.put("_Websphere_Config_Data_Display_Name", targetON.getKeyProperty("server"));
                                ObjectName patternON = new ObjectName("WebSphere", patternTable);
                                ObjectName[] serverONs = cfgService.queryConfigObjects(session, null, patternON, null);
                                if (serverONs.length == 0) {
                                    isSame = false;
                                    if (!tc.isEntryEnabled()) break;
                                    Tr.debug(tc, "!isSame, serverONs.length is 0");
                                    break;
                                }
                                String configId = "cells/" + targetON.getKeyProperty("cell") + "/nodes/" + targetON.getKeyProperty("node") + "/";
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "configId: " + configId);
                                }
                                for (int j = 0; j < serverONs.length; ++j) {
                                    String keyProperty = serverONs[j].getKeyProperty("_Websphere_Config_Data_Id");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "keyProperty: " + keyProperty + ", keyProperty.indexOf(configId)=" + keyProperty.indexOf(configId));
                                    }
                                    if (keyProperty.indexOf(configId) < 0) continue;
                                    String serverType = (String)cfgService.getAttribute(session, serverONs[j], "serverType");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "serverType: " + serverType);
                                    }
                                    if (serverType.equals("WEB_SERVER")) continue;
                                    isSame = false;
                                    if (!tc.isEntryEnabled()) continue block5;
                                    Tr.debug(tc, "!isSame, serverType not WEB_SERVER:" + serverType);
                                    continue block5;
                                }
                            }
                            cfgService.discard(session);
                        }
                        catch (Exception ex1) {
                            FFDCFilter.processException((Throwable)ex1, "com.ibm.ws.webservices.admin.deploy.VerifyEJBandItsRoutersTaskImpl.isTargetTheSame", FFDC_1, this);
                            isSame = false;
                            if (!tc.isEntryEnabled()) break block23;
                            ex1.printStackTrace();
                            Tr.debug(tc, "!isSame due to Exception:" + ex1);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.isTargetTheSame " + isSame);
        }
        return isSame;
    }

    private String sortTargetOrder(String target) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.sortTargetOrder", new Object[]{target});
        }
        StringBuffer buffer = new StringBuffer();
        try {
            ObjectName targetON = new ObjectName(target);
            buffer.append("WebSphere:");
            if (targetON.getKeyProperty("cell") != null) {
                buffer.append("cell=" + targetON.getKeyProperty("cell"));
            }
            if (targetON.getKeyProperty("node") != null) {
                buffer.append(",");
                buffer.append("node=" + targetON.getKeyProperty("node"));
            }
            if (targetON.getKeyProperty("server") != null) {
                buffer.append(",");
                buffer.append("server=" + targetON.getKeyProperty("server"));
            }
            if (targetON.getKeyProperty("cluster") != null) {
                buffer.append(",");
                buffer.append("cluster=" + targetON.getKeyProperty("cluster"));
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.sortTargetOrder", new Object[]{buffer.toString()});
        }
        return buffer.toString();
    }

    private String normalizeServerString(String serverString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.normalizeServerString", serverString);
        }
        String result = null;
        String[] targets = serverString.split("\\+");
        for (int i = 0; i < targets.length; ++i) {
            String target = targets[i];
            if (result == null || result.equals("")) {
                if (target == null || target.equals("")) continue;
                result = target.split("\\-WebSphere")[0];
                continue;
            }
            if (target == null || target.equals("")) continue;
            String newTarget = target.split("\\-WebSphere")[0];
            result = result + "+" + newTarget;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.normalizeServerString", result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List serverStringOfModule(RepositoryContext rc, Scheduler scheduler, String moduleName) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "VerifyEJBandItsRoutersTaskImpl.serverStringOfModule", moduleName);
        }
        EList result = null;
        try {
            try {
                ApplicationDeployment appDeploy = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc);
                EList moduleList = appDeploy.getModules();
                boolean found = false;
                Iterator it = moduleList.iterator();
                while (it.hasNext() && !found) {
                    ModuleDeployment moduleDeploy = (ModuleDeployment)it.next();
                    String _moduleName = moduleDeploy.getUri();
                    if (!moduleName.equals(_moduleName)) continue;
                    found = true;
                    result = moduleDeploy.getTargetMappings();
                }
                Object var12_12 = null;
                if (!tc.isDebugEnabled()) return result;
            }
            catch (Exception ex) {
                if (!(ex instanceof AdminException)) throw new AdminException(ex);
                throw (AdminException)ex;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (!tc.isDebugEnabled()) throw throwable;
            Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.serverStringOfModule", new Object[]{moduleName, result});
            throw throwable;
        }
        Tr.exit(tc, "VerifyEJBandItsRoutersTaskImpl.serverStringOfModule", new Object[]{moduleName, result});
        return result;
    }
}

