/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.admin.deploy.ServiceIndexDataBuilder;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexReader;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexWriter;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

class ServiceIndexServerTaskImpl {
    private static TraceComponent tc = Tr.register(ServiceIndexServerTaskImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String SOURCE_FILE = this.getClass().getName();
    private ResourceBundle _resourceBundle = null;
    private RepositoryContext _deployContext = null;
    private int _operation = 0;
    private Map _existingIndex = new Hashtable();

    ServiceIndexServerTaskImpl() {
    }

    ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    void setResourceBundle(ResourceBundle resourceBundle) {
        this._resourceBundle = resourceBundle;
    }

    void setDeployContext(RepositoryContext deployContext) {
        this._deployContext = deployContext;
    }

    void setOperation(int operation) {
        this._operation = operation;
    }

    void setExistingIndex(Map existing) {
        this._existingIndex = existing == null ? new Hashtable() : existing;
    }

    void listWebServices(EARFile earFile, Scheduler scheduler) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTaskImpl.listWebServices(EARFile)");
        }
        List moduleFiles = earFile.getModuleFiles();
        boolean isWsnService = this._deployContext.isAvailable("META-INF/com.ibm.ws.sib.wsn.Configuration.props");
        for (ModuleFile mf : moduleFiles) {
            if (!mf.isWARFile() && !mf.isEJBJarFile()) continue;
            this.listWebServices(mf, scheduler, isWsnService);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexServerTaskImpl.listWebServices(EARFile)");
        }
    }

    private String getMetaDirectory(ModuleFile mf) {
        return mf.isWARFile() ? "WEB-INF" : "META-INF";
    }

    void listWebServices(ModuleFile mf, Scheduler scheduler) throws Exception {
        this.listWebServices(mf, scheduler, this._deployContext.isAvailable("META-INF/com.ibm.ws.sib.wsn.Configuration.props"));
    }

    void listWebServices(ModuleFile mf, Scheduler scheduler, boolean isWsnService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile), isWsnService=" + isWsnService);
        }
        String filename = mf.getName() + File.separator + this.getMetaDirectory(mf) + File.separator + "servicesIndex.xml";
        HashMap serviceMap = new HashMap();
        HashMap clientServiceMap = new HashMap();
        this.getExistingIndexes(mf.getName(), filename, serviceMap, clientServiceMap);
        this.removeAllJAXWS(serviceMap, clientServiceMap);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile), calling ServiceIndexDataBuilder.getWSData");
        }
        ServiceIndexDataBuilder.getWSData(mf, serviceMap, clientServiceMap);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile), getWSData returns");
        }
        if (!serviceMap.isEmpty() || !clientServiceMap.isEmpty()) {
            this.activationPlan(scheduler, mf, "WS_JaxWsWebService");
            this.activationPlan(scheduler, mf, "WS_WebServiceInit");
            if (isWsnService && serviceMap != null) {
                this.setWSNServiceType(serviceMap);
            }
            OutputStream os = this._deployContext.getOutputStream(filename);
            ServiceIndexWriter.write(os, serviceMap, clientServiceMap);
            os.close();
            this._deployContext.notifyChanged(this._operation, filename);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile), find services or clients, notify change");
            }
        } else {
            this._deployContext.delete(filename);
            this._deployContext.notifyChanged(2, filename);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile), find no service or client, notify change");
            }
        }
        String sib_ws_file = mf.getName() + File.separator + "META-INF/services/com.ibm.ws.webservices.engine.EngineConfigurationFactory";
        boolean found_ws_for_sib = mf.containsFile("META-INF/services/com.ibm.ws.webservices.engine.EngineConfigurationFactory");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile), find SIB file? " + found_ws_for_sib);
        }
        if (CommonUtils.hasJAXRPCWebServices(mf, scheduler) || found_ws_for_sib) {
            this.activationPlan(scheduler, mf, "WS_JaxRpcWebService");
            this.activationPlan(scheduler, mf, "WS_WebServiceInit");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void activationPlan(Scheduler scheduler, ModuleFile mf, String applicationType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activationPlan()", new Object[]{mf.getName(), applicationType});
        }
        try {
            try {
                ArrayList<ObjectName> components;
                Hashtable actPlan = (Hashtable)scheduler.getProperties().get("activation.plan.default");
                if (actPlan == null) {
                    actPlan = new Hashtable();
                    scheduler.getProperties().put("activation.plan.default", actPlan);
                }
                String uri = null;
                if (scheduler instanceof UpdateScheduler) {
                    UpdateScheduler ush = (UpdateScheduler)scheduler;
                    uri = ush.getContentURI();
                } else {
                    uri = mf.getOriginalURI();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uri is " + uri);
                }
                if ((components = (ArrayList<ObjectName>)actPlan.get(uri)) == null) {
                    components = new ArrayList<ObjectName>();
                    actPlan.put(uri, components);
                }
                ObjectName on = new ObjectName("WebSphere", "specname", applicationType);
                components.add(on);
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, this.SOURCE_FILE + ".activationPlan", FFDC_ID_1);
                Object var9_10 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "activationPlan()", new Object[]{mf.getName(), applicationType});
                return;
            }
            Object var9_9 = null;
            if (!tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "activationPlan()", new Object[]{mf.getName(), applicationType});
            throw throwable;
        }
        Tr.exit(tc, "activationPlan()", new Object[]{mf.getName(), applicationType});
    }

    private void getExistingIndexes(String mfName, String filename, Map serviceMap, Map clientServiceMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExistingIndexes ", new Object[]{mfName, filename});
        }
        try {
            InputStream is = this._deployContext.getInputStream(filename);
            if (is != null) {
                ServiceIndexReader reader = new ServiceIndexReader(is);
                Map[] maps = reader.read(true);
                is.close();
                if (maps != null && maps[0] != null) {
                    serviceMap.putAll(maps[0]);
                }
                if (maps != null && maps[1] != null) {
                    clientServiceMap.putAll(maps[1]);
                }
            } else {
                Map[] maps = (Map[])this._existingIndex.get(mfName);
                if (maps != null && maps[0] != null) {
                    serviceMap.putAll(maps[0]);
                }
                if (maps != null && maps[1] != null) {
                    clientServiceMap.putAll(maps[1]);
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.SOURCE_FILE + ".getExistingIndexes", FFDC_ID_1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExistingIndexes", new Object[]{serviceMap, clientServiceMap});
        }
    }

    private void removeAllJAXWS(Map serviceMap, Map clientServiceMap) {
        WebServiceBean wsBean;
        String key;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExistingIndexes ");
        }
        Iterator keys = serviceMap.keySet().iterator();
        while (keys.hasNext()) {
            key = (String)keys.next();
            wsBean = (WebServiceBean)serviceMap.get(key);
            if (!"JAX-WS".equals(wsBean.getType())) continue;
            keys.remove();
        }
        keys = clientServiceMap.keySet().iterator();
        while (keys.hasNext()) {
            key = (String)keys.next();
            wsBean = (WebServiceBean)clientServiceMap.get(key);
            if (!"JAX-WS".equals(wsBean.getType())) continue;
            keys.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExistingIndexes ");
        }
    }

    private void setWSNServiceType(Map serviceMap) {
        for (Map.Entry entry : serviceMap.entrySet()) {
            WebServiceBean wsObj = (WebServiceBean)entry.getValue();
            wsObj.setType("JAX-WS (WSN)");
        }
    }
}

