/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTaskImpl;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class ServiceIndexServerTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(ServiceIndexServerTask.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public boolean performTask() throws AdminException {
        Exception e22;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTask.performTask()");
        }
        String[] tempDirToBeRemoved = new String[1];
        String[] updateDirToBeRemoved = new String[1];
        EARFile ear = null;
        try {
            RepositoryContext deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            ServiceIndexServerTaskImpl taskImpl = new ServiceIndexServerTaskImpl();
            taskImpl.setResourceBundle(this.getResourceBundle());
            taskImpl.setDeployContext(deployContext);
            taskImpl.setOperation(this.scheduler instanceof InstallScheduler ? 0 : 1);
            taskImpl.setExistingIndex((Map)this.scheduler.getProperties().get("ServiceIndexTask.ServiceIndexMap"));
            if (this.scheduler instanceof InstallScheduler) {
                ear = ((InstallScheduler)this.scheduler).getEarFile(true, true);
                if (ear != null) {
                    taskImpl.listWebServices(ear, this.scheduler);
                }
            } else if (this.scheduler instanceof UpdateScheduler) {
                UpdateScheduler ush = (UpdateScheduler)this.scheduler;
                if (("add".equals(ush.getOperation()) || "update".equals(ush.getOperation())) && ush.getContentType().equals("modulefile")) {
                    ModuleFile mf = (ModuleFile)ush.getContentAsArchive(true, true);
                    taskImpl.listWebServices(mf, this.scheduler);
                } else if (!"delete".equals(ush.getOperation())) {
                    ear = CommonUtils.getEar(this.scheduler, this.getResourceBundle());
                    if (ear != null) {
                        ear.getOptions().setUseJavaReflection(true);
                        if (this.scheduler instanceof UpdateScheduler) {
                            UpdateScheduler upsch = (UpdateScheduler)this.scheduler;
                            String contentType = upsch.getContentType();
                            String operationType = upsch.getOperation();
                            if (contentType.equals("partialapp")) {
                                ear = CommonUtils.getMergeEar(upsch, ear, deployContext, this.getResourceBundle(), tempDirToBeRemoved, updateDirToBeRemoved, "ServiceIndexServerTask");
                            }
                            if (ear != null) {
                                ear.getOptions().setUseJavaReflection(true);
                                taskImpl.listWebServices(ear, this.scheduler);
                                CommonUtils.closeEar(ear, this.scheduler);
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServiceIndexServerTask was unable to obtain EARFile for update of application, " + this.scheduler.getAppName() + ", perhaps due to using zeroEarCopy or zeroBinaryCopy options during the install");
                    }
                }
            }
            AppNotification appNotify = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            this.scheduler.propagateTaskEvent(appNotify);
            bl = true;
            Object var11_12 = null;
        }
        catch (Throwable th) {
            try {
                FFDCFilter.processException(th, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "172", (Object)this);
                this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), th.toString()}));
                if (this.scheduler instanceof UpdateScheduler && ear != null) {
                    ear.close();
                }
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
            }
            catch (Throwable throwable) {
                block37: {
                    Exception e22;
                    Object var11_13 = null;
                    if (tempDirToBeRemoved[0] != null && tempDirToBeRemoved[0].length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Remove temporary serviceIndexServer directory " + tempDirToBeRemoved[0]);
                        }
                        try {
                            AppUtils.deleteDirTree((String)tempDirToBeRemoved[0]);
                        }
                        catch (Exception e22) {
                            FFDCFilter.processException((Throwable)e22, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "186", (Object)this);
                            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), e22.toString()}));
                        }
                    }
                    if (updateDirToBeRemoved[0] != null && updateDirToBeRemoved[0].length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Remove update serviceIndexServer directory " + updateDirToBeRemoved[0]);
                        }
                        try {
                            AppUtils.deleteDirTree((String)updateDirToBeRemoved[0]);
                        }
                        catch (Exception e22) {
                            FFDCFilter.processException((Throwable)e22, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "200", (Object)this);
                            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), e22.toString()}));
                        }
                    }
                    if (!tc.isEntryEnabled()) break block37;
                    Tr.exit(tc, "ServiceIndexServerTask.performTask()");
                }
                throw throwable;
            }
        }
        if (tempDirToBeRemoved[0] != null && tempDirToBeRemoved[0].length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove temporary serviceIndexServer directory " + tempDirToBeRemoved[0]);
            }
            try {
                AppUtils.deleteDirTree((String)tempDirToBeRemoved[0]);
            }
            catch (Exception e22) {
                FFDCFilter.processException((Throwable)e22, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "186", (Object)this);
                this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), e22.toString()}));
            }
        }
        if (updateDirToBeRemoved[0] != null && updateDirToBeRemoved[0].length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove update serviceIndexServer directory " + updateDirToBeRemoved[0]);
            }
            try {
                AppUtils.deleteDirTree((String)updateDirToBeRemoved[0]);
            }
            catch (Exception e22) {
                FFDCFilter.processException((Throwable)e22, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "200", (Object)this);
                this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), e22.toString()}));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexServerTask.performTask()");
        }
        return bl;
    }
}

