/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexReader;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ServiceIndexReadTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(ServiceIndexServerTask.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private RepositoryContext _deployContext = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    protected String SOURCE_FILE = ((Object)((Object)this)).getClass().getName();

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexReadTask.performTask()");
        }
        EARFile ear = null;
        try {
            String update = (String)this.scheduler.getProperties().get("contenttype");
            String fullUpdate = (String)this.scheduler.getProperties().get("app");
            if (!(this.scheduler instanceof UninstallSchedulerImpl) || update != null || fullUpdate != null) {
                this._deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
                ear = ConfigRepoHelper.getEarFileForApp((WorkSpace)this.scheduler.getWorkSpace(), (RepositoryContext)this._deployContext, (ResourceBundle)this.getResourceBundle(), (boolean)true);
                if (ear != null) {
                    Map moduleServices = this.readIndexFile(ear);
                    if (moduleServices != null && !moduleServices.isEmpty()) {
                        this.scheduler.getProperties().put("ServiceIndexTask.ServiceIndexMap", moduleServices);
                    }
                    ear.close();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ServiceIndexReadTask.performTask()");
            }
            return true;
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, this.SOURCE_FILE + ".performTask", FFDC_ID_1, (Object)this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), th.toString()}));
            if (ear != null) {
                ear.close();
            }
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
        }
    }

    private Map[] readIndexFile(ModuleFile mf) throws Exception {
        String filename = mf.getName() + File.separator + this.getMetaDirectory(mf) + File.separator + "servicesIndex.xml";
        Map[] services = null;
        try {
            File fileobj = new File(this._deployContext.getPath() + File.separator + filename);
            if (fileobj.exists()) {
                InputStream is = this._deployContext.getInputStream(filename);
                ServiceIndexReader reader = new ServiceIndexReader(is);
                services = reader.read(true);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, this.SOURCE_FILE + ".readIndexFile", FFDC_ID_2, (Object)this);
        }
        return services;
    }

    private String getMetaDirectory(ModuleFile mf) {
        return mf.isWARFile() ? "WEB-INF" : "META-INF";
    }

    private Map readIndexFile(EARFile earFile) throws Exception {
        Hashtable<String, Map[]> moduleServices = new Hashtable<String, Map[]>();
        List moduleFiles = earFile.getModuleFiles();
        for (ModuleFile mf : moduleFiles) {
            Map[] services = this.readIndexFile(mf);
            if (services == null || (services[0] == null || services[0].isEmpty()) && (services[1] == null || services[1].isEmpty())) continue;
            moduleServices.put(mf.getName(), services);
        }
        return moduleServices;
    }
}

