/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.webservices.admin.deploy.VerifyEJBandItsRoutersTaskImpl;
import com.ibm.ws.webservices.admin.utils.AppMgmtUtils;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import com.ibm.wsspi.webservices.models.WSModels;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class DeploymentValidation
implements AppManagementExtensions.AppValidationHelper,
AppManagementExtensions.AppValidationHelper2 {
    private static TraceComponent tc = Tr.register(DeploymentValidation.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private ResourceBundle _rb = null;
    public static String taskName = "DeploymentValidation";

    private void setResourceBundle(ResourceBundle rb) {
        this._rb = rb;
    }

    private ResourceBundle getResourceBundle() {
        return this._rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void validateOperation_Required(Scheduler scheduler, List results) {
        block54: {
            Exception e322;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DeploymentValidation.validateOperation_Required");
            }
            EARFile ear = null;
            String[] tempDirToBeRemoved = new String[1];
            String[] updateDirToBeRemoved = new String[1];
            try {
                block48: {
                    ResourceBundle rb;
                    Session session = new Session(scheduler.getWorkSpace().getUserName(), true);
                    Locale locale = (Locale)scheduler.getProperties().get("app.client.locale");
                    if (locale == null) {
                        locale = Locale.getDefault();
                    }
                    if ((rb = this.getResourceBundle()) == null) {
                        rb = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", locale);
                        this.setResourceBundle(rb);
                    }
                    String customBndVersion = null;
                    if (scheduler instanceof InstallScheduler) {
                        ear = CommonUtils.getEar(scheduler, rb);
                        if (ear != null) {
                            this.validate_common(ear, scheduler, locale, session, customBndVersion, results);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unable to get an EARFile in installation task");
                        }
                        break block48;
                    }
                    if (scheduler instanceof UpdateScheduler) {
                        UpdateScheduler upsch = (UpdateScheduler)scheduler;
                        if (upsch.getContentType().equals("modulefile")) {
                            ModuleFile mf;
                            block49: {
                                mf = (ModuleFile)upsch.getContentAsArchive(true, true);
                                String appName = scheduler.getAppName();
                                Properties assetProps = new Properties();
                                assetProps.put("application", appName);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "workspaceID=" + scheduler.getWorkSpace().getUserName() + "; appName=" + appName);
                                }
                                try {
                                    customBndVersion = PolicySetBindingCommandUtil.getAssetBindingVersion(session, assetProps);
                                }
                                catch (Exception e2) {
                                    if (!tc.isDebugEnabled()) break block49;
                                    Tr.debug(tc, "Receiving exception during obtaining binding version in module update: " + CommonUtils.getExceptionStack(e2));
                                }
                            }
                            this.validate(mf, scheduler, locale, session, customBndVersion, results);
                            break block48;
                        }
                        if (!"delete".equals(upsch.getOperation())) {
                            ear = CommonUtils.getEar(scheduler, rb);
                            RepositoryContext deployContext = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
                            if ((ear = CommonUtils.getMergeEar(upsch, ear, deployContext, rb, tempDirToBeRemoved, updateDirToBeRemoved, taskName)) != null) {
                                this.validate_common(ear, scheduler, locale, session, customBndVersion, results);
                            }
                            CommonUtils.closeEar(ear, scheduler);
                        }
                        break block48;
                    }
                    if (!(scheduler instanceof EditSchedulerImpl)) break block48;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Edit Scheduler");
                    }
                    if ((ear = CommonUtils.getEar(scheduler, rb)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Edit Schduler: get an EARFile in Edit task");
                        }
                        this.validate_common(ear, scheduler, locale, session, customBndVersion, results);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Edit Schduler: call VerifyEJBandItsRoutersTaskImpl to verify router module");
                        }
                        VerifyEJBandItsRoutersTaskImpl taskImpl = new VerifyEJBandItsRoutersTaskImpl();
                        taskImpl.setResourceBundle(this.getResourceBundle());
                        RepositoryContext deployContext = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
                        taskImpl.setDeployContext(deployContext);
                        try {
                            taskImpl.verifyInstallOrEdit(scheduler, ear, locale, taskName);
                        }
                        catch (AdminException ex) {
                            results.add(ex.getMessage());
                        }
                        CommonUtils.closeEar(ear, scheduler);
                        break block48;
                    }
                    if (!tc.isDebugEnabled()) break block48;
                    Tr.debug(tc, "unable to get an EARFile in Edit task");
                }
                Object var16_20 = null;
            }
            catch (Throwable throwable) {
                Exception e322;
                Object var16_22 = null;
                if (tempDirToBeRemoved[0] != null && tempDirToBeRemoved[0].length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Remove temporary deploymentValidation directory " + tempDirToBeRemoved[0]);
                    }
                    try {
                        AppUtils.deleteDirTree((String)tempDirToBeRemoved[0]);
                    }
                    catch (Exception e322) {
                        FFDCFilter.processException(e322, this.className, FFDC_ID_1);
                    }
                }
                if (updateDirToBeRemoved[0] != null && updateDirToBeRemoved[0].length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Remove update deploymentValidation directory " + updateDirToBeRemoved[0]);
                    }
                    try {
                        AppUtils.deleteDirTree((String)updateDirToBeRemoved[0]);
                    }
                    catch (Exception e322) {
                        FFDCFilter.processException(e322, this.className, FFDC_ID_1);
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "DeploymentValidation.validateOperation_Required");
                }
                throw throwable;
            }
            if (tempDirToBeRemoved[0] != null && tempDirToBeRemoved[0].length() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Remove temporary deploymentValidation directory " + tempDirToBeRemoved[0]);
                }
                try {
                    AppUtils.deleteDirTree((String)tempDirToBeRemoved[0]);
                }
                catch (Exception e322) {
                    FFDCFilter.processException(e322, this.className, FFDC_ID_1);
                }
            }
            if (updateDirToBeRemoved[0] != null && updateDirToBeRemoved[0].length() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Remove update deploymentValidation directory " + updateDirToBeRemoved[0]);
                }
                try {
                    AppUtils.deleteDirTree((String)updateDirToBeRemoved[0]);
                }
                catch (Exception e322) {
                    FFDCFilter.processException(e322, this.className, FFDC_ID_1);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DeploymentValidation.validateOperation_Required");
            }
            break block54;
            {
                catch (Throwable th) {
                    Exception e322;
                    FFDCFilter.processException(th, this.className, FFDC_ID_1);
                    if (scheduler instanceof UpdateScheduler && ear != null) {
                        ear.close();
                    }
                    Object var16_21 = null;
                    if (tempDirToBeRemoved[0] != null && tempDirToBeRemoved[0].length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Remove temporary deploymentValidation directory " + tempDirToBeRemoved[0]);
                        }
                        try {
                            AppUtils.deleteDirTree((String)tempDirToBeRemoved[0]);
                        }
                        catch (Exception e322) {
                            FFDCFilter.processException(e322, this.className, FFDC_ID_1);
                        }
                    }
                    if (updateDirToBeRemoved[0] != null && updateDirToBeRemoved[0].length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Remove update deploymentValidation directory " + updateDirToBeRemoved[0]);
                        }
                        try {
                            AppUtils.deleteDirTree((String)updateDirToBeRemoved[0]);
                        }
                        catch (Exception e322) {
                            FFDCFilter.processException(e322, this.className, FFDC_ID_1);
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "DeploymentValidation.validateOperation_Required");
                    }
                }
            }
        }
    }

    public void validateOperation_Optional(Scheduler arg0, List arg1) {
    }

    private void validate_common(EARFile ear, Scheduler scheduler, Locale locale, Session session, String customBndVersion, List results) throws Exception {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DeploymentValidation.validate_common");
            }
            ear.getOptions().setUseJavaReflection(true);
            try {
                customBndVersion = PolicySetBindingCommandUtil.getAssetBindingVersion((org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile)ear);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Receiving exception during obtaining binding version: " + CommonUtils.getExceptionStack(e));
            }
        }
        this.validate(ear, scheduler, locale, session, customBndVersion, results);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate_common");
        }
    }

    private void validate(EARFile ear, Scheduler scheduler, Locale locale, Session session, String customBndVersion, List results) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(EARFile)");
        }
        ArrayList nodes = null;
        EList mRefs = ear.getModuleRefs();
        for (ModuleRef mRef : mRefs) {
            ModuleFile mf = mRef.getModuleFile();
            if (!mf.isWARFile() && !mf.isEJBJarFile()) continue;
            if (scheduler instanceof UpdateScheduler && !((UpdateScheduler)scheduler).getContentType().equals("modulefile") && !"delete".equals(((UpdateScheduler)scheduler).getOperation())) {
                RepositoryContext rc = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
                nodes = new ArrayList();
                List targets = this.getServerStringOfModule(rc, scheduler, mRef.getUri());
                for (int i = 0; i < targets.size(); ++i) {
                    this._readNode((DeploymentTargetMapping)targets.get(i), rc.getParent().getParent().getName(), nodes, session);
                }
            } else {
                nodes = AppDeploymentUtil.getTargetNodes((Scheduler)scheduler, (String)mRef.getUri(), (String)mRef.getDeploymentDescriptor().eResource().getURI().toString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validating " + mf.getName() + " for these nodes, " + nodes);
            }
            this.validate(mf, scheduler, mf.getName(), nodes, locale, session, customBndVersion, results);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(EARFile)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getServerStringOfModule(RepositoryContext rc, Scheduler scheduler, String moduleName) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "DeploymentValidation.getServerStringOfModule", moduleName);
        }
        List result = new ArrayList();
        try {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getServerStringOfModule(), repositorycontext path = " + rc.getPath());
                }
                ApplicationDeployment appDeploy = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc);
                EList moduleList = appDeploy.getModules();
                boolean found = false;
                Iterator it = moduleList.iterator();
                while (it.hasNext() && !found) {
                    ModuleDeployment moduleDeploy = (ModuleDeployment)it.next();
                    String _moduleName = moduleDeploy.getUri();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getServerStringOfModule(), moduleName: " + moduleName);
                    }
                    if (!moduleName.equals(_moduleName)) continue;
                    found = true;
                    result = moduleDeploy.getTargetMappings();
                }
                Object var12_12 = null;
                if (!tc.isDebugEnabled()) return result;
            }
            catch (Exception ex) {
                if (!(ex instanceof AdminException)) throw new AdminException(ex);
                throw (AdminException)ex;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (!tc.isDebugEnabled()) throw throwable;
            Tr.exit(tc, "DeploymentValidation.getServerStringOfModule", new Object[]{moduleName, result});
            throw throwable;
        }
        Tr.exit(tc, "DeploymentValidation.getServerStringOfModule", new Object[]{moduleName, result});
        return result;
    }

    private void _readNode(DeploymentTargetMapping targetMapping, String cellName, List nodes, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation._readNode", new Object[]{targetMapping, cellName});
        }
        String target = null;
        String nodeName = null;
        DeploymentTarget dt = targetMapping.getTarget();
        if (AppUtils.isEmpty((String)cellName)) {
            cellName = AppManagementImpl.getCellName();
        }
        if (dt != null) {
            if (dt instanceof ClusteredTarget) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "a cluster");
                }
                String clusterName = dt.getName();
                target = "WebSphere:cell=" + cellName + ",cluster=" + clusterName;
                List<ObjectName> aList = AppMgmtUtils.getClusterMembers(target, session);
                for (ObjectName obj : aList) {
                    nodeName = obj.getKeyProperty("node");
                    if (nodeName == null || nodeName.equals("")) continue;
                    nodes.add(nodeName);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "a server");
                }
                if ((nodeName = ((ServerTarget)dt).getNodeName()) != null && !nodeName.equals("")) {
                    nodes.add(nodeName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation._readNode", new Object[]{nodes});
        }
    }

    private void validate(ModuleFile mf, Scheduler scheduler, Locale locale, Session session, String customBndVersion, List results) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(ModuleFile)");
        }
        String uri = ((UpdateScheduler)scheduler).getContentURI();
        List nodes = AppDeploymentUtil.getTargetNodes((Scheduler)scheduler, (String)uri, (String)mf.getDeploymentDescriptorUri());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validating " + uri + " for these nodes, " + nodes);
        }
        this.validate(mf, scheduler, uri, nodes, locale, session, customBndVersion, results);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(ModuleFile)");
        }
    }

    private void validate(ModuleFile mf, Scheduler scheduler, String mfName, List nodes, Locale locale, Session session, String customBndVersion, List results) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(ModuleFile)", new Object[]{mfName});
        }
        boolean jaxwsType = CommonUtils.hasJAXWSWebServices(mf, scheduler);
        boolean jaxrpcType = false;
        String moduleType = null;
        if (jaxwsType) {
            moduleType = "jaxwsType";
        } else {
            jaxrpcType = CommonUtils.hasJAXRPCWebServices(mf, scheduler);
            if (jaxrpcType) {
                moduleType = "jaxrpcType";
            }
        }
        ManagedObjectMetadataHelper helper = DeploymentValidation.getWorkSpace(session).getMetadataHelper();
        String node2 = null;
        String managedNode2 = null;
        List managedNodes = this.getManagedNodes();
        block0: for (String node2 : nodes) {
            if (customBndVersion != null && !customBndVersion.equals("")) {
                this.validateCustomBinding(helper, locale, node2, mf, mfName, moduleType, customBndVersion, results);
            }
            if (!jaxwsType && !jaxrpcType) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module file, " + mfName + ", contains " + moduleType);
            }
            this.validateEJB(mfName, helper, locale, mf, moduleType, results);
            if (managedNodes == null || managedNodes.size() <= 0) continue;
            for (String managedNode2 : managedNodes) {
                if (!managedNode2.equals(node2)) continue;
                this.validate(helper, locale, node2, mf, mfName, moduleType, results);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(ModuleFile)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validate(ManagedObjectMetadataHelper helper, Locale locale, String node, ModuleFile mf, String mfName, String moduleType, List results) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(helper, locale, node, mf, moduleType, results)", new Object[]{node, mfName, moduleType});
        }
        try {
            block8: {
                try {
                    SortedMap productMap = helper.getNodeProductVersions(node);
                    String baseVersion = helper.getNodeBaseProductVersion(node);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Product map for node, " + node + ", is " + productMap);
                        Tr.debug(tc, "baseVersion=" + baseVersion);
                    }
                    if (mf.isWARFile()) {
                        if (!moduleType.equals("jaxwsType") || productMap.get("WS FEP") != null || Utils.compareVersions((String)baseVersion, (String)"7.0.0") >= 0) break block8;
                        this.addWarning(mfName, "warModuleType", node, locale, results, "CWSAD0016W");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Node, " + node + ", doesn't contain WSFEP or 7.0");
                        }
                        break block8;
                    }
                    if (!mf.isEJBJarFile() || !moduleType.equals("jaxwsType") || Utils.compareVersions((String)baseVersion, (String)"7.0.0") >= 0 || !CommonUtils.hasJAXWSWebServices(mf, true) && productMap.get("WS FEP") != null) break block8;
                    this.addWarning(mfName, "jarModuleType", node, locale, results, "CWSAD0064W");
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Node, " + node + ", doesn't contain 7.0 or above");
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.className, FFDC_ID_1);
                    Object var11_12 = null;
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "DeploymentValidation.validate(helper, locale, node, mf, moduleType, results)", new Object[]{node, mf.getName(), moduleType});
                    return;
                }
            }
            Object var11_11 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "DeploymentValidation.validate(helper, locale, node, mf, moduleType, results)", new Object[]{node, mf.getName(), moduleType});
            return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "DeploymentValidation.validate(helper, locale, node, mf, moduleType, results)", new Object[]{node, mf.getName(), moduleType});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateEJB(String mfName, ManagedObjectMetadataHelper helper, Locale locale, ModuleFile mf, String moduleType, List results) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validateEJB(helper, locale, mf, moduleType, results)", new Object[]{mfName, moduleType});
        }
        try {
            block5: {
                try {
                    WSBinding wsb;
                    if (!mf.isEJBJarFile() || (wsb = WSModels.getWSBinding(((EJBJarFile)mf).getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi")) == null || !moduleType.equals("jaxwsType") || ((EJBJarFile)mf).getDeploymentDescriptor().getVersionID() >= 30) break block5;
                    this.addWarning(mfName, "jarModuleType", null, locale, results, "CWSAD0071W");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "EJB is not supported as a JAX-WS bean if it is not EJB 3.0.");
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.className, FFDC_ID_1);
                    Object var9_10 = null;
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "DeploymentValidation.validateEJB(helper, locale, mf, moduleType, results)", new Object[]{mfName, moduleType});
                    return;
                }
            }
            Object var9_9 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "DeploymentValidation.validateEJB(helper, locale, mf, moduleType, results)", new Object[]{mfName, moduleType});
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "DeploymentValidation.validateEJB(helper, locale, mf, moduleType, results)", new Object[]{mfName, moduleType});
            throw throwable;
        }
    }

    private void addWarning(String mfName, String moduleType, String node, Locale locale, List results, String errorCode) {
        ResourceBundle bundle;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.addWarning(mf, node, locale, results)", new Object[]{node, mfName, moduleType, errorCode});
        }
        if ((bundle = this.getResourceBundle()) == null) {
            bundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", locale);
        }
        String message = bundle.getString(errorCode);
        String warning = MessageFormat.format(message, mfName, node);
        results.add(warning);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.addWarning(mf, node, locale, results)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getManagedNodes() throws Exception {
        List managedNodes;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DeploymentValidation.getManagedNodes()");
            }
            managedNodes = null;
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            if (cmdMgr != null) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = new Session();
                try {
                    try {
                        AdminCommand cmd = cmdMgr.createCommand("listManagedNodes");
                        cmd.setConfigSession(session);
                        cmd.execute();
                        CommandResult res = cmd.getCommandResult();
                        if (!res.isSuccessful()) {
                            throw new Exception("failure during");
                        }
                        managedNodes = (List)res.getResult();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, this.className, FFDC_ID_1);
                        Tr.error(tc, "Exception: " + e.getMessage());
                        Object var8_9 = null;
                        configService.discard(session);
                        break block8;
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    configService.discard(session);
                    throw throwable;
                }
                configService.discard(session);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.getManagedNodes()");
        }
        return managedNodes;
    }

    public void isApplicationDeployable(String nodeName, String clusterName, String appName, EARFile ear, String workspaceID, Locale locale, List errors) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.isApplicationDeployable()", new Object[]{nodeName, clusterName, appName});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodName = " + nodeName + ", clusterName = " + clusterName + ", appName = " + appName + ", workspaceID = " + workspaceID);
        }
        try {
            if (ear != null) {
                ear.getOptions().setUseJavaReflection(true);
                this.validate(nodeName, clusterName, appName, ear, workspaceID, locale, errors);
                ear.close();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EARFile is null");
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, this.className, FFDC_ID_1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.isApplicationDeployable()");
        }
    }

    private void validate(String nodeName, String clusterName, String appName, EARFile ear, String workspaceID, Locale locale, List errors) throws Exception {
        String customBndVersion;
        Session session;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DeploymentValidation.validate(nodeName)", new Object[]{nodeName, clusterName, appName});
            }
            Properties assetProps = new Properties();
            assetProps.put("application", appName);
            session = new Session(workspaceID, true);
            customBndVersion = null;
            try {
                customBndVersion = PolicySetBindingCommandUtil.getAssetBindingVersion(session, assetProps);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Receving exception while getting binding version: " + CommonUtils.getExceptionStack(e));
            }
        }
        EList mRefs = ear.getModuleRefs();
        for (ModuleRef mRef : mRefs) {
            ModuleFile mf = mRef.getModuleFile();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validating " + mf.getName() + " for node " + nodeName + " and/or cluster " + clusterName);
            }
            this.validate(mf, nodeName, clusterName, mf.getName(), workspaceID, locale, session, customBndVersion, errors);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(nodeName)");
        }
    }

    private void validate(ModuleFile mf, String nodeName, String clusterName, String mfName, String workspaceID, Locale locale, Session session, String customBndVersion, List errors) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(ModuleFile, nodeName)", new Object[]{mfName, nodeName, customBndVersion, clusterName});
        }
        boolean jaxwsType = CommonUtils.hasJAXWSWebServices(mf);
        boolean jaxrpcType = false;
        String moduleType = null;
        if (jaxwsType) {
            moduleType = "jaxwsType";
        } else {
            jaxrpcType = CommonUtils.hasJAXRPCWebServices(mf);
            if (jaxrpcType) {
                moduleType = "jaxrpcType";
            }
        }
        ManagedObjectMetadataHelper helper = DeploymentValidation.getWorkSpace(session).getMetadataHelper();
        if (customBndVersion != null && !customBndVersion.equals("")) {
            this.validateCustomBinding(helper, locale, nodeName, mf, mfName, moduleType, customBndVersion, errors);
        }
        if (jaxwsType || jaxrpcType) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "module file, " + mfName + ", contains " + moduleType);
            }
            String managedNode2 = null;
            List managedNodes = this.getManagedNodes();
            this.validateEJB(mfName, helper, locale, mf, moduleType, errors);
            if (managedNodes != null && managedNodes.size() > 0) {
                for (String managedNode2 : managedNodes) {
                    if (!managedNode2.equals(nodeName)) continue;
                    this.validate(helper, locale, nodeName, mf, mfName, moduleType, errors);
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(ModuleFile, nodeName)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateCustomBinding(ManagedObjectMetadataHelper helper, Locale locale, String node, ModuleFile mf, String mfName, String moduleType, String customBndVersion, List results) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validateCustomBinding(helper, locale, node, mf, moduleType, results)", new Object[]{node, mfName, moduleType, customBndVersion});
        }
        try {
            block6: {
                try {
                    SortedMap productMap = helper.getNodeProductVersions(node);
                    String baseVersion = helper.getNodeBaseProductVersion(node);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Product map for node, " + node + ", is " + productMap);
                        Tr.debug(tc, "baseVersion=" + baseVersion);
                    }
                    if (!customBndVersion.equals("7.0.0.0") || Utils.compareVersions((String)baseVersion, (String)"7.0.0") >= 0) break block6;
                    this.addWarning(mfName, moduleType, node, locale, results, "CWSAD0079W");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "cannot deploy module " + mfName + " with custom binding version " + customBndVersion + " to node " + node);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.className, FFDC_ID_1);
                    Object var12_13 = null;
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "DeploymentValidation.validateCustomBinding(helper, locale, node, mf, moduleType, results)", new Object[]{node, mf.getName(), moduleType, customBndVersion});
                    return;
                }
            }
            Object var12_12 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "DeploymentValidation.validateCustomBinding(helper, locale, node, mf, moduleType, results)", new Object[]{node, mf.getName(), moduleType, customBndVersion});
            return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "DeploymentValidation.validateCustomBinding(helper, locale, node, mf, moduleType, results)", new Object[]{node, mf.getName(), moduleType, customBndVersion});
            throw throwable;
        }
    }

    private static WorkSpace getWorkSpace(Session session) throws Exception {
        WorkSpace workspace;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpace", session);
        }
        WorkSpaceManager workspaceMan = WorkSpaceManagerFactory.getManager();
        try {
            workspace = session.isShareWorkspace() ? workspaceMan.getWorkSpace(session.getUserName()) : workspaceMan.getWorkSpace(session.toString());
        }
        catch (WorkSpaceException ex) {
            throw new Exception(ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpace", workspace);
        }
        return workspace;
    }
}

