/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.util.Utils;
import com.ibm.wsspi.management.tools.NodeSideExtensionChecker;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class AddNodeValidation
implements NodeSideExtensionChecker {
    private static TraceComponent tc = Tr.register(AddNodeValidation.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    protected String className = this.getClass().getName();
    private ResourceBundle res = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());

    public void checkCompatibility(Properties localNodeMetadataProp, Properties dmgrMetadataProp, AdminClient acToDmgr) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AddNodeValidation.checkCompatibility()");
        }
        for (String string : localNodeMetadataProp.keySet()) {
            if (string.indexOf("WebServicesFeaturePackProductVersion") <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking " + string);
            }
            String nodeVer = localNodeMetadataProp.getProperty(string);
            String dmgrVer = dmgrMetadataProp.getProperty(string);
            if (dmgrVer == null || dmgrVer.length() == 0) {
                String version = dmgrMetadataProp.getProperty("com.ibm.websphere.baseProductVersion");
                String majorVersion = this.getMajorVersion(version);
                if (majorVersion != null && "7".compareTo(majorVersion) <= 0) break;
                throw new AdminException(this.getFormattedMessage("CWSAD0015E", new String[]{nodeVer}, null));
            }
            if (Utils.compareVersions((String)dmgrVer, (String)nodeVer) >= 0) break;
            throw new AdminException(this.getFormattedMessage("CWSAD0014E", new String[]{dmgrVer, nodeVer}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AddNodeValidation.checkCompatibility()");
        }
    }

    private String getMajorVersion(String version) {
        String majorVersion = null;
        if (version != null) {
            int i = version.indexOf(46);
            majorVersion = i == -1 ? version : version.substring(0, i);
        }
        return majorVersion;
    }

    private String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = this.res.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            return defaultString;
        }
    }
}

