/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.webservices.admin.component.WebServicesAdminComponent;
import com.ibm.ws.webservices.admin.management.EndpointCentralManager;
import com.ibm.ws.webservices.admin.status.AppTargetCache;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;

public class WebServicesAdminComponentImpl
extends WsComponentImpl
implements WebServicesAdminComponent,
ConfigChangeListener {
    private static TraceComponent _tc = Tr.register(WebServicesAdminComponentImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static String DEPLOYMENT_URI_SUFFIXES = "/deployment.xml";
    private static String CLUSTER_URI_SUFFIXES = "/cluster.xml";
    private Object compImplServiceKey = null;
    private boolean enabled = false;
    private static final String FFDC_ID_1 = "FFDC-1";

    public void initialize(Object obj) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        super.initialize(obj);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        try {
            this.compImplServiceKey = WsServiceRegistry.addService(this, WebServicesAdminComponent.class);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Registered WebServicesAdminComponent object");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.admin.component.WebServicesAdminComponentImpl.initialize", FFDC_ID_1, this);
            Object[] inserts = new Object[]{this.getName(), e};
            String msg = NLSProvider.getNLS().getFormattedMessage("compInitFail00", inserts, "Error occurred while attempting to initialize component {0}: {1}");
            Tr.error(_tc, "compInitFail00", inserts);
            throw new ComponentDisabledException(msg, e);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initialize");
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        WsServiceRegistry.unregisterService(this.compImplServiceKey);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Unregistered WebServicesAdminComponent object.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        super.start();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        try {
            String processType = AdminServiceFactory.getAdminService().getProcessType();
            if (processType.equals("DeploymentManager") || processType.equals("UnManagedProcess")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "start, in dMgr or standalone server, add config listener and activate the MBean");
                }
                Admin admin = WsServiceRegistry.getService(this, Admin.class);
                admin.addConfigChangeListener(this);
                this.enabled = true;
                DefaultRuntimeCollaborator rtc = new DefaultRuntimeCollaborator(new EndpointCentralManager());
                MBeanFactory factory = AdminServiceFactory.getMBeanFactory();
                String descriptor = "com/ibm/ws/webservices/admin/descriptor/xml/EndpointCentralManager.xml";
                factory.activateMBean("EndpointCentralManager", rtc, "EndpointCentralManager", descriptor);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "start, EndpointCentralMBean is activated");
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.start", "232", this);
            throw new RuntimeWarning(e);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "start");
            }
        }
    }

    public void stop() {
        super.stop();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void configChanged(ConfigRepositoryEvent event) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "configChanged");
        }
        ConfigChangeNotifier[] changes = event.getChanges();
        for (int i = 0; i < changes.length; ++i) {
            String uri = changes[i].getUri();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "configChanged, uri=" + uri);
            }
            if (uri.endsWith(DEPLOYMENT_URI_SUFFIXES)) {
                AppTargetCache.clearCacheForApp(this.getLastDir(uri));
            }
            if (!uri.endsWith(CLUSTER_URI_SUFFIXES)) continue;
            AppTargetCache.clearCacheForClusterTarget(this.getLastDir(uri));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "configChanged");
        }
    }

    private String getLastDir(String uri) {
        uri.replace(File.separatorChar, '/');
        int index = uri.lastIndexOf(47);
        String str1 = uri.substring(0, index);
        index = str1.lastIndexOf(47);
        str1 = str1.substring(index + 1);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getLastDir, uri=" + uri + ", lastDir=" + str1);
        }
        return str1;
    }
}

