/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.commands.j2eeStep;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexWorkSpaceHelper;
import java.util.List;
import java.util.Properties;

public class ListIndexFilesJ2EEStep
extends AbstractCommandStep
implements ServiceIndexConstants {
    private static String SOURCE_FILE = "com.ibm.ws.webservices.admin.commands.ListIndexFilesJ2EEStep";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static TraceComponent tc = Tr.register(ListIndexFilesJ2EEStep.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public ListIndexFilesJ2EEStep(AbstractTaskCommand parent, CommandMetadata metadata) {
        super(parent, metadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new ListIndexFilesJ2EEStep, name=" + this.getName());
        }
    }

    public ListIndexFilesJ2EEStep(AbstractTaskCommand parent, CommandData commandData) throws CommandNotFoundException {
        super(parent, commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new ListIndexFilesJ2EEStep, name=" + this.getName());
        }
    }

    protected void executeStep() {
        TaskCommandResultImpl taskResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeStep");
        }
        if (!(taskResult = (TaskCommandResultImpl)this.taskCmd.getCommandResult()).isSuccessful()) {
            return;
        }
        try {
            CommandResultImpl result = new CommandResultImpl();
            this.setCommandResult(result);
            String appName = (String)this.taskCmd.getParameter("application");
            String moduleName = null;
            if (this.taskCmd.listSetParams().size() > 2) {
                moduleName = (String)this.taskCmd.getParameter("module");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "executeStep appName=" + appName + ", moduleName=" + moduleName);
            }
            ServiceIndexWorkSpaceHelper helper = ServiceIndexHelperFactory.createWorkSpaceHelper("application");
            Properties props = new Properties();
            if (appName != null) {
                props.setProperty("application", appName);
            }
            if (moduleName != null) {
                props.setProperty("module", moduleName);
            }
            List indexFiles = helper.listServiceIndexFiles(this.getConfigSession(), props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListIndexFilesJ2EEStep, indexFiles " + indexFiles.size());
            }
            result.setResult(indexFiles);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, SOURCE_FILE + ".executeStep", FFDC_ID_1, this);
            t.printStackTrace();
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.taskCmd.getTaskCommandResult();
            result.setException(t);
        }
    }
}

