/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.commands.CommandBase;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import java.util.List;

public class ListWebServiceOperations
extends CommandBase {
    private static TraceComponent tc = Tr.register(ListWebServiceOperations.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public ListWebServiceOperations(TaskCommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ListWebServiceOperations(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResultImpl taskResult = (TaskCommandResultImpl)this.getCommandResult();
        try {
            List helperList;
            String appName = (String)this.getParameter("application");
            String moduleName = (String)this.getParameter("module");
            String serviceName = (String)this.getParameter("service");
            String endpointName = (String)this.getParameter("logicalEndpoint");
            Boolean clientBoolean = (Boolean)this.getParameter("client");
            boolean client = false;
            if (clientBoolean != null) {
                client = clientBoolean;
            }
            if ((helperList = this.getIndexHelpersFromSteps(taskResult, appName, moduleName)).size() != 1) {
                this.handleErrors(helperList, appName, moduleName, serviceName);
            } else {
                ServiceIndexHelper helper = (ServiceIndexHelper)helperList.get(0);
                taskResult.setResult(helper.listOperations(serviceName, endpointName, client));
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.className + ".afterStepsExecuted", FFDC_ID_1);
            taskResult.setException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

