/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.WebServiceAdminConstants;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import com.ibm.ws.webservices.admin.utils.ServiceIndexMgrUtils;
import com.ibm.wsspi.webservices.admin.extensions.ServiceIndexManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class ListServices
extends AbstractAdminCommand
implements ServiceIndexConstants,
WebServiceAdminConstants {
    private static TraceComponent tc = Tr.register(ListServices.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public ListServices(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ListServices(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private void validateParameters(Properties queryProps, String expandResource) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateParameters", new Object[]{queryProps, expandResource});
        }
        StringBuffer invalidProps = ServiceIndexMgrUtils.validatePropertyNames(queryProps);
        StringBuffer invalidPropValues = ServiceIndexMgrUtils.validatePropertyValues(queryProps, expandResource);
        if (invalidProps.length() > 0) {
            throw new CommandValidationException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0019E", new Object[]{invalidProps.toString()}, "Invalid property name: " + invalidProps.toString()));
        }
        if (invalidPropValues.length() > 0) {
            throw new CommandValidationException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0020E", new Object[]{invalidPropValues.toString()}, "Invalid property values: " + invalidProps.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void execute() {
        Locale locale;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        if ((locale = this.getLocale()) == null) {
            locale = Locale.getDefault();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, ", AbstractAdminCommand.getLocale returns null, so use Locale.getDefault() instead");
            }
        }
        this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", locale);
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            Properties queryProps = (Properties)this.getParameter("queryProps");
            String expandResource = (String)this.getParameter("expandResource");
            this.validateParameters(queryProps, expandResource);
            ArrayList retList = new ArrayList();
            ArrayList packagePropList = new ArrayList();
            List mgrs = ServiceIndexMgrUtils.getServiceIndexManagers(queryProps, packagePropList);
            this.checkConflictPackageError(packagePropList);
            if (mgrs != null) {
                ServiceIndexManager siMgr = null;
                List siFileList = null;
                ServiceIndexHelper siHelper = null;
                Properties fileProps = null;
                for (int i = 0; i < mgrs.size(); ++i) {
                    siMgr = (ServiceIndexManager)mgrs.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "execute, get ServiceIndexManager for asset type " + siMgr.getAssetType());
                    }
                    if ((siFileList = siMgr.listServiceIndexFiles(session, queryProps)) == null || siFileList.size() == 0) continue;
                    for (int k = 0; k < siFileList.size(); ++k) {
                        fileProps = (Properties)siFileList.get(k);
                        this.validateFileProps(fileProps, queryProps);
                        siHelper = ServiceIndexHelperFactory.createHelper(fileProps);
                        retList.addAll(siHelper.listServices(queryProps, expandResource));
                    }
                }
            }
            this.checkResult(retList, queryProps);
            result.setResult(retList);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "execute: catch exception " + t.toString());
                t.printStackTrace();
            }
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private void validateFileProps(Properties fileProps, Properties queryProps) throws NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFileProps", new Object[]{fileProps, queryProps});
        }
        Enumeration<Object> keyEnum = fileProps.keys();
        String key = null;
        String value = null;
        String packageName = null;
        while (keyEnum.hasMoreElements()) {
            key = (String)keyEnum.nextElement();
            if (key.equals("file") || !(value = fileProps.getProperty(key)).equals("PackageNotExist")) continue;
            packageName = queryProps.getProperty(key);
            throw new NoItemFoundException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0018E", new Object[]{packageName, key}, "No asset package is found: " + packageName + " for " + key));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFileProps");
        }
    }

    private void checkConflictPackageError(List packagePropList) throws CommandValidationException {
        if (packagePropList.size() > 1) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < packagePropList.size(); ++i) {
                buf.append((String)packagePropList.get(i));
                if (i >= packagePropList.size() - 1) continue;
                buf.append(", ");
            }
            throw new CommandValidationException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0021E", new Object[]{buf.toString()}, "The command parameters contain the following conflicting properties: " + buf.toString()));
        }
    }

    private void checkResult(List retList, Properties queryProps) throws NoItemFoundException {
        if (!retList.isEmpty() || queryProps == null) {
            return;
        }
        String serviceName = queryProps.getProperty("service");
        if (serviceName != null) {
            throw new NoItemFoundException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0005E", new Object[]{serviceName}, "No web service is found: "));
        }
    }
}

