/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.webservices.admin.WebServiceAdminConstants;
import com.ibm.ws.webservices.admin.exceptions.MultipleItemsFoundException;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class CommandBase
extends AbstractTaskCommand
implements ServiceIndexConstants,
WebServiceAdminConstants {
    private static TraceComponent tc = Tr.register(CommandBase.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private ResourceBundle resourceBundle = null;

    public CommandBase(TaskCommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor metadata=" + metadata);
        }
    }

    public CommandBase(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    protected List getIndexHelpersFromSteps(TaskCommandResultImpl taskResult, String appName, String moduleName) throws Exception {
        Locale locale;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIndexHelpersFromSteps, ", new Object[]{appName, moduleName});
        }
        if ((locale = this.getLocale()) == null) {
            locale = Locale.getDefault();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getIndexHelpersFromSteps, AbstractCommand.getLocale returns null, so use Locale.getDefault() instead");
            }
        }
        this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", locale);
        String[] stepNames = this.listCommandSteps();
        this.validateStepResults(taskResult, stepNames, appName, moduleName);
        ArrayList<ServiceIndexHelper> mergedList = new ArrayList<ServiceIndexHelper>();
        Properties fileDesc = null;
        List stepResultList = null;
        boolean trDebug = tc.isDebugEnabled();
        for (int i = 0; i < stepNames.length; ++i) {
            stepResultList = (List)taskResult.getStepResult(stepNames[i]).getResult();
            if (stepResultList == null || stepResultList.size() == 0) continue;
            for (int k = 0; k < stepResultList.size(); ++k) {
                fileDesc = (Properties)stepResultList.get(k);
                if (trDebug) {
                    Tr.debug(tc, "getIndexHelpersFromSteps, step=" + stepNames[i] + ", file properties is " + fileDesc.toString());
                }
                mergedList.add(ServiceIndexHelperFactory.createHelper(fileDesc));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIndexHelpersFromSteps, return list size " + mergedList.size());
        }
        return mergedList;
    }

    private void validateStepResults(TaskCommandResultImpl taskResult, String[] stepNames, String appName, String moduleName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateStepResults", new Object[]{appName, moduleName});
        }
        if (appName == null) {
            return;
        }
        Properties fileDesc = null;
        List stepResultList = null;
        boolean trDebug = tc.isDebugEnabled();
        for (int i = 0; i < stepNames.length; ++i) {
            stepResultList = (List)taskResult.getStepResult(stepNames[i]).getResult();
            if (stepResultList == null || stepResultList.size() == 0) {
                if (!trDebug) continue;
                Tr.debug(tc, "validateStepResults, step=" + stepNames[i] + ", no serviceIndex.xml is found");
                continue;
            }
            String thisAppName = null;
            String thisModuleName = null;
            for (int k = 0; k < stepResultList.size(); ++k) {
                fileDesc = (Properties)stepResultList.get(k);
                if (trDebug) {
                    Tr.debug(tc, "validateStepResults, step=" + stepNames[i] + ", file properties is " + fileDesc.toString());
                }
                thisAppName = fileDesc.getProperty("application");
                thisModuleName = fileDesc.getProperty("module");
                if ("PackageNotExist".equals(thisAppName)) {
                    throw new NoItemFoundException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0003E", new Object[]{appName}, "No application is found: " + appName));
                }
                if (!"PackageNotExist".equals(thisModuleName)) continue;
                throw new NoItemFoundException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0004E", new Object[]{moduleName}, "No module is found: " + moduleName));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateStepResults");
        }
    }

    protected void handleErrors(List helperList, String appName, String moduleName, String serviceName) throws NoItemFoundException, MultipleItemsFoundException {
        if (helperList.size() == 0) {
            throw new NoItemFoundException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0005E", new Object[]{""}, "No web service is found: "));
        }
        if (helperList.size() > 1) {
            if (tc.isDebugEnabled()) {
                for (int i = 0; i < helperList.size(); ++i) {
                    Tr.debug(tc, "handleErrors, multiple service index files, app=" + appName + ", module=" + moduleName);
                }
            }
            throw new MultipleItemsFoundException(CommonUtils.getFormattedMessage(this.resourceBundle, "CWSAD0005E", new Object[]{appName, moduleName}, "Multiple services index files are found when no more than one file is expected"));
        }
    }
}

