/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.container.BaseConfiguration;
import com.ibm.ws.container.ErrorPage;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebAppConfiguration
extends BaseConfiguration
implements WebAppConfig {
    private int version;
    private String contextRoot;
    private int sessionTimeout;
    private String displayName;
    private String description;
    private int reloadInterval;
    private boolean distributable;
    private boolean reloadingEnabled;
    private Boolean serveServletsByClassnameEnabled;
    private String defaultErrorPage;
    private String additionalClassPath;
    private Boolean fileServingEnabled;
    private Boolean directoryBrowsingEnabled;
    private boolean autoRequestEncoding;
    private boolean autoResponseEncoding;
    private boolean autoLoadFilters;
    private Map requestListeners;
    private Map requestAttributeListeners;
    private Map sessionListeners;
    private HashMap localeMap;
    private String moduleName;
    private String moduleId;
    private boolean isSyncToThreadEnabled;
    private boolean isSystemApp;
    private boolean ardEnabled;
    private String ardDispatchType;
    private ArrayList listeners = new ArrayList();
    private ArrayList welcomeFileList = new ArrayList();
    private HashMap servletMappings;
    private List filterMappings;
    private HashMap servletInfo;
    private HashMap filterInfo;
    private HashMap mimeMappings = new HashMap();
    private HashMap mimeFilters;
    private boolean isMimeFilteringEnabled = false;
    public WebGroup theWebGroup;
    private HashMap jspAttributes = new HashMap();
    private HashMap fileServingAttributes = new HashMap();
    private HashMap invokerAttributes = new HashMap();
    private HashMap contextParams = new HashMap();
    private String virtualHost;
    private HashMap exceptionErrorPages = new HashMap();
    private HashMap codeErrorPages = new HashMap();
    private List tagLibList;
    private boolean precompileJsps;
    private WebApp webApp;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.webapp");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.webapp.WebAppConfiguration";
    private List virtualHostList = new ArrayList();
    private int appStartupWeight;
    private int moduleStartupWeight;
    private boolean metaDataComplete;
    private List<Class<?>> classesToScan;
    private static String disallowAllFileServingProp;
    private static String disallowServeServletsByClassnameProp;

    public WebAppConfiguration(String id) {
        super(id);
        this.servletInfo = new HashMap();
        this.servletMappings = new HashMap();
        this.filterInfo = new HashMap();
        this.filterMappings = new ArrayList();
        this.classesToScan = new ArrayList();
    }

    public String getAdditionalClassPath() {
        return this.additionalClassPath;
    }

    @Override
    public List getVirtualHostList() {
        return this.virtualHostList;
    }

    public Iterator getServletNames() {
        return this.servletInfo.keySet().iterator();
    }

    @Override
    public void addServletInfo(String name, IServletConfig info) {
        this.servletInfo.put(name, info);
    }

    public void removeServletInfo(String name) {
        this.servletInfo.remove(name);
    }

    @Override
    public Iterator getServletInfos() {
        return this.servletInfo.values().iterator();
    }

    @Override
    public Iterator getFilterInfos() {
        return this.filterInfo.values().iterator();
    }

    public boolean isAutoRequestEncoding() {
        return this.autoRequestEncoding;
    }

    @Override
    public boolean isAutoResponseEncoding() {
        return this.autoResponseEncoding;
    }

    public String getDefaultErrorPage() {
        return this.defaultErrorPage;
    }

    public boolean isDirectoryBrowsingEnabled() {
        if (this.directoryBrowsingEnabled != null) {
            return this.directoryBrowsingEnabled;
        }
        this.directoryBrowsingEnabled = WCCustomProperties.DIRECTORY_BROWSING_ENABLED;
        return this.directoryBrowsingEnabled;
    }

    public boolean isFileServingEnabled() {
        disallowAllFileServingProp = WCCustomProperties.DISALLOW_ALL_FILE_SERVING;
        if (disallowAllFileServingProp != null && !this.getApplicationName().equalsIgnoreCase("isclite")) {
            try {
                if (Boolean.valueOf(disallowAllFileServingProp).booleanValue()) {
                    this.fileServingEnabled = Boolean.FALSE;
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isFileServing", "PK54499: disallowAllFileServingProp set to " + disallowAllFileServingProp + " for application: " + this.getApplicationName());
                }
            }
            catch (Exception x) {
                logger.logp(Level.SEVERE, CLASS_NAME, "isFileServing", "Illegal value set for property com.ibm.ws.webcontainer.disallowallfileserving");
            }
        }
        if (this.fileServingEnabled != null) {
            return this.fileServingEnabled;
        }
        return WCCustomProperties.FILE_SERVING_ENABLED;
    }

    public HashMap getMimeMappings() {
        return this.mimeMappings;
    }

    public boolean isReloadingEnabled() {
        return this.reloadingEnabled;
    }

    public int getReloadInterval() {
        return this.reloadInterval;
    }

    public Map getRequestAttributeListeners() {
        return this.requestAttributeListeners;
    }

    public Map getRequestListeners() {
        return this.requestListeners;
    }

    public Map getSessionListeners() {
        return this.sessionListeners;
    }

    public void setAdditionalClassPath(String additionalClassPath) {
        this.additionalClassPath = additionalClassPath;
    }

    public void setAutoRequestEncoding(boolean autoRequestEncoding) {
        this.autoRequestEncoding = autoRequestEncoding;
    }

    public void setAutoResponseEncoding(boolean autoResponseEncoding) {
        this.autoResponseEncoding = autoResponseEncoding;
    }

    public void setDefaultErrorPage(String defaultErrorPage) {
        this.defaultErrorPage = defaultErrorPage;
    }

    public void setDirectoryBrowsingEnabled(Boolean directoryBrowsingEnabled) {
        this.directoryBrowsingEnabled = directoryBrowsingEnabled;
    }

    public void setFileServingEnabled(Boolean fileServingEnabled) {
        this.fileServingEnabled = fileServingEnabled;
    }

    public void setMimeMappings(HashMap mimeMappings) {
        this.mimeMappings = mimeMappings;
    }

    public void setReloadingEnabled(boolean reloadingEnabled) {
        this.reloadingEnabled = reloadingEnabled;
    }

    public void setReloadInterval(int reloadInterval) {
        this.reloadInterval = reloadInterval;
    }

    public void setRequestAttributeListeners(Map requestAttributeListeners) {
        this.requestAttributeListeners = requestAttributeListeners;
    }

    public void setRequestListeners(Map requestListeners) {
        this.requestListeners = requestListeners;
    }

    public void setSessionListeners(Map sessionListeners) {
        this.sessionListeners = sessionListeners;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Map getJspAttributes() {
        return this.jspAttributes;
    }

    public void setJspAttributes(HashMap jspAttributes) {
        this.jspAttributes = jspAttributes;
    }

    public String toString() {
        return this.displayName;
    }

    public HashMap getContextParams() {
        return this.contextParams;
    }

    public void setContextParams(HashMap contextParams) {
        this.contextParams = contextParams;
    }

    @Override
    public IServletConfig getServletInfo(String servletName) {
        return (IServletConfig)this.servletInfo.get(servletName);
    }

    public HashMap getFileServingAttributes() {
        return this.fileServingAttributes;
    }

    public void setFileServingAttributes(HashMap fileServingAttributes) {
        this.fileServingAttributes = fileServingAttributes;
    }

    public boolean isServeServletsByClassnameEnabled() {
        disallowServeServletsByClassnameProp = WCCustomProperties.DISALLOW_SERVE_SERVLETS_BY_CLASSNAME_PROP;
        if (disallowServeServletsByClassnameProp != null) {
            try {
                if (Boolean.valueOf(disallowServeServletsByClassnameProp).booleanValue()) {
                    this.serveServletsByClassnameEnabled = Boolean.FALSE;
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isServeServletsByClassnameEnabled", "PK52059: disallowServeServletsByClassnameProp set to " + disallowServeServletsByClassnameProp + " for application: " + this.getApplicationName());
                }
            }
            catch (Exception x) {
                logger.logp(Level.SEVERE, CLASS_NAME, "isServeServletsByClassnameEnabled", "Illegal value set for property com.ibm.ws.webcontainer.disallowserveservletsbyclassname");
            }
        }
        if (this.serveServletsByClassnameEnabled != null) {
            return this.serveServletsByClassnameEnabled;
        }
        return WCCustomProperties.SERVE_SERVLETS_BY_CLASSNAME_ENABLED;
    }

    public void setServeServletsByClassnameEnabled(Boolean serveServletsByClassname) {
        this.serveServletsByClassnameEnabled = serveServletsByClassname;
    }

    public HashMap getInvokerAttributes() {
        return this.invokerAttributes;
    }

    public void setInvokerAttributes(HashMap invokerAttributes) {
        this.invokerAttributes = invokerAttributes;
    }

    public List getFilterMappings() {
        return this.filterMappings;
    }

    public void setFilterMappings(List filterMappings) {
        this.filterMappings = filterMappings;
    }

    public IFilterConfig getFilterInfo(String filterName) {
        return (IFilterConfig)this.filterInfo.get(filterName);
    }

    public void addFilterInfo(IFilterConfig config2) {
        this.filterInfo.put(config2.getFilterName(), config2);
    }

    @Override
    public String getVirtualHostName() {
        return this.virtualHost;
    }

    public HashMap getServletMappings() {
        return this.servletMappings;
    }

    public void setServletMappings(HashMap servletMappings) {
        this.servletMappings = servletMappings;
    }

    public List getServletMappings(String servletName) {
        return (List)this.servletMappings.get(servletName);
    }

    public HashMap getMimeFilters() {
        return this.mimeFilters;
    }

    public void setMimeFilters(HashMap mimeFilters) {
        if (mimeFilters != null && mimeFilters.size() > 0) {
            this.isMimeFilteringEnabled = true;
        }
        this.mimeFilters = mimeFilters;
    }

    public String getMimeType(String extension) {
        return (String)this.mimeMappings.get(extension);
    }

    public ErrorPage getErrorPageTraverseRootCause(Throwable th) {
        Throwable rootCause;
        while (th != null && th instanceof ServletException && (rootCause = ((ServletException)th).getRootCause()) != null) {
            ErrorPage er = this.getErrorPageByExceptionType(th);
            if (er != null) {
                return er;
            }
            th = rootCause;
        }
        if (th != null) {
            return this.getErrorPageByExceptionType(th);
        }
        return null;
    }

    public ErrorPage getErrorPageByExceptionType(Throwable rootException) {
        String exceptionName = rootException.getClass().getName();
        Object obj = this.exceptionErrorPages.get(exceptionName);
        if (obj != null) {
            return (ErrorPage)obj;
        }
        Iterator i = this.exceptionErrorPages.values().iterator();
        ErrorPage curEP = null;
        ClassLoader warClassLoader = this.getWebApp().getClassLoader();
        while (i.hasNext()) {
            ErrorPage ep = (ErrorPage)i.next();
            Class exceptionClass = ep.getException(warClassLoader);
            if (exceptionClass == null || !exceptionClass.isInstance(rootException)) continue;
            if (curEP == null) {
                curEP = ep;
                continue;
            }
            if (!curEP.getException(warClassLoader).isAssignableFrom(exceptionClass)) continue;
            curEP = ep;
        }
        return curEP;
    }

    public ErrorPage getErrorPageByErrorCode(Integer code) {
        return (ErrorPage)this.codeErrorPages.get(code);
    }

    public List getWelcomeFileList() {
        return this.welcomeFileList;
    }

    public void setWelcomeFileList(ArrayList l) {
        this.welcomeFileList = l;
    }

    @Override
    public List getTagLibs() {
        return this.tagLibList;
    }

    public void setTagLibs(List l) {
        this.tagLibList = l;
    }

    public List getListeners() {
        return this.listeners;
    }

    public void addListener(String listenerClass) {
        this.listeners.add(listenerClass);
    }

    public void setListeners(ArrayList listeners) {
        this.listeners = listeners;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getApplicationName() {
        return this.webApp.getApplicationName();
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void setCodeErrorPages(HashMap codeErrorPages) {
        this.codeErrorPages = codeErrorPages;
    }

    public void setExceptionErrorPages(HashMap exceptionErrorPages) {
        this.exceptionErrorPages = exceptionErrorPages;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setServletInfos(HashMap sInfos) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setServletInfos", "servletInfo --> " + sInfos);
        }
        this.servletInfo = sInfos;
    }

    public void setAppStartupWeight(int appStartupWeight) {
        this.appStartupWeight = appStartupWeight;
    }

    @Override
    public int getAppStartupWeight() {
        return this.appStartupWeight;
    }

    public void setFilterInfos(HashMap fInfos) {
        this.filterInfo = fInfos;
    }

    @Override
    public void addServletMapping(String servletName, String urlPattern) {
        List mappings = (List)this.servletMappings.get(servletName);
        if (mappings == null) {
            ServletMapping map = new ServletMapping(this.getServletInfo(servletName), urlPattern);
            ArrayList<ServletMapping> l = new ArrayList<ServletMapping>();
            l.add(map);
            this.servletMappings.put(servletName, l);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addServletMapping", "servletInfo --> " + this.servletInfo + " servletName --> " + servletName);
            }
            ServletConfig scon = (ServletConfig)this.servletInfo.get(servletName);
            scon.setMappings(l);
        } else {
            boolean found = false;
            for (int i = 0; i < mappings.size(); ++i) {
                ServletMapping map = (ServletMapping)mappings.get(i);
                if (!map.getUrlPattern().equals(urlPattern)) continue;
                found = true;
            }
            if (!found) {
                ServletMapping map = new ServletMapping(this.getServletInfo(servletName), urlPattern);
                mappings.add(map);
            }
        }
    }

    public void setVirtualHostName(String string) {
        this.virtualHost = string;
    }

    public void setPrecompileJSPs(boolean b) {
        this.precompileJsps = b;
    }

    public boolean getPreCompileJSPs() {
        return this.precompileJsps;
    }

    public boolean isAutoLoadFilters() {
        return this.autoLoadFilters;
    }

    public void setAutoLoadFilters(boolean autoLoadFilters) {
        this.autoLoadFilters = autoLoadFilters;
    }

    public String getLocaleEncoding(Locale locale) {
        if (this.localeMap == null) {
            return null;
        }
        String encoding = (String)this.localeMap.get(locale.toString());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocaleEncoding", "locale->" + locale);
        }
        if (encoding == null) {
            encoding = (String)this.localeMap.get(locale.getLanguage() + "_" + locale.getCountry());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getLocaleEncoding", "locale->" + locale + ", language->" + locale.getLanguage() + ", country->" + locale.getCountry());
            }
            if (encoding == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getLocaleEncoding", "locale->" + locale + ", language->" + locale.getLanguage());
                }
                encoding = (String)this.localeMap.get(locale.getLanguage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocaleEncoding", "encoding->" + encoding);
        }
        return encoding;
    }

    public void addLocaleEncodingMap(String locale, String encoding) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addLocaleEncodingMap", "locale->" + locale + ", encoding->" + encoding);
        }
        if (this.localeMap == null) {
            this.localeMap = new HashMap();
        }
        this.localeMap.put(locale, encoding);
    }

    public boolean isMimeFilteringEnabled() {
        return this.isMimeFilteringEnabled;
    }

    @Override
    public boolean isServlet2_4() {
        return this.version == 24;
    }

    @Override
    public boolean isServlet2_5() {
        return this.version == 25;
    }

    @Override
    public boolean isServlet2_4OrHigher() {
        return this.version >= 24;
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    public void setWebApp(WebApp app) {
        this.webApp = app;
    }

    public void removeServletMappings(String servletName) {
        this.servletMappings.remove(servletName);
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    @Override
    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setVersion(int i) {
        this.version = i;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isSyncToThreadEnabled() {
        return this.isSyncToThreadEnabled;
    }

    public void setSyncToThreadEnabled(boolean b) {
        this.isSyncToThreadEnabled = b;
    }

    @Override
    public int getModuleStartupWeight() {
        return this.moduleStartupWeight;
    }

    public void setModuleStartupWeight(int moduleStartupWeight) {
        this.moduleStartupWeight = moduleStartupWeight;
    }

    public HashMap getCodeErrorPages() {
        return this.codeErrorPages;
    }

    public HashMap getExceptionErrorPages() {
        return this.exceptionErrorPages;
    }

    @Override
    public String getArdDispatchType() {
        return this.ardDispatchType;
    }

    @Override
    public void setArdDispatchType(String ardDispatchType) {
        this.ardDispatchType = ardDispatchType;
        if (this.ardDispatchType.equals("CLIENT_SIDE") || this.ardDispatchType.equals("SERVER_SIDE")) {
            this.ardEnabled = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setArdDispatchType", " type --> " + ardDispatchType);
        }
    }

    @Override
    public boolean isArdEnabled() {
        return this.ardEnabled;
    }

    @Override
    public void setMetadataComplete(boolean b) {
        this.metaDataComplete = b;
    }

    @Override
    public boolean isMetadataComplete() {
        return this.metaDataComplete;
    }

    @Override
    public void addClassesToScan(List<Class<?>> list) {
        this.classesToScan.addAll(list);
    }

    @Override
    public List<Class<?>> getClassesToScan() {
        return this.classesToScan;
    }

    @Override
    public boolean isSystemApp() {
        return this.isSystemApp;
    }

    public void setSystemApp(boolean b) {
        this.isSystemApp = b;
    }
}

