/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.FileServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class StaticFileServletWrapper
extends FileServletWrapper {
    private File file;
    RandomAccessFile raf = null;
    private int contentLength = -1;

    public StaticFileServletWrapper(IServletContext parent, DefaultExtensionProcessor parentProcessor, File file) {
        super(parent, parentProcessor);
        this.file = file;
    }

    public String getServletName() {
        return "Static File wrapper";
    }

    protected InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    protected RandomAccessFile getRandomAccessFile() throws IOException {
        this.raf = new RandomAccessFile(this.file, "rw");
        return this.raf;
    }

    protected long getLastModified() {
        return this.file.lastModified();
    }

    protected int getContentLength(boolean update) {
        if (update) {
            this.contentLength = (int)this.file.length();
            return this.contentLength;
        }
        if (this.contentLength == -1) {
            this.contentLength = (int)this.file.length();
            return this.contentLength;
        }
        return this.contentLength;
    }

    protected int getContentLength() {
        return this.getContentLength(true);
    }

    public void setParent(IServletContext parent) {
    }

    public boolean isAvailable() {
        return this.file.exists();
    }
}

