/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.context.IBMServletContext;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FilterProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 3544394690804857138L;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.FilterProxyServlet";
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    public void dispatch(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String browsedirResource;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "dispatch", "FilterProxyServlet.dispatch(): request is of type -->" + request);
            logger.logp(Level.FINE, CLASS_NAME, "dispatch", "FilterProxyServlet.dispatch(): response is of type -->" + response);
        }
        if ((browsedirResource = (String)request.getAttribute("com.ibm.ws.webcontainer.browsedir.url")) != null) {
            request.removeAttribute("com.ibm.ws.webcontainer.browsedir.url");
            RequestDispatcher dispatcherBrowse = request.getRequestDispatcher(browsedirResource);
            dispatcherBrowse.forward(request, response);
            return;
        }
        String welcomeResource = (String)request.getAttribute("com.ibm.ws.webcontainer.welcomefile.url");
        if (welcomeResource != null) {
            request.removeAttribute("com.ibm.ws.webcontainer.welcomefile.url");
            RequestDispatcher dispatcher = request.getRequestDispatcher(welcomeResource);
            dispatcher.forward(request, response);
            return;
        }
        String welcomeRedirectResource = (String)request.getAttribute("com.ibm.ws.webcontainer.welcomefile.redirecturl");
        if (welcomeRedirectResource != null) {
            request.removeAttribute("com.ibm.ws.webcontainer.welcomefile.redirecturl");
            HttpServletResponse res = (HttpServletResponse)response;
            res.sendRedirect(res.encodeRedirectURL(welcomeRedirectResource));
            return;
        }
        Object fileNotFound = request.getAttribute("com.ibm.ws.webcontainer.filter.filenotfound");
        if (fileNotFound instanceof ServletErrorReport) {
            String isJspRequest;
            ServletErrorReport fileNotFoundErrorReport = (ServletErrorReport)fileNotFound;
            request.removeAttribute("com.ibm.ws.webcontainer.filter.filenotfound");
            if (WCCustomProperties.THROW_MISSING_JSP_EXCEPTION && (isJspRequest = (String)request.getAttribute("com.ibm.ws.webcontainer.filter.isjsprequest")) != null) {
                request.removeAttribute("com.ibm.ws.webcontainer.filter.isjsprequest");
                if (isJspRequest.equalsIgnoreCase("true")) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "dispatch", "JSP was not found and PK57843 (or PK65408) is active, throwing FileNotFoundException");
                    }
                    FileNotFoundException fex = new FileNotFoundException();
                    ((HttpServletResponse)response).setStatus(404);
                    throw fex;
                }
            }
            if (WCCustomProperties.MODIFIED_FNF_BEHAVIOR) {
                FileNotFoundException fex = new FileNotFoundException();
                ((HttpServletResponse)response).setStatus(404);
                throw fex;
            }
            FFDCFilter.processException((Throwable)fileNotFoundErrorReport, "com.ibm.ws.webcontainer.servlet.FilterProxyServlet.dispatch", "312", this);
            try {
                ((IBMServletContext)this.getServletContext()).sendError((HttpServletRequest)request, (HttpServletResponse)response, fileNotFoundErrorReport);
            }
            catch (Exception e) {
                logger.logp(Level.FINE, CLASS_NAME, "dispatch", "Exception while calling sendError", e);
            }
            return;
        }
        if (fileNotFound instanceof FileNotFoundException) {
            String isJspRequest;
            Exception fileNotFoundFilterException = (Exception)fileNotFound;
            request.removeAttribute("com.ibm.ws.webcontainer.filter.filenotfound");
            if (WCCustomProperties.THROW_MISSING_JSP_EXCEPTION && (isJspRequest = (String)request.getAttribute("com.ibm.ws.webcontainer.filter.isjsprequest")) != null) {
                request.removeAttribute("com.ibm.ws.webcontainer.filter.isjsprequest");
                if (isJspRequest.equalsIgnoreCase("true")) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "dispatch", "JSP was not found and PK57843 is active, throwing FileNotFoundException");
                    }
                    FileNotFoundException fex = new FileNotFoundException();
                    throw fex;
                }
            }
            FFDCFilter.processException((Throwable)fileNotFoundFilterException, "com.ibm.ws.webcontainer.servlet.FilterProxyServlet.dispatch", "313", this);
            try {
                ((HttpServletResponse)response).sendError(404, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), fileNotFoundFilterException.getMessage()));
            }
            catch (Exception ex) {
                logger.logp(Level.FINE, CLASS_NAME, "dispatch", "Exception while calling sendError", ex);
            }
        }
    }
}

