/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.exception.NoTargetForURIException;
import com.ibm.ws.webcontainer.util.InvalidCacheTargetException;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletReferenceListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheServletWrapper
implements RequestProcessor,
ServletReferenceListener {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.CacheServletWrapper";
    private String _servletPath;
    private String _pathInfo;
    private IServletWrapper cacheTarget;
    private HashMap cache;
    private String cacheKeyStr;
    private volatile boolean isValid = false;
    private WebApp webapp;
    private String requestUri;

    public CacheServletWrapper(IServletWrapper wrapper, HttpServletRequest req, HashMap cache, StringBuilder cacheKey, WebApp webapp) {
        this.cacheTarget = wrapper;
        this.cacheTarget.addServletReferenceListener(this);
        this._pathInfo = req.getPathInfo();
        this._servletPath = req.getServletPath();
        this.requestUri = req.getRequestURI();
        this.cache = cache;
        this.cacheKeyStr = cacheKey.toString();
        this.webapp = webapp;
        cache.put(this.cacheKeyStr, this);
        this.isValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        block12: {
            IServletWrapper target;
            boolean validity;
            CacheServletWrapper cacheServletWrapper = this;
            synchronized (cacheServletWrapper) {
                validity = this.isValid;
                target = this.cacheTarget;
            }
            try {
                if (!validity) {
                    throw InvalidCacheTargetException.instance();
                }
                target.handleRequest(req, res);
            }
            catch (NoTargetForURIException se) {
                WebAppErrorReport r = new WebAppErrorReport(se);
                if (target != null && target instanceof IServletWrapper) {
                    r.setTargetServletName(target.getServletName());
                }
                r.setErrorCode(404);
                WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)((IExtendedRequest)req).getWebAppDispatcherContext();
                WebApp app = dispatchContext.getWebApp();
                if (req instanceof HttpServletRequest) {
                    app.sendError((HttpServletRequest)req, (HttpServletResponse)res, r);
                }
            }
            catch (ServletErrorReport ser) {
                WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)((IExtendedRequest)req).getWebAppDispatcherContext();
                WebApp app = dispatchContext.getWebApp();
                if (req instanceof HttpServletRequest) {
                    app.sendError((HttpServletRequest)req, (HttpServletResponse)res, ser);
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException(th, "com.ibm.ws.webcontainer.webapp.WebApp.handleRequest", "985", this);
                WebAppErrorReport r = new WebAppErrorReport(th);
                if (target != null && target instanceof IServletWrapper) {
                    r.setTargetServletName(target.getServletName());
                }
                r.setErrorCode(500);
                WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)((IExtendedRequest)req).getWebAppDispatcherContext();
                WebApp app = dispatchContext.getWebApp();
                if (!(req instanceof HttpServletRequest)) break block12;
                app.sendError((HttpServletRequest)req, (HttpServletResponse)res, r);
            }
        }
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public void setPathInfo(String string) {
        this._pathInfo = string;
    }

    public void setServletPath(String string) {
        this._servletPath = string;
    }

    public WebApp getWebApp() {
        if (this.cacheTarget != null) {
            return this.webapp;
        }
        throw InvalidCacheTargetException.instance();
    }

    public synchronized void invalidate() {
        if (this.isValid) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "invalidate", "first invalidate");
            }
            this.cache.remove(this.cacheKeyStr);
            this.isValid = false;
            this.cacheTarget = null;
            this._servletPath = null;
            this._pathInfo = null;
            this.cache = null;
            this.webapp = null;
            this.cacheKeyStr = null;
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "invalidate", "additional invalidate");
        }
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getCacheKeyString() {
        return this.cacheKeyStr;
    }

    public IServletWrapper getCacheTarget() {
        return this.cacheTarget;
    }

    public String toString() {
        String s = this.webapp == null ? " Webapp nulled::  " + this.webapp + "  " + " ServletPath:: " + this._servletPath + "  " + " CacheKey ::" + this.cacheKeyStr + "  " + " _pathInfo::" + this._pathInfo + "  " + " requestUri ::" + this.requestUri + "  " : " Webapp::  " + this.webapp + "  " + " ServletPath:: " + this._servletPath + "  " + " CacheKey ::" + this.cacheKeyStr + "  " + " _pathInfo::" + this._pathInfo + "  " + " requestUri ::" + this.requestUri + "  " + "ApplicationName::" + this.webapp.getApplicationName() + "  " + "WebAppContxtPath::" + this.webapp.getContextPath();
        return s;
    }
}

